/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.apimgmt.apiservice;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.ObjectUtil;
import com.digiwin.athena.apimgmt.dao.ApiMgmtProjectDao;
import com.digiwin.athena.apimgmt.dao.ApiMgmtProjectVersionDao;
import com.digiwin.athena.apimgmt.dao.ApiMgmtStandardApiDao;
import com.digiwin.athena.apimgmt.dao.ApiMgmtTenantConfigDao;
import com.digiwin.athena.apimgmt.enums.ApiAttributeEnum;
import com.digiwin.athena.apimgmt.enums.LocaleEnum;
import com.digiwin.athena.apimgmt.infra.context.ApiMgmtServiceContextHolder;
import com.digiwin.athena.apimgmt.model.AdvanceSearchValue;
import com.digiwin.athena.apimgmt.model.Project;
import com.digiwin.athena.apimgmt.model.ProjectVersion;
import com.digiwin.athena.apimgmt.model.ProjectVersionRelation;
import com.digiwin.athena.apimgmt.model.StandardApi;
import com.digiwin.athena.apimgmt.model.StandardApiVersion;
import com.digiwin.athena.apimgmt.service.model.Page;
import com.digiwin.athena.apimgmt.util.StandardApiMessageUtil;
import com.digiwin.athena.apimgmt.util.StringUtil;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.fge.jackson.JsonLoader;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AdvanceSearchApiListGetOtherService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AdvanceSearchApiListGetOtherService.class);
    @Autowired
    private ApiMgmtStandardApiDao standardApiDao;
    @Autowired
    private ApiMgmtTenantConfigDao tenantConfigDao;
    ObjectMapper mapper = new ObjectMapper();
    @Autowired
    private ApiMgmtProjectDao projectDao;
    @Autowired
    private ApiMgmtProjectVersionDao projectVersionDao;

    public Map<String, Object> execute(String validatorResult) throws Exception {
        int pPageSize;
        log.info("[Thread.id " + Thread.currentThread().getId() + "]\u63a5\u53e3: " + this.getClass() + ", \u539f\u59cb\u8a0a\u606f: " + validatorResult);
        String tLocale = ApiMgmtServiceContextHolder.getLocale();
        tLocale = tLocale == null ? LocaleEnum.EN_US.getType() : tLocale;
        ObjectNode tResponse = this.mapper.createObjectNode();
        JsonNode tRequestJsonNode = JsonLoader.fromString((String)validatorResult);
        ArrayNode tConditionArrayNode = (ArrayNode)tRequestJsonNode.get("conditionList");
        ArrayNode simpleConditionArrayNode = (ArrayNode)tRequestJsonNode.get("simpleConditionList");
        JsonNode tCategoryId = tRequestJsonNode.get("categoryId");
        JsonNode projectId = tRequestJsonNode.get("projectId");
        JsonNode projectVersionId = tRequestJsonNode.get("projectVersionId");
        JsonNode tStatusId = tRequestJsonNode.get("statusId");
        JsonNode tType = tRequestJsonNode.get("type");
        JsonNode pageNum = tRequestJsonNode.get("pageNum");
        int pPageNum = null != pageNum ? pageNum.asInt() : 1;
        JsonNode pageSize = tRequestJsonNode.get("pageSize");
        int n = pPageSize = null != pageSize ? pageSize.asInt() : 10;
        if (null == tType || StringUtil.isEmptyOrSpace((Object)tType.asBoolean())) {
            throw new Exception("\u8bf7\u9009\u62e9\u67e5\u8be2\u7c7b\u578b!");
        }
        String tToken = ApiMgmtServiceContextHolder.getToken();
        if (tType.asBoolean() && null == tToken) {
            throw new Exception("\u5f53\u524d\u7528\u6237\u672a\u767b\u5f55,\u8bf7\u767b\u5f55!");
        }
        String tTenantId = ApiMgmtServiceContextHolder.getTenantId();
        String teamType = ApiMgmtServiceContextHolder.getTeamType();
        String tUserId = ApiMgmtServiceContextHolder.getUserId();
        boolean tViewAllApi = false;
        if (!tType.asBoolean() && !StringUtil.isEmptyOrSpace((Object)tTenantId)) {
            tViewAllApi = this.tenantConfigDao.viewAllApiTenantExist(tTenantId);
        }
        List<List<AdvanceSearchValue>> arrayList = StandardApiMessageUtil.generateQuery(tConditionArrayNode, tCategoryId, tStatusId, tType, projectId, projectVersionId, tUserId);
        Long startTime = System.currentTimeMillis();
        Page<StandardApiVersion> standardApiVersionPage = this.standardApiDao.advanceApiSearch(arrayList, teamType, tTenantId, tType.asBoolean(), tViewAllApi, pPageNum, pPageSize);
        Long idsTime = System.currentTimeMillis();
        log.info("\u5206\u9875\u67e5\u8be2\u6570\u636e\u5e93\u8bf7\u6c42\u5904\u7406\u65f6\u95f4" + (idsTime - startTime));
        this.setAdvanceSearchApiResponse(standardApiVersionPage, tLocale, tResponse, tType.asBoolean());
        Long endTime = System.currentTimeMillis();
        log.info("\u5206\u9875\u67e5\u8be2\u6570\u636e\u62fc\u63a5\u8bf7\u6c42\u5904\u7406\u65f6\u95f4" + (endTime - idsTime));
        return (Map)this.mapper.convertValue((Object)tResponse, (TypeReference)new TypeReference<Map<String, Object>>(){});
    }

    public void setProjectAndVersion(List<StandardApi> apiList) {
        List<Long> projectIds = apiList.stream().flatMap(api -> api.getProjectVersionRelations().stream()).map(ProjectVersionRelation::getProjectId).distinct().collect(Collectors.toList());
        List<Long> projectVersionIds = apiList.stream().flatMap(api -> api.getProjectVersionRelations().stream()).map(ProjectVersionRelation::getProjectVersionId).distinct().collect(Collectors.toList());
        Map<Long, Project> projectMap = this.projectDao.queryByIdList(projectIds).stream().collect(Collectors.toMap(Project::getProjectId, project -> project));
        Map<Long, ProjectVersion> projectVersionMap = this.projectVersionDao.queryProjectVersionByIdList(projectVersionIds).stream().collect(Collectors.toMap(ProjectVersion::getProjectVersionId, projectVersion -> projectVersion));
        Set<Long> existVersionsProjectIds = this.projectVersionDao.selectExistProjectId(projectIds);
        apiList.forEach(api -> {
            if (CollUtil.isNotEmpty(api.getProjectVersionRelations())) {
                ProjectVersionRelation versionRelation = api.getProjectVersionRelations().get(0);
                api.setProjectName(((Project)projectMap.get(versionRelation.getProjectId())).getProjectName());
                ArrayList<String> projectVersiontNameList = new ArrayList<String>();
                api.getProjectVersionRelations().forEach(projectVersionRelation -> {
                    if (ObjectUtil.isNotNull((Object)projectVersionRelation.getProjectVersionId())) {
                        ProjectVersion projectVersion = (ProjectVersion)projectVersionMap.get(projectVersionRelation.getProjectVersionId());
                        projectVersiontNameList.add(projectVersion.getProjectVersionName());
                    }
                });
                api.setProjectVersionNameList(projectVersiontNameList);
                api.setHasVersions(existVersionsProjectIds.contains(versionRelation.getProjectId()));
            }
        });
    }

    private void setAdvanceSearchApiResponse(Page<StandardApiVersion> pStandardApiVersionPage, String tLocale, ObjectNode tResponse, boolean tType) {
        ArrayNode arrayNode = this.mapper.createArrayNode();
        if (CollUtil.isNotEmpty(pStandardApiVersionPage.getList())) {
            List<StandardApi> standardApiList = pStandardApiVersionPage.getList().stream().map(StandardApiVersion::getStandardApi).collect(Collectors.toList());
            this.setProjectAndVersion(standardApiList);
            for (StandardApiVersion tStandardApiVersion : pStandardApiVersionPage.getList()) {
                String tCategory;
                String tSyncType;
                String tRemark;
                String tDescription;
                long tApprovedStatusCode;
                String tApprovedStatus;
                StandardApi tStandardApi = tStandardApiVersion.getStandardApi();
                ObjectNode tApiMap = this.mapper.createObjectNode();
                if (!tType) {
                    if (tStandardApiVersion.getVersion().equals("1.0")) {
                        tApiMap.put("firstApplicant", tStandardApiVersion.getApplicant());
                        tApiMap.put("lastApplicant", "");
                    } else {
                        tApiMap.put("firstApplicant", tStandardApi.getFirstApplicant());
                        tApiMap.put("lastApplicant", tStandardApiVersion.getApplicant());
                    }
                }
                switch (tLocale) {
                    case "zh_CN": {
                        tApprovedStatus = tStandardApiVersion.getApprovedStatus().getNameZhCn();
                        tApprovedStatusCode = tStandardApiVersion.getApprovedStatus().getId();
                        tDescription = tStandardApi.getDescriptionZhCn();
                        tRemark = tStandardApi.getRemarkZhCn();
                        tSyncType = tStandardApi.getStandardApiSyncType().getNameZhCn();
                        tCategory = tStandardApi.getStandardApiCategory().getNameZhCn();
                        break;
                    }
                    case "zh_TW": {
                        tApprovedStatus = tStandardApiVersion.getApprovedStatus().getNameZhTw();
                        tApprovedStatusCode = tStandardApiVersion.getApprovedStatus().getId();
                        tDescription = tStandardApi.getDescriptionZhTw();
                        tRemark = tStandardApi.getRemarkZhTw();
                        tSyncType = tStandardApi.getStandardApiSyncType().getNameZhTw();
                        tCategory = tStandardApi.getStandardApiCategory().getNameZhTw();
                        break;
                    }
                    default: {
                        tApprovedStatus = tStandardApiVersion.getApprovedStatus().getNameEnUs();
                        tApprovedStatusCode = tStandardApiVersion.getApprovedStatus().getId();
                        tDescription = tStandardApi.getDescriptionEnUs();
                        tRemark = tStandardApi.getRemarkEnUs();
                        tSyncType = tStandardApi.getStandardApiSyncType().getNameEnUs();
                        tCategory = tStandardApi.getStandardApiCategory().getNameEnUs();
                    }
                }
                tApiMap.put("apiId", tStandardApi.getId());
                tApiMap.put("name", tStandardApi.getName());
                tApiMap.put("branch", tStandardApi.getBranch());
                tApiMap.put("version", tStandardApiVersion.getVersion());
                tApiMap.put("approvedStatus", tApprovedStatus);
                tApiMap.put(ApiAttributeEnum.approvedTime.toString(), DateUtil.formatLocalDateTime((LocalDateTime)tStandardApiVersion.getApprovedTime()));
                tApiMap.put("approvedStatusCode", tApprovedStatusCode);
                tApiMap.put("description", tDescription);
                tApiMap.put("remark", tRemark);
                tApiMap.put("syncType", tSyncType);
                tApiMap.put("categoryId", tStandardApi.getStandardApiCategory().getId());
                tApiMap.put("categoryName", tCategory);
                tApiMap.put("msgFormat", tStandardApi.getMsgFormat());
                tApiMap.put("requester", tStandardApi.getRequester());
                tApiMap.put("provider", tStandardApi.getProvider());
                tApiMap.put("tenantId", tStandardApi.getTenantId());
                tApiMap.put("apiBuildAcct", tStandardApi.getBuildAcct());
                tApiMap.put("apiBuildTime", DateUtil.formatLocalDateTime((LocalDateTime)tStandardApi.getBuildTime()));
                tApiMap.put("designTenantId", tStandardApiVersion.getStandardApi().getDesignTenantId());
                tApiMap.put("teamId", tStandardApiVersion.getStandardApi().getTeamId());
                tApiMap.put("statusId", tStandardApiVersion.getApprovedStatus().getId());
                tApiMap.put("apiType", tStandardApiVersion.getStandardApi().getApiType());
                tApiMap.put("projectName", tStandardApiVersion.getStandardApi().getProjectName());
                tApiMap.put("hasVersions", tStandardApiVersion.getStandardApi().getHasVersions());
                if (tStandardApiVersion.getStandardApi().getProjectVersionNameList() != null) {
                    ArrayNode projectVersionNameListNode = this.mapper.createArrayNode();
                    tStandardApiVersion.getStandardApi().getProjectVersionNameList().forEach(name -> projectVersionNameListNode.add(name));
                    tApiMap.put("projectVersionNameList", (JsonNode)projectVersionNameListNode);
                    tApiMap.put("projectVersionNameListStr", String.join((CharSequence)",", tStandardApiVersion.getStandardApi().getProjectVersionNameList()));
                }
                arrayNode.add((JsonNode)tApiMap);
            }
            tResponse.put("pageNum", pStandardApiVersionPage.getPageNum());
            tResponse.put("pageSize", pStandardApiVersionPage.getPageSize());
            tResponse.put("pageTotal", pStandardApiVersionPage.getPageTotal());
            tResponse.set("value", (JsonNode)arrayNode);
        }
    }
}

