/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.apimgmt.dao.impl.mybatis;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.digiwin.athena.apimgmt.apiservice.ApiMgmtProjectService;
import com.digiwin.athena.apimgmt.dao.ApiMgmtProjectVersionRelationDao;
import com.digiwin.athena.apimgmt.dao.ApiMgmtStandardApiDao;
import com.digiwin.athena.apimgmt.dao.ApiMgmtStandardApiDataNameDao;
import com.digiwin.athena.apimgmt.dao.ApiMgmtStandardApiVersionDao;
import com.digiwin.athena.apimgmt.dao.impl.mybatis.GenericDaoMybatisImpl;
import com.digiwin.athena.apimgmt.dao.impl.mybatis.MpPage;
import com.digiwin.athena.apimgmt.dao.impl.mybatis.WhereCondition;
import com.digiwin.athena.apimgmt.dao.impl.mybatis.mapper.ApiMgmtStandardApiMapper;
import com.digiwin.athena.apimgmt.facade.dto.ApiMgmtApiInfoDTO;
import com.digiwin.athena.apimgmt.facade.dto.ApiMgmtApiKeyDTO;
import com.digiwin.athena.apimgmt.model.AdvanceSearchValue;
import com.digiwin.athena.apimgmt.model.StandardApi;
import com.digiwin.athena.apimgmt.model.StandardApiVersion;
import com.digiwin.athena.apimgmt.service.model.Page;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Primary
@Repository
public class ApiMgmtStandardApiDaoMybatisImpl
extends GenericDaoMybatisImpl<ApiMgmtStandardApiMapper, StandardApi, Long>
implements ApiMgmtStandardApiDao {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ApiMgmtStandardApiDaoMybatisImpl.class);
    private ApiMgmtProjectVersionRelationDao projectVersionRelationDao;
    private ApiMgmtStandardApiDataNameDao dataNameDao;
    private ApiMgmtStandardApiVersionDao versionDao;

    @Override
    public List<StandardApi> advanceSearch(ArrayList<Map<String, String>> pConditionList, String teamType, boolean searchType, boolean tViewAllApi) {
        List<WhereCondition> conditionList = DaoConverter.INSTANCE.toWhereCondition(pConditionList);
        String tenantId = pConditionList.stream().map(v -> (String)v.get("tenant")).filter(Objects::nonNull).findFirst().orElse(null);
        return ((ApiMgmtStandardApiMapper)this.baseMapper).advanceSearch(conditionList, tenantId, teamType, searchType, tViewAllApi);
    }

    @Override
    public List<StandardApi> getByNameAndTenantId(String pName, String pTenantId) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)wrapper.eq(StandardApi::getName, (Object)pName)).eq(StandardApi::getTenantId, (Object)pTenantId);
        return ((ApiMgmtStandardApiMapper)this.baseMapper).selectList((Wrapper)wrapper);
    }

    @Override
    public List<StandardApi> getListByNameAndBranchAndTenantId(String pName, String branch, String pTenantId) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(StandardApi::getName, (Object)pName)).eq(StandardApi::getBranch, (Object)branch)).eq(StandardApi::getTenantId, (Object)pTenantId);
        return ((ApiMgmtStandardApiMapper)this.baseMapper).selectList((Wrapper)wrapper);
    }

    @Override
    public StandardApi getByNameAndBranchAndTenantId(String pName, String branch, String pTenantId) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(StandardApi::getName, (Object)pName)).eq(StandardApi::getBranch, (Object)branch)).eq(StandardApi::getTenantId, (Object)pTenantId)).last("LIMIT 1");
        return (StandardApi)((ApiMgmtStandardApiMapper)this.baseMapper).selectOne((Wrapper)wrapper);
    }

    @Override
    public List<ApiMgmtApiInfoDTO> queryByKey(List<ApiMgmtApiKeyDTO> apiKeys) {
        if (CollUtil.isEmpty(apiKeys)) {
            return CollUtil.newArrayList((Object[])new ApiMgmtApiInfoDTO[0]);
        }
        return ((ApiMgmtStandardApiMapper)this.baseMapper).queryByKey(apiKeys);
    }

    @Override
    public Page<StandardApiVersion> advanceApiSearch(List<List<AdvanceSearchValue>> pList, String teamType, String tenantId, boolean searchType, boolean tViewAllApi, Integer pageNum, Integer pageSize) {
        Page<StandardApiVersion> page = new Page<StandardApiVersion>();
        page.setPageNum(pageNum);
        page.setPageSize(pageSize);
        List<WhereCondition> conditions = DaoConverter.INSTANCE.convertToWhereCondition(pList);
        MpPage mpPage = new MpPage(pageNum.intValue(), pageSize.intValue());
        List<Long> versionIds = ((ApiMgmtStandardApiMapper)this.baseMapper).advanceApiSearchVersionIds(conditions, teamType, tenantId, searchType, tViewAllApi, mpPage);
        page.setPageTotal(mpPage.getTotal());
        if (versionIds != null && !versionIds.isEmpty()) {
            List<StandardApiVersion> versions = ((ApiMgmtStandardApiMapper)this.baseMapper).selectVersionsByIds(versionIds);
            this.fillApi(versions);
            this.dataNameDao.fillStandardApiDataNames(versions);
            this.projectVersionRelationDao.fillRelationToVersion(versions);
            page.setList(versions);
        }
        return page;
    }

    @Override
    public List<Long> advanceStandardApiCountSearch(List<List<AdvanceSearchValue>> pList, String teamType, String pTenantId, boolean tViewAllApi) {
        List<WhereCondition> conditions = DaoConverter.INSTANCE.convertToWhereCondition(pList);
        return ((ApiMgmtStandardApiMapper)this.baseMapper).advanceStandardApiCountSearch(conditions, teamType, pTenantId, false, tViewAllApi);
    }

    @Override
    @Transactional
    public StandardApi save(StandardApi pStandardApi) {
        return this.save(pStandardApi, false);
    }

    @Override
    @Transactional
    public StandardApi save(StandardApi pStandardApi, boolean cleanProjectRelation) {
        String tApiName = pStandardApi.getName();
        String tTenantId = pStandardApi.getTenantId();
        String branch = pStandardApi.getBranch();
        StandardApi existingApi = this.getByNameAndBranchAndTenantId(tApiName, branch, tTenantId);
        if (existingApi != null) {
            pStandardApi.setId(existingApi.getId());
            pStandardApi.setMsgMdata(existingApi.getMsgMdata());
            if (cleanProjectRelation) {
                this.projectVersionRelationDao.deleteByApiId(pStandardApi.getId());
            }
        }
        for (StandardApiVersion tVersion : pStandardApi.getStandardApiVersions()) {
            tVersion.setApprovedTime(LocalDateTime.now());
        }
        pStandardApi.setBuildTime(LocalDateTime.now());
        if (pStandardApi.getId() == null) {
            ((ApiMgmtStandardApiMapper)this.baseMapper).insert(pStandardApi);
        } else {
            ((ApiMgmtStandardApiMapper)this.baseMapper).updateById(pStandardApi);
        }
        this.versionDao.batchSave(pStandardApi.getStandardApiVersions());
        this.projectVersionRelationDao.batchSave(pStandardApi.getProjectVersionRelations());
        log.info("\u5132\u5b58API. API\u540d\u7a31: {}", (Object)pStandardApi.getName());
        return pStandardApi;
    }

    @Override
    public void delete(Long pId) {
        ((ApiMgmtStandardApiMapper)this.baseMapper).deleteById(pId);
    }

    @Override
    public void fillApi(List<StandardApiVersion> versions) {
        if (CollUtil.isEmpty(versions)) {
            return;
        }
        List standardApis = ((ApiMgmtStandardApiMapper)this.baseMapper).selectBatchIds(versions.stream().map(StandardApiVersion::getApiId).collect(Collectors.toList()));
        Map apiIdMap = CollUtil.toMap((Iterable)standardApis, (Map)MapUtil.newHashMap((int)standardApis.size()), StandardApi::getId);
        versions.forEach(ver -> ver.setStandardApi((StandardApi)apiIdMap.get(ver.getApiId())));
    }

    @Autowired
    public void setProjectVersionRelationDao(ApiMgmtProjectVersionRelationDao projectVersionRelationDao) {
        this.projectVersionRelationDao = projectVersionRelationDao;
    }

    @Autowired
    public void setDataNameDao(ApiMgmtStandardApiDataNameDao dataNameDao) {
        this.dataNameDao = dataNameDao;
    }

    @Autowired
    @Lazy
    public void setVersionDao(ApiMgmtStandardApiVersionDao versionDao) {
        this.versionDao = versionDao;
    }

    @Autowired
    @Lazy
    public void setProjectService(ApiMgmtProjectService projectService) {
        DaoConverter.projectService = projectService;
    }

    public static class DaoConverter {
        private static final Map<String, WhereCondition> sqlWhereMapping = new HashMap<String, WhereCondition>();
        public static DaoConverter INSTANCE = new DaoConverter();
        protected static ApiMgmtProjectService projectService;

        public List<WhereCondition> convertToWhereCondition(List<List<AdvanceSearchValue>> pList) {
            return pList.stream().flatMap(segmentList -> {
                List<WhereCondition> child = segmentList.stream().map(v -> WhereCondition.from(sqlWhereMapping.get(v.getField()), v)).filter(Objects::nonNull).collect(Collectors.toList());
                if (child.isEmpty()) {
                    return Stream.empty();
                }
                return Stream.of(WhereCondition.segment(((WhereCondition)child.get(0)).isAnd(), child));
            }).collect(Collectors.toList());
        }

        public List<WhereCondition> toWhereCondition(ArrayList<Map<String, String>> list) {
            return list.stream().flatMap(inMap -> sqlWhereMapping.keySet().stream().map(field -> {
                String val = (String)inMap.get(field);
                if (val == null) {
                    return null;
                }
                String ops = (String)inMap.get(field + "_ops");
                if ("provider".equals(field)) {
                    ops = ops == null ? WhereCondition.Operator.LIKE.getOp() : ops;
                }
                AdvanceSearchValue searchValue = new AdvanceSearchValue(val, ops, "and", (String)field, 0);
                return WhereCondition.from(sqlWhereMapping.get(searchValue.getField()), searchValue);
            }).filter(Objects::nonNull)).collect(Collectors.toList());
        }

        static {
            WhereCondition projectCodeCondition = WhereCondition.of("pvr.project_id", WhereCondition.Type.STRING);
            projectCodeCondition.setValMapping(projectCode -> projectService.getProjectIdByCode(StrUtil.toStringOrNull((Object)projectCode)));
            sqlWhereMapping.put("apiName", WhereCondition.of("stdapi.name", WhereCondition.Type.STRING));
            sqlWhereMapping.put("apiType", WhereCondition.of("stdapi.api_type", WhereCondition.Type.STRING));
            sqlWhereMapping.put("projectId", WhereCondition.of("pvr.project_id", WhereCondition.Type.STRING));
            sqlWhereMapping.put("projectVersionId", WhereCondition.of("pvr.project_version_id", WhereCondition.Type.STRING));
            sqlWhereMapping.put("projectCode", projectCodeCondition);
            sqlWhereMapping.put("apiStatus", WhereCondition.of("astat.id", WhereCondition.Type.STRING));
            sqlWhereMapping.put("apiBranch", WhereCondition.of("stdapi.branch", WhereCondition.Type.STRING));
            sqlWhereMapping.put("branch", WhereCondition.of("stdapi.branch", WhereCondition.Type.STRING));
            sqlWhereMapping.put("apiTag", WhereCondition.of("stdapi.tag", WhereCondition.Type.MULTI_LANG));
            sqlWhereMapping.put("apiDataName", WhereCondition.of("stdapidataname.data_name", WhereCondition.Type.STRING));
            sqlWhereMapping.put("apiDescription", WhereCondition.of("stdapi.description", WhereCondition.Type.MULTI_LANG));
            sqlWhereMapping.put("apiRemark", WhereCondition.of("stdapi.remark", WhereCondition.Type.MULTI_LANG));
            sqlWhereMapping.put("apiSyncType", WhereCondition.of("stdapi.sync_type", WhereCondition.Type.STRING));
            sqlWhereMapping.put("apiCategory", WhereCondition.of("stdapi.category", WhereCondition.Type.STRING));
            sqlWhereMapping.put("provider", WhereCondition.of("stdapi.provider", WhereCondition.Type.STRING));
            sqlWhereMapping.put("requester", WhereCondition.of("stdapi.requester", WhereCondition.Type.STRING));
            sqlWhereMapping.put("tenantId", WhereCondition.of("stdapi.tenant_id", WhereCondition.Type.STRING, true));
            sqlWhereMapping.put("apiBuildTime", WhereCondition.of("stdapi.build_time", WhereCondition.Type.DATE));
            sqlWhereMapping.put("userId", WhereCondition.of("stdapiver.user_id", WhereCondition.Type.STRING));
        }
    }
}

