/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.apimgmt.apiservice;

import cn.hutool.core.collection.CollUtil;
import com.digiwin.athena.apimgmt.dao.ApiMgmtApprovedStatusDao;
import com.digiwin.athena.apimgmt.dao.ApiMgmtStandardApiVersionDao;
import com.digiwin.athena.apimgmt.enums.LocaleEnum;
import com.digiwin.athena.apimgmt.infra.context.ApiMgmtServiceContextHolder;
import com.digiwin.athena.apimgmt.model.ApiCountKeyValue;
import com.digiwin.athena.apimgmt.model.ApprovedStatus;
import com.digiwin.athena.apimgmt.util.StringUtil;
import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jackson.JsonLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ApiStatusListGetService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ApiStatusListGetService.class);
    @Autowired
    ApiMgmtStandardApiVersionDao standardApiVersionDao;
    @Autowired
    ApiMgmtApprovedStatusDao approvedStatusDao;

    public ArrayList<Map<String, Object>> execute(String validatorResult) throws Exception {
        log.info("[Thread.id " + Thread.currentThread().getId() + "]\u63a5\u53e3\uff1a" + this.getClass() + "\uff0c\u539f\u59cb\u8a0a\u606f\uff1a" + validatorResult);
        ArrayList<Map<String, Object>> tResponse = new ArrayList<Map<String, Object>>();
        String tLocale = ApiMgmtServiceContextHolder.getLocale();
        tLocale = tLocale == null ? LocaleEnum.EN_US.getType() : tLocale;
        JsonNode tRequestJsonNode = JsonLoader.fromString((String)validatorResult);
        boolean tIsVerifyAcct = false;
        if (!StringUtil.isEmptyOrSpace((Object)tRequestJsonNode.get("verifyAcct").asText())) {
            tIsVerifyAcct = true;
        }
        List<Object> tApprovedStatusList = new ArrayList();
        if (tIsVerifyAcct) {
            ApprovedStatus tApprovedStatus = (ApprovedStatus)this.approvedStatusDao.get(2L);
            tApprovedStatusList.add(tApprovedStatus);
        } else {
            tApprovedStatusList = this.approvedStatusDao.getAll();
        }
        List<ApiCountKeyValue> tApiCountList = this.standardApiVersionDao.getApiCountByStatus(ApiMgmtServiceContextHolder.getUserId(), ApiMgmtServiceContextHolder.getTenantId(), tIsVerifyAcct);
        tApiCountList.forEach(x -> log.info("\u67e5\u8be2\u6570\u636e\u6253\u5370" + x.getApprovedStatus() + "_" + x.getApiCount()));
        for (ApprovedStatus approvedStatus : tApprovedStatusList) {
            String tStatus;
            HashMap<String, Object> tStatusMap = new HashMap<String, Object>();
            Integer count = 0;
            List apiCountKeyValues = tApiCountList.stream().filter(x -> x.getApprovedStatus().equals(tApprovedStatus.getId())).collect(Collectors.toList());
            if (CollUtil.isNotEmpty(apiCountKeyValues)) {
                count = ((ApiCountKeyValue)apiCountKeyValues.get(0)).getApiCount();
            }
            switch (tLocale) {
                case "zh_CN": {
                    tStatus = approvedStatus.getNameZhCn();
                    break;
                }
                case "zh_TW": {
                    tStatus = approvedStatus.getNameZhTw();
                    break;
                }
                default: {
                    tStatus = approvedStatus.getNameEnUs();
                }
            }
            tStatusMap.put("id", approvedStatus.getId());
            tStatusMap.put("status", tStatus);
            tStatusMap.put("count", count);
            tResponse.add(tStatusMap);
        }
        return tResponse;
    }
}

