/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.apimgmt.apiservice;

import cn.hutool.core.collection.CollUtil;
import com.digiwin.athena.apimgmt.ApiMgmtApplicationParameter;
import com.digiwin.athena.apimgmt.annotate.OperateAuthorityVerify;
import com.digiwin.athena.apimgmt.apiservice.AbstractApiService;
import com.digiwin.athena.apimgmt.dao.ApiMgmtProjectVersionRelationDao;
import com.digiwin.athena.apimgmt.dao.ApiMgmtStandardApiDao;
import com.digiwin.athena.apimgmt.dao.ApiMgmtStandardApiDataNameDao;
import com.digiwin.athena.apimgmt.dao.ApiMgmtStandardApiVersionDao;
import com.digiwin.athena.apimgmt.enums.APIExportImportEnums;
import com.digiwin.athena.apimgmt.enums.LocaleEnum;
import com.digiwin.athena.apimgmt.enums.MessageFormatEnum;
import com.digiwin.athena.apimgmt.enums.ValidateStateEnum;
import com.digiwin.athena.apimgmt.exception.BaseException;
import com.digiwin.athena.apimgmt.exception.TeamIdNotFindValidationException;
import com.digiwin.athena.apimgmt.infra.context.ApiMgmtServiceContextHolder;
import com.digiwin.athena.apimgmt.infra.prop.ApiMgmtMdcProp;
import com.digiwin.athena.apimgmt.model.ApprovedStatus;
import com.digiwin.athena.apimgmt.model.StandardApi;
import com.digiwin.athena.apimgmt.model.StandardApiDataName;
import com.digiwin.athena.apimgmt.model.StandardApiVersion;
import com.digiwin.athena.apimgmt.model.StateCode;
import com.digiwin.athena.apimgmt.service.util.ApiVersionServiceUtil;
import com.digiwin.athena.apimgmt.service.util.DmcFileServiceUtil;
import com.digiwin.athena.apimgmt.service.util.StandardApiExportServiceUtil;
import com.digiwin.athena.apimgmt.service.util.StandardApiFileReadServiceUtil;
import com.digiwin.athena.apimgmt.service.util.StandardApiSpecAnalyzeServiceUtil;
import com.digiwin.athena.apimgmt.services.ApiMgmtApiSaveAndReviewVerifyProcessor;
import com.digiwin.athena.apimgmt.services.ApiMgmtApiVersionService;
import com.digiwin.athena.apimgmt.services.ApiMgmtProductCategoryService;
import com.digiwin.athena.apimgmt.services.ApiMgmtSyncMdcServiceProcessor;
import com.digiwin.athena.apimgmt.util.StringUtil;
import com.digiwin.athena.apimgmt.validator.ValidatorResult;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.collections4.MapUtils;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Sheet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@OperateAuthorityVerify
public class ApiSpecBatchSaveService
extends AbstractApiService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ApiSpecBatchSaveService.class);
    @Autowired
    private ApiMgmtStandardApiDao standardApiDao;
    @Autowired
    private ApiMgmtStandardApiVersionDao standardApiVersionDao;
    @Autowired
    private ApiMgmtProjectVersionRelationDao projectVersionRelationDao;
    @Autowired
    private ApiMgmtProductCategoryService productCategoryService;
    @Autowired
    private ApiMgmtStandardApiDataNameDao standardApiDataNameDao;
    @Autowired
    private ApiMgmtSyncMdcServiceProcessor syncMdcServiceProcessor;
    @Autowired
    private ApiMgmtApiSaveAndReviewVerifyProcessor apiSaveAndReviewVerifyProcessor;
    @Autowired
    private ApiMgmtApiVersionService apiVersionService;
    @Autowired
    private ApiMgmtMdcProp mdcProp;

    public ApiSpecBatchSaveService() {
        this.jsonSchemaFileName = "api_spec_batch_save_schema.json";
    }

    @Override
    protected Map<String, Object> processData(ValidatorResult validatorResult) throws Exception {
        String tLocale = ApiMgmtServiceContextHolder.getLocale();
        tLocale = tLocale == null ? LocaleEnum.EN_US.getType() : tLocale;
        StateCode tStateCode = this.getStateCode(ValidateStateEnum.SUCCESS.getCode());
        String tDescription = tStateCode.getDescription();
        StringBuilder tDescriptionBuilder = new StringBuilder();
        ObjectNode tResponseNode = this.mapper.createObjectNode();
        ArrayNode dataNode = this.mapper.createArrayNode();
        tResponseNode.set("apiList", (JsonNode)dataNode);
        HashMap<String, List<Map<String, String>>> tTotalApiErrorMap = new HashMap<String, List<Map<String, String>>>();
        ArrayList<StandardApi> standardApiList = new ArrayList<StandardApi>();
        ArrayList<Long> apiVersionList = new ArrayList<Long>();
        ArrayList<Long> apiIdList = new ArrayList<Long>();
        try {
            String tToken = ApiMgmtServiceContextHolder.getToken();
            String routerKey = ApiMgmtServiceContextHolder.getRouterKey();
            String tTeamId = ApiMgmtServiceContextHolder.getTeamId();
            String teamType = ApiMgmtServiceContextHolder.getTeamType();
            String tTenantId = ApiMgmtServiceContextHolder.getTenantId();
            String tUserId = ApiMgmtServiceContextHolder.getUserId();
            if (StringUtil.isEmpty((Object)teamType)) {
                throw new TeamIdNotFindValidationException(this.getClass());
            }
            JsonNode tRequestJsonNode = validatorResult.getJsonContent();
            JsonNode arrayNode = tRequestJsonNode.get("apiList");
            for (JsonNode jsonNode : arrayNode) {
                HashMap<String, String> tReqErrorLog;
                String prevBranch;
                List<StandardApiVersion> tPreviStandardApiVersions;
                StandardApi tStandardApi = new StandardApi();
                tStandardApi.setTeamId(tTeamId);
                tStandardApi.setTeamType(teamType);
                List<Map<String, String>> tSetStdApiResult = StandardApiSpecAnalyzeServiceUtil.setStandardApi(tStandardApi, jsonNode, tLocale);
                String tApiName = tStandardApi.getName();
                String tApiTenantId = tStandardApi.getTenantId();
                String tVersion = tStandardApi.getStandardApiVersions().get(0).getVersion();
                if (CollUtil.isNotEmpty(tSetStdApiResult)) {
                    tTotalApiErrorMap.put(tApiName + "/" + tVersion + "/" + tApiTenantId, tSetStdApiResult);
                    break;
                }
                HashMap<String, StandardApiDataName> tAddDataName = new HashMap<String, StandardApiDataName>();
                tSetStdApiResult = StandardApiSpecAnalyzeServiceUtil.setStandardApiDataName(tStandardApi, jsonNode, tAddDataName, tLocale);
                if (CollUtil.isNotEmpty(tSetStdApiResult)) {
                    tTotalApiErrorMap.put(tApiName + "/" + tVersion + "/" + tApiTenantId, tSetStdApiResult);
                    break;
                }
                List<StandardApiVersion> tStandardApiVersionList = this.standardApiVersionDao.getExistApiVersion(tApiName, tApiTenantId, tVersion);
                this.setVersion(tStandardApiVersionList, tSetStdApiResult, tTotalApiErrorMap, apiVersionList, apiIdList, tStandardApi, tLocale, tUserId, tTenantId);
                if (!this.apiVersionService.judgeNewBranch(tVersion).booleanValue()) {
                    log.info("\u8fdb\u5165\u4e0e\u4e0a\u4e00\u7248\u672c\u7684\u9a8c\u8bc1");
                    List<StandardApiVersion> tPreviStandardApiVersions2 = this.standardApiVersionDao.getExistApiVersion(tApiName, tApiTenantId, ApiVersionServiceUtil.getPreviousVersion(tVersion));
                    if (tPreviStandardApiVersions2.isEmpty()) {
                        StandardApiFileReadServiceUtil.uploadCheckResult(tSetStdApiResult, APIExportImportEnums.PREVI_API_VERSION_IS_EXIST.toString(), null, null, 0, 0, tLocale);
                    } else {
                        String designTenantId;
                        List<StandardApiDataName> tPreviApiDataName = this.standardApiDataNameDao.getByApiVerId(tPreviStandardApiVersions2.get(0).getId(), true);
                        this.apiSaveAndReviewVerifyProcessor.compareDataName(tSetStdApiResult, tPreviApiDataName, tAddDataName);
                        StandardApi previousStandardApi = tPreviStandardApiVersions2.get(0).getStandardApi();
                        ApprovedStatus previousApprovedStatus = tPreviStandardApiVersions2.get(0).getApprovedStatus();
                        if (previousApprovedStatus.getId() != 4L) {
                            StandardApiFileReadServiceUtil.uploadCheckResult(tSetStdApiResult, APIExportImportEnums.PREVI_IS_DEVELOPING.toString(), null, null, 0, 0, tLocale);
                        }
                        if (!(null == tStandardApi.getParentApiName() || null != previousStandardApi.getParentApiName() && (null == previousStandardApi.getParentApiName() || tStandardApi.getParentApiName().equals(previousStandardApi.getParentApiName()) && (tStandardApi.getParentBranch().equals(previousStandardApi.getParentBranch()) || tStandardApi.getParentApiTenantId().equals(previousStandardApi.getParentApiTenantId()))))) {
                            StandardApiFileReadServiceUtil.uploadCheckResult(tSetStdApiResult, APIExportImportEnums.PARENT_NAME_INCONSISTENT.toString(), null, null, 0, 0, tLocale);
                        }
                        if (!previousStandardApi.getStandardApiSyncType().getId().equals(tStandardApi.getStandardApiSyncType().getId())) {
                            StandardApiFileReadServiceUtil.uploadCheckResult(tSetStdApiResult, APIExportImportEnums.SYNC_TYPE_CAN_NOT_CHANGE.toString(), null, null, 0, 0, tLocale);
                        }
                        if (!previousStandardApi.getIsBatch().equals(tStandardApi.getIsBatch())) {
                            StandardApiFileReadServiceUtil.uploadCheckResult(tSetStdApiResult, APIExportImportEnums.IS_BATCH_CAN_NOT_CHANGE.toString(), null, null, 0, 0, tLocale);
                        }
                        if (!tTenantId.equals(designTenantId = previousStandardApi.getDesignTenantId()) && !"1".equals(teamType)) {
                            HashMap<String, String> errorMap = new HashMap<String, String>();
                            errorMap.put("description", "\u5f53\u524d\u79df\u6237\u65e0\u6743\u9650\u6267\u884c\u5f53\u524d\u64cd\u4f5c");
                            errorMap.put("solution", "\u8bf7\u4f7f\u7528\u79df\u6237ID\uff1a" + designTenantId + "\u6267\u884c\u5f53\u524d\u64cd\u4f5c");
                            tSetStdApiResult.add(errorMap);
                        }
                    }
                } else if (!"1.0".equals(tVersion) && (tPreviStandardApiVersions = this.standardApiVersionDao.getExistApiVersion(tApiName, tApiTenantId, prevBranch = ApiVersionServiceUtil.getPrevBranchByVersion(tVersion))).isEmpty()) {
                    StandardApiFileReadServiceUtil.uploadCheckResult(tSetStdApiResult, APIExportImportEnums.PREV_API_BRANCH_NOT_EXIST.toString(), null, null, 0, 0, tLocale);
                }
                this.apiSaveAndReviewVerifyProcessor.checkListEnum(tSetStdApiResult, tAddDataName);
                if ((tStandardApi.getRequester().equalsIgnoreCase("Athena") || tStandardApi.getProvider().equalsIgnoreCase("Athena")) && !tStandardApi.getMsgFormat().equals(MessageFormatEnum.JSON.getMsgFormat())) {
                    tReqErrorLog = new HashMap<String, String>();
                    tReqErrorLog.put("description", "\u767c\u8d77\u65b9\u3001\u63a5\u6536\u65b9\u7522\u54c1\u5305\u542b\u300cAthena\u300d\uff0c\u5247\u4fe1\u606f\u683c\u5f0f\u5fc5\u9808\u70ba\u300cJSON\u300d");
                    tSetStdApiResult.add(tReqErrorLog);
                }
                this.apiSaveAndReviewVerifyProcessor.checkRequiredDataName(tSetStdApiResult, tAddDataName);
                if (tStandardApi.getStandardApiPaging().getId() == 2L || tStandardApi.getStandardApiPaging().getId() == 3L) {
                    this.apiSaveAndReviewVerifyProcessor.checkPagingRequiredDataName(tSetStdApiResult, tAddDataName);
                }
                this.apiSaveAndReviewVerifyProcessor.checkIsArrayCannotBeY(tSetStdApiResult, tAddDataName);
                this.apiSaveAndReviewVerifyProcessor.checkDataKey(tSetStdApiResult, tAddDataName);
                if (tStandardApi.getStandardApiSyncType().getId() == 2L && !tStandardApi.getMsgFormat().equals(MessageFormatEnum.JSON.getMsgFormat())) {
                    tReqErrorLog = new HashMap();
                    tReqErrorLog.put("description", "\u8abf\u7528\u6a21\u5f0f\u70ba\u300c\u5168\u7570\u6b65\u300d\uff0c\u5247\u4fe1\u606f\u683c\u5f0f\u5fc5\u9808\u70ba\u300cJSON\u300d");
                    tSetStdApiResult.add(tReqErrorLog);
                }
                if (CollUtil.isNotEmpty(tSetStdApiResult)) {
                    String tApiError = tApiName + "/" + tVersion + "/" + tApiTenantId;
                    tTotalApiErrorMap.put(tApiError, tSetStdApiResult);
                    break;
                }
                standardApiList.add(tStandardApi);
            }
            if (MapUtils.isNotEmpty(tTotalApiErrorMap)) {
                return this.result(tStateCode, tDescription, tTotalApiErrorMap);
            }
            if (CollUtil.isNotEmpty(apiVersionList)) {
                apiVersionList.forEach(x -> this.standardApiVersionDao.delete((Long)x, false));
            }
            if (CollUtil.isNotEmpty(apiIdList)) {
                apiIdList.forEach(apiId -> this.projectVersionRelationDao.deleteByApiId((Long)apiId));
            }
            ArrayList<Long> tListApiVerIdNeedToSyncMetadata = new ArrayList<Long>();
            if (CollUtil.isNotEmpty(standardApiList)) {
                standardApiList.forEach(x -> {
                    x.getStandardApiVersions().get(0).getApprovedStatus().setId(3L);
                    this.standardApiDao.save(x);
                    this.productCategoryService.saveProductCategory(x.getProvider());
                    ObjectNode objectNode = this.mapper.createObjectNode();
                    objectNode.put("approvedStatus", 3L);
                    objectNode.put("apiName", x.getName());
                    objectNode.put("apiVersion", x.getStandardApiVersions().get(0).getVersion());
                    objectNode.put("tenantId", x.getTenantId());
                    dataNode.add((JsonNode)objectNode);
                    List<StandardApiVersion> standardApiVersionList = this.standardApiVersionDao.getExistApiVersion(x.getName(), x.getTenantId(), x.getStandardApiVersions().get(0).getVersion());
                    if (CollUtil.isNotEmpty(standardApiVersionList)) {
                        tListApiVerIdNeedToSyncMetadata.add(standardApiVersionList.get(0).getId());
                    }
                });
            }
            if (!tListApiVerIdNeedToSyncMetadata.isEmpty() && CollUtil.isNotEmpty((Collection)this.mdcProp.getReviewUrlList())) {
                for (String url : this.mdcProp.getReviewUrlList()) {
                    this.syncMdcServiceProcessor.runSyncMdcMetadata(tListApiVerIdNeedToSyncMetadata, url, tUserId, tToken, routerKey);
                }
            }
        }
        catch (BaseException e) {
            log.error(e.getMessage(), (Throwable)e);
            tStateCode = this.getStateCode(e.getStateEnum().getCode());
            tDescriptionBuilder.append(tStateCode.getDescription());
            if (!StringUtil.isEmptyOrSpace((Object)e.getMessage())) {
                tDescriptionBuilder.append(" ").append(e.getMessage());
            }
            tDescription = tDescriptionBuilder.toString();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            tStateCode = this.getStateCode(ValidateStateEnum.UNEXPECTED_ERROR.getCode());
            tDescriptionBuilder.append(tStateCode.getDescription()).append(" ").append(e.getClass().toString()).append(":").append(e.getMessage());
            tDescription = tDescriptionBuilder.toString();
        }
        tResponseNode.put("code", tStateCode.getCode());
        tResponseNode.put("description", tDescription);
        ObjectNode tResponseJsonNode = this.createResponseJsonNode(tStateCode.getCode(), tDescription, tResponseNode);
        return this.converJsonNodeToMap((JsonNode)tResponseJsonNode);
    }

    private void setVersion(List<StandardApiVersion> tStandardApiVersionList, List<Map<String, String>> tSetStdApiResult, Map<String, List<Map<String, String>>> tTotalApiErrorMap, List<Long> apiVersionList, List<Long> apiIdList, StandardApi tStandardApi, String tLocale, String tUserId, String tTenantId) {
        if (CollUtil.isNotEmpty(tStandardApiVersionList)) {
            StandardApiVersion tStandardApiVersion = tStandardApiVersionList.get(0);
            if (!(tStandardApiVersion.getApprovedStatus().getId() == 4L || tStandardApiVersion.getUserId().equals(tUserId) && (StringUtil.isEmptyOrSpace((Object)tStandardApiVersion.getStandardApi().getDesignTenantId()) || tStandardApiVersion.getStandardApi().getDesignTenantId().equals(tTenantId)))) {
                StandardApiFileReadServiceUtil.uploadCheckResult(tSetStdApiResult, APIExportImportEnums.API_VERSION_IS_EXIST.toString(), null, null, 0, 0, tLocale);
                String tApiError = tStandardApi.getName() + "/" + tStandardApi.getStandardApiVersions().get(0).getVersion() + "/" + tStandardApi.getTenantId();
                tTotalApiErrorMap.put(tApiError, tSetStdApiResult);
                return;
            }
            if (tStandardApiVersion.getApprovedStatus().getId() == 1L) {
                apiVersionList.add(tStandardApiVersion.getId());
            }
            if (tStandardApiVersion.getApprovedStatus().getId() == 3L) {
                apiVersionList.add(tStandardApiVersion.getId());
            }
            if (tStandardApiVersion.getApprovedStatus().getId() == 4L) {
                tStandardApi.getStandardApiVersions().get(0).setVersion(ApiVersionServiceUtil.getNextVersion(tStandardApi.getStandardApiVersions().get(0).getVersion()));
                List<StandardApiVersion> standardApiNextVersionList = this.standardApiVersionDao.getExistApiVersion(tStandardApi.getName(), tStandardApi.getTenantId(), tStandardApi.getStandardApiVersions().get(0).getVersion());
                this.setVersion(standardApiNextVersionList, tSetStdApiResult, tTotalApiErrorMap, apiVersionList, apiIdList, tStandardApi, tLocale, tUserId, tTenantId);
            }
            apiIdList.add(tStandardApiVersion.getStandardApi().getId());
        }
    }

    private Map<String, Object> result(StateCode tStateCode, String tDescription, Map<String, List<Map<String, String>>> pTotalApiErrorMap) throws Exception {
        ObjectNode tResponseNode = this.mapper.createObjectNode();
        ObjectNode tResponseJsonNode = this.createResponseJsonNode(tStateCode.getCode(), tDescription, tResponseNode);
        tStateCode = this.getStateCode(ValidateStateEnum.IMPORT_SPEC_FORMAT_ERROR.getCode());
        tDescription = tStateCode.getDescription();
        HSSFWorkbook tHSSFWorkbook = StandardApiExportServiceUtil.getTemplateFile(false);
        HSSFSheet tErrorSheet = tHSSFWorkbook.createSheet("\u932f\u8aa4\u660e\u7d30");
        StandardApiFileReadServiceUtil.writeImportErrorFile((Sheet)tErrorSheet, pTotalApiErrorMap);
        String tFileName = ApiMgmtApplicationParameter._TEMPLATE_FILE_NAME;
        String tFileExportPath = ApiMgmtApplicationParameter._FILE_EXPORT_PATH + "/" + tFileName;
        FileOutputStream fileOut = new FileOutputStream(tFileExportPath);
        tHSSFWorkbook.write((OutputStream)fileOut);
        fileOut.close();
        int pFailedNum = pTotalApiErrorMap.keySet().size();
        DmcFileServiceUtil.uploadFileAndGenerateDownloadLink(tResponseNode, tFileExportPath, tFileName, true, pFailedNum);
        tResponseNode.put("code", tStateCode.getCode());
        tResponseNode.put("description", tDescription);
        return this.converJsonNodeToMap((JsonNode)tResponseJsonNode);
    }
}

