/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.apimgmt.apiservice;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.date.DateUtil;
import com.digiwin.athena.apimgmt.ApiMgmtApplicationParameter;
import com.digiwin.athena.apimgmt.apiservice.AbstractApiService;
import com.digiwin.athena.apimgmt.apiservice.AdvanceSearchApiListGetOtherService;
import com.digiwin.athena.apimgmt.constants.ApiTypeConstants;
import com.digiwin.athena.apimgmt.dao.ApiMgmtStandardApiDao;
import com.digiwin.athena.apimgmt.dao.ApiMgmtTenantConfigDao;
import com.digiwin.athena.apimgmt.enums.ApiAttributeEnum;
import com.digiwin.athena.apimgmt.enums.LocaleEnum;
import com.digiwin.athena.apimgmt.enums.ValidateStateEnum;
import com.digiwin.athena.apimgmt.infra.context.ApiMgmtServiceContextHolder;
import com.digiwin.athena.apimgmt.model.AdvanceSearchValue;
import com.digiwin.athena.apimgmt.model.StandardApi;
import com.digiwin.athena.apimgmt.model.StandardApiVersion;
import com.digiwin.athena.apimgmt.model.StateCode;
import com.digiwin.athena.apimgmt.service.model.Page;
import com.digiwin.athena.apimgmt.service.util.DmcFileServiceUtil;
import com.digiwin.athena.apimgmt.service.util.StandardApiExportWithXssServiceUtil;
import com.digiwin.athena.apimgmt.util.StandardApiMessageUtil;
import com.digiwin.athena.apimgmt.util.StringUtil;
import com.digiwin.athena.apimgmt.validator.ValidatorResult;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class StandardApiQueryListExportService
extends AbstractApiService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(StandardApiQueryListExportService.class);
    @Autowired
    private ApiMgmtStandardApiDao standardApiDao;
    @Autowired
    private ApiMgmtTenantConfigDao tenantConfigDao;
    @Autowired
    private AdvanceSearchApiListGetOtherService advanceSearchApiListGetOtherService;
    ObjectMapper mapper = new ObjectMapper();

    public StandardApiQueryListExportService() {
        this.jsonSchemaFileName = "standard_api_query_export_schema.json";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Object> processData(ValidatorResult validatorResult) throws Exception {
        log.info("[Thread.id " + Thread.currentThread().getId() + "]\u63a5\u53e3: " + this.getClass() + ", \u539f\u59cb\u8a0a\u606f: " + validatorResult);
        String tLocale = ApiMgmtServiceContextHolder.getLocale();
        tLocale = tLocale == null ? LocaleEnum.EN_US.getType() : tLocale;
        StateCode tStateCode = this.getStateCode(validatorResult.getState().getCode());
        String tDescription = tStateCode.getDescription();
        JsonNode tRequestJsonNode = validatorResult.getJsonContent();
        ArrayNode tConditionArrayNode = (ArrayNode)tRequestJsonNode.get("conditionList");
        JsonNode tCategoryId = tRequestJsonNode.get("categoryId");
        JsonNode projectId = tRequestJsonNode.get("projectId");
        JsonNode projectVersionId = tRequestJsonNode.get("projectVersionId");
        JsonNode tType = tRequestJsonNode.get("type");
        if (null == tType || StringUtil.isEmptyOrSpace((Object)tType.asBoolean())) {
            throw new Exception("\u8bf7\u9009\u62e9\u67e5\u8be2\u7c7b\u578b!");
        }
        String tToken = ApiMgmtServiceContextHolder.getToken();
        if (tType.asBoolean() && null == tToken) {
            throw new Exception("\u5f53\u524d\u7528\u6237\u672a\u767b\u5f55,\u8bf7\u767b\u5f55!");
        }
        String tTenantId = ApiMgmtServiceContextHolder.getTenantId();
        String teamType = ApiMgmtServiceContextHolder.getTeamType();
        boolean tViewAllApi = false;
        if (!tType.asBoolean() && !StringUtil.isEmptyOrSpace((Object)tTenantId)) {
            tViewAllApi = this.tenantConfigDao.viewAllApiTenantExist(tTenantId);
        }
        ObjectNode tResponseNode = this.mapper.createObjectNode();
        FileOutputStream fileOut = null;
        try {
            XSSFWorkbook xssfWorkbook = StandardApiExportWithXssServiceUtil.createXSSFWorkbook();
            xssfWorkbook.setSheetHidden(4, true);
            String tNewFileName = "StdApi_" + DateUtil.format((LocalDateTime)LocalDateTime.now(), (String)"yyyyMMddHHmmssSSS") + ".xlsx";
            String tNewFilePath = ApiMgmtApplicationParameter._FILE_EXPORT_PATH + "/" + tNewFileName;
            fileOut = new FileOutputStream(tNewFilePath);
            List<List<AdvanceSearchValue>> arrayList = StandardApiMessageUtil.generateQuery(tConditionArrayNode, tCategoryId, null, tType, projectId, projectVersionId, null);
            List<Long> ids = this.standardApiDao.advanceStandardApiCountSearch(arrayList, teamType, tTenantId, tViewAllApi);
            if (CollUtil.isNotEmpty(ids)) {
                int number = 0;
                int sum = (int)Math.ceil(1.0 * (double)ids.size() / 2000.0);
                for (int i = 1; i < sum + 1; ++i) {
                    Page<StandardApiVersion> standardApiVersionPage = this.standardApiDao.advanceApiSearch(arrayList, teamType, tTenantId, tType.asBoolean(), tViewAllApi, i, 2000);
                    number = this.setAdvanceSearchApiResponse(standardApiVersionPage, tLocale, tType.asBoolean(), xssfWorkbook, number);
                }
            }
            xssfWorkbook.write((OutputStream)fileOut);
            DmcFileServiceUtil.uploadFileAndGenerateDownloadLink(tResponseNode, tNewFilePath, tNewFileName, false, 0);
            boolean b = StandardApiExportWithXssServiceUtil.removeFile(tNewFilePath);
            log.info("\u5bfc\u51fa\u6587\u4ef6\u5220\u9664:{}" + b);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            tStateCode = this.getStateCode(ValidateStateEnum.UNEXPECTED_ERROR.getCode());
            tDescription = tStateCode.getDescription();
        }
        finally {
            assert (fileOut != null);
            fileOut.close();
        }
        ObjectNode tResponseJsonNode = this.createResponseJsonNode(tStateCode.getCode(), tDescription, tResponseNode);
        return this.converJsonNodeToMap((JsonNode)tResponseJsonNode);
    }

    private Integer setAdvanceSearchApiResponse(Page<StandardApiVersion> pStandardApiVersionPage, String tLocale, boolean tType, XSSFWorkbook xssfWorkbook, int number) {
        if (CollUtil.isNotEmpty(pStandardApiVersionPage.getList())) {
            List<StandardApi> standardApiList = pStandardApiVersionPage.getList().stream().map(StandardApiVersion::getStandardApi).collect(Collectors.toList());
            this.advanceSearchApiListGetOtherService.setProjectAndVersion(standardApiList);
            for (StandardApiVersion tStandardApiVersion : pStandardApiVersionPage.getList()) {
                String tCategory;
                String tSyncType;
                String tRemark;
                String tDescription;
                long tApprovedStatusCode;
                String tApprovedStatus;
                HashMap<String, Object> tApiMap = new HashMap<String, Object>();
                StandardApi tStandardApi = tStandardApiVersion.getStandardApi();
                if (!tType) {
                    if (tStandardApiVersion.getVersion().endsWith(".0")) {
                        tApiMap.put("firstApplicant", tStandardApiVersion.getApplicant());
                        tApiMap.put("lastApplicant", "");
                    } else {
                        tApiMap.put("firstApplicant", tStandardApi.getFirstApplicant());
                        tApiMap.put("lastApplicant", tStandardApiVersion.getApplicant());
                    }
                }
                switch (tLocale) {
                    case "zh_CN": {
                        tApprovedStatus = tStandardApiVersion.getApprovedStatus().getNameZhCn();
                        tApprovedStatusCode = tStandardApiVersion.getApprovedStatus().getId();
                        tDescription = tStandardApi.getDescriptionZhCn();
                        tRemark = tStandardApi.getRemarkZhCn();
                        tSyncType = tStandardApi.getStandardApiSyncType().getNameZhCn();
                        tCategory = tStandardApi.getStandardApiCategory().getNameZhCn();
                        break;
                    }
                    case "zh_TW": {
                        tApprovedStatus = tStandardApiVersion.getApprovedStatus().getNameZhTw();
                        tApprovedStatusCode = tStandardApiVersion.getApprovedStatus().getId();
                        tDescription = tStandardApi.getDescriptionZhTw();
                        tRemark = tStandardApi.getRemarkZhTw();
                        tSyncType = tStandardApi.getStandardApiSyncType().getNameZhTw();
                        tCategory = tStandardApi.getStandardApiCategory().getNameZhTw();
                        break;
                    }
                    default: {
                        tApprovedStatus = tStandardApiVersion.getApprovedStatus().getNameEnUs();
                        tApprovedStatusCode = tStandardApiVersion.getApprovedStatus().getId();
                        tDescription = tStandardApi.getDescriptionEnUs();
                        tRemark = tStandardApi.getRemarkEnUs();
                        tSyncType = tStandardApi.getStandardApiSyncType().getNameEnUs();
                        tCategory = tStandardApi.getStandardApiCategory().getNameEnUs();
                    }
                }
                tApiMap.put("numeric", number);
                tApiMap.put("apiId", tStandardApi.getId());
                tApiMap.put("name", tStandardApi.getName());
                tApiMap.put("version", tStandardApiVersion.getVersion());
                tApiMap.put("approvedStatus", tApprovedStatus);
                tApiMap.put(ApiAttributeEnum.approvedTime.toString(), DateUtil.formatLocalDateTime((LocalDateTime)tStandardApiVersion.getApprovedTime()));
                tApiMap.put("approvedStatusCode", tApprovedStatusCode);
                tApiMap.put("description", tDescription);
                tApiMap.put("remark", tRemark);
                tApiMap.put("syncType", tSyncType);
                tApiMap.put("categoryId", tStandardApi.getStandardApiCategory().getId());
                tApiMap.put("categoryName", tCategory);
                tApiMap.put("msgFormat", tStandardApi.getMsgFormat());
                tApiMap.put("requester", tStandardApi.getRequester());
                tApiMap.put("provider", tStandardApi.getProvider());
                tApiMap.put("tenantId", tStandardApi.getTenantId());
                tApiMap.put("apiBuildAcct", tStandardApi.getBuildAcct());
                tApiMap.put("apiBuildTime", DateUtil.formatLocalDateTime((LocalDateTime)tStandardApi.getBuildTime()));
                tApiMap.put("designTenantId", tStandardApiVersion.getStandardApi().getDesignTenantId());
                tApiMap.put("teamId", tStandardApiVersion.getStandardApi().getTeamId());
                tApiMap.put("statusId", tStandardApiVersion.getApprovedStatus().getId());
                tApiMap.put("apiType", tStandardApiVersion.getStandardApi().getApiType());
                tApiMap.put("apiTypeName", ApiTypeConstants.getNameByCode((String)tStandardApiVersion.getStandardApi().getApiType()));
                tApiMap.put("projectName", tStandardApiVersion.getStandardApi().getProjectName());
                if (tStandardApiVersion.getStandardApi().getProjectVersionNameList() != null) {
                    ArrayNode projectVersionNameListNode = this.mapper.createArrayNode();
                    tStandardApiVersion.getStandardApi().getProjectVersionNameList().forEach(name -> projectVersionNameListNode.add(name));
                    tApiMap.put("projectVersionNameList", projectVersionNameListNode);
                    tApiMap.put("projectVersionNameListStr", String.join((CharSequence)",", tStandardApiVersion.getStandardApi().getProjectVersionNameList()));
                }
                StandardApiExportWithXssServiceUtil.setEasyApiInfo(xssfWorkbook.getSheetAt(0), tApiMap);
                ++number;
            }
        }
        return number;
    }
}

