package com.digiwin.athena.apimgmt.apiservice;

import com.digiwin.athena.apimgmt.annotate.OperateAuthorityVerify;
import com.digiwin.athena.apimgmt.constants.ApimgmtConstant;
import com.digiwin.athena.apimgmt.constants.ApimgmtSchemaConstant;
import com.digiwin.athena.apimgmt.dao.ApiMgmtApprovedStatusDao;
import com.digiwin.athena.apimgmt.dao.ApiMgmtStandardApiVersionDao;
import com.digiwin.athena.apimgmt.dao.ApiMgmtVerifyLogDao;
import com.digiwin.athena.apimgmt.dao.ApiMgmtVerityOperateDao;
import com.digiwin.athena.apimgmt.enums.ApiAttributeEnum;
import com.digiwin.athena.apimgmt.exception.BaseException;
import com.digiwin.athena.apimgmt.infra.context.ApiMgmtServiceContextHolder;
import com.digiwin.athena.apimgmt.model.ApprovedStatus;
import com.digiwin.athena.apimgmt.model.StandardApiVersion;
import com.digiwin.athena.apimgmt.model.VerifyLog;
import com.digiwin.athena.apimgmt.model.VerityOperate;
import com.digiwin.athena.apimgmt.validator.ValidatorResult;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.Map;

/**
 * API退回
 * /restful/standard/apimgmt/ApiReject/Update
 */
@Slf4j
@Service
@OperateAuthorityVerify
public class ApiRejectUpdateService extends AbstractApiService {
    
	@Autowired
    ApiMgmtStandardApiVersionDao standardApiVersionDao;

	@Autowired
    ApiMgmtApprovedStatusDao approvedStatusDao;

	@Autowired
    ApiMgmtVerifyLogDao verifyLogDao;

	@Autowired
    ApiMgmtVerityOperateDao verityOperateDao;
	
	public ApiRejectUpdateService() {
		super();
		jsonSchemaFileName = ApimgmtSchemaConstant.API_REJECT_SCHEMA;
	}

	/**
	 * API退回
	 * @param validatorResult validatorResult
	 * @return map
	 * @throws BaseException BaseException
	 * @throws Exception Exception
	 */
	@Override
	protected Map<String, Object> processData(ValidatorResult validatorResult) throws BaseException, Exception {
		String tUserId = ApiMgmtServiceContextHolder.getUserId();
		JsonNode tRequestJsonNode = validatorResult.getJsonContent();
		ArrayNode tApiArrayNode = (ArrayNode) tRequestJsonNode.get(ApimgmtConstant.API_LIST);
		for (JsonNode tApiNode : tApiArrayNode) {
			Map<String, String> tConditionMap = new HashMap<>();
			tConditionMap.put(ApiAttributeEnum.apiName.toString(), tApiNode.get(ApiAttributeEnum.apiName.toString()).asText());
			tConditionMap.put(ApiAttributeEnum.version.toString(), tApiNode.get(ApiAttributeEnum.version.toString()).asText());
			if(tApiNode.get(ApiAttributeEnum.tenantId.toString()) != null){
				tConditionMap.put(ApiAttributeEnum.tenantId.toString(), tApiNode.get(ApiAttributeEnum.tenantId.toString()).asText());
			}
			StandardApiVersion tStandardApiVersion = standardApiVersionDao.fetchApiVersion(tConditionMap);
			if(tStandardApiVersion != null){
				// 草稿
				ApprovedStatus tApprovedStatus = approvedStatusDao.get(1L);
				tStandardApiVersion.setApprovedStatus(tApprovedStatus);
				tStandardApiVersion.setApprovedTime(LocalDateTime.now());
				standardApiVersionDao.saveOrupdate(tStandardApiVersion);
				Long tApiVerId = tStandardApiVersion.getId();
				setLog(tApiVerId, tUserId, tApiNode.get(ApimgmtConstant.REJECT_DESC).asText());
			}
		}
		Map<String, Object> tResponse = new HashMap<>();
		// 組成回傳訊息
		tResponse.put(ApimgmtConstant.CODE, "000");
		tResponse.put(ApimgmtConstant.RESULT, ApimgmtConstant.SUCCESS);
		return tResponse;
	}
	
	private void setLog(Long pApiVerId, String pUserId, String pPaasDesc){
		//退回狀態
		VerityOperate tVerityOperate = verityOperateDao.get(2L);
		VerifyLog tVerifyLog = new VerifyLog();
		tVerifyLog.setApiVerId(pApiVerId);
		tVerifyLog.setVerifyAcct(pUserId);
		tVerifyLog.setVerifyTime(LocalDateTime.now());
		tVerifyLog.setVerityOperate(tVerityOperate);
		tVerifyLog.setReason(pPaasDesc);
		verifyLogDao.save(tVerifyLog);
	}
	
}
