package com.digiwin.athena.apimgmt.model;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;
import lombok.ToString;

import java.io.Serializable;

/**
 * The persistent class for the product_api_data_name database table.
 * 
 */
@Data
@ToString(exclude = {"standardApiDataName"})
@TableName(value = "product_api_data_name", resultMap = "BaseResultMap")
public class ProductApiDataName implements Serializable {
	private static final long serialVersionUID = 1L;

    @TableId(type = IdType.AUTO)
	private Long id;

    @TableField("product_name")
    private String productName;

    @TableField("api_data_name_id")
    private Long apiDataNameId;
    // bi-directional many-to-one association to Product
    @TableField(exist = false)
    private Product product;
    // bi-directional many-to-one association to StandardApiDataName
    @TableField(exist = false)
	private StandardApiDataName standardApiDataName;
    @TableField("length")
	private Integer length;
    @TableField("precisions")
    private Integer precision;

    public void setProduct(Product product) {
        this.product = product;
        this.productName = product.getName();
    }

    public StandardApiDataName getApiDataName() {
		return standardApiDataName;
	}

	public void setApiDataName(StandardApiDataName apiDataName) {
		this.standardApiDataName = apiDataName;
        this.apiDataNameId = apiDataName.getId();
	}

}