package com.digiwin.athena.apimgmt.service.util;

import com.digiwin.athena.apimgmt.model.ProjectVersion;
import com.digiwin.athena.apimgmt.services.ApiMgmtProjectVersionService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * API版本处理类util
 */
@Service
public class ProjectVersionServiceUtil extends GenericServiceUtil<ApiMgmtProjectVersionService> {

	private static ApiMgmtProjectVersionService service;

	@Override
	@Autowired
	public void setService(ApiMgmtProjectVersionService pService) {
		service = pService;
	}

	public static boolean judgeProjectVersionNames(Long projectId, List<String> projectVersionNameList) {
		return service.judgeProjectVersionNames(projectId, projectVersionNameList);
	}

	public static List<ProjectVersion> queryProjectVersionList(Long projectId, List<String> projectVersionNameList) {
		return service.queryProjectVersionList(projectId, projectVersionNameList);
	}

}
