package com.digiwin.athena.apimgmt.apiservice;

import cn.hutool.core.collection.CollUtil;
import com.digiwin.athena.apimgmt.constants.ApimgmtConstant;
import com.digiwin.athena.apimgmt.dao.ApiMgmtStandardApiDao;
import com.digiwin.athena.apimgmt.dao.ApiMgmtStandardApiVersionDao;
import com.digiwin.athena.apimgmt.dao.ApiMgmtTenantConfigDao;
import com.digiwin.athena.apimgmt.infra.context.ApiMgmtServiceContextHolder;
import com.digiwin.athena.apimgmt.model.AdvanceSearchValue;
import com.digiwin.athena.apimgmt.util.StandardApiMessageUtil;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.fge.jackson.JsonLoader;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;

/**
 * 服务于标准API查询-进阶查询、列表查询总数展示
 * /restful/standard/apimgmt/AdvanceSearchApiCount/Get
 */
@Slf4j
@Service
public class AdvanceSearchApiListGetCountService {

    @Autowired
    private ApiMgmtStandardApiDao standardApiDao;

    @Autowired
    private ApiMgmtStandardApiVersionDao standardApiVersionDao;

    @Autowired
    private ApiMgmtTenantConfigDao tenantConfigDao;

    ObjectMapper mapper = new ObjectMapper();

    public AdvanceSearchApiListGetCountService() {
        super();
    }

    /**
     * 进阶查询
     *
     * @param validatorResult validatorResult
     * @return arraylist
     * @throws Exception Exception
     */
    public Map<String, Object> execute(String validatorResult) throws Exception {
        log.info("[Thread.id " + Thread.currentThread().getId() + "]" + "接口: " + this.getClass() +
                ", 原始訊息: " + validatorResult);
        ObjectNode tResponse = mapper.createObjectNode();
        JsonNode tRequestJsonNode = JsonLoader.fromString(validatorResult);
        ArrayNode tConditionArrayNode = (ArrayNode) tRequestJsonNode.get(ApimgmtConstant.CONDITION_LIST);
        JsonNode tCategoryId = tRequestJsonNode.get(ApimgmtConstant.CATEGORY_ID);
        // 产品ID
        JsonNode projectId = tRequestJsonNode.get(ApimgmtConstant.PROJECT_ID);
        //产品版本ID
        JsonNode projectVersionId = tRequestJsonNode.get(ApimgmtConstant.PROJECT_VERSION_ID);
        String tTenantId = ApiMgmtServiceContextHolder.getTenantId();
        String teamType = ApiMgmtServiceContextHolder.getTeamType();
        boolean tViewAllApi = tenantConfigDao.viewAllApiTenantExist(tTenantId);
        // 查询条件
        List<List<AdvanceSearchValue>> arrayList = StandardApiMessageUtil.generateQuery(tConditionArrayNode,
                tCategoryId, null, null, projectId, projectVersionId, null);
        // 用于标准查询-根据api去重-展示最新的api版本
        List<Long> ids = standardApiDao.advanceStandardApiCountSearch(arrayList, teamType, tTenantId, tViewAllApi);
        setStandardApiCountResponse(ids, tResponse);
        return mapper.convertValue(tResponse, new TypeReference<Map<String, Object>>() {
        });
    }

    // 后续可以采用多节点,节省时间
    private void setStandardApiCountResponse(List<Long> ids, ObjectNode tResponse) {
        long draftNum = 0;
        long underReview = 0;
        long developingNum = 0;
        long confirmedNum = 0;
        long deactivateNum = 0;
        long total = 0;
        if (CollUtil.isNotEmpty(ids)) {
            Map<Long, Long> countValue = standardApiVersionDao.advanceStandardApiCountByVersionIds(ids);
            draftNum = null == countValue.get(1L) ? 0 : countValue.get(1L);
            underReview = null == countValue.get(2L) ? 0 : countValue.get(2L);
            developingNum = null == countValue.get(3L) ? 0 : countValue.get(3L);
            confirmedNum = null == countValue.get(4L) ? 0 : countValue.get(4L);
            deactivateNum = null == countValue.get(5L) ? 0 : countValue.get(5L);
            total = draftNum + underReview + developingNum + confirmedNum + deactivateNum;
        }
        tResponse.put(ApimgmtConstant.DRAFT_NUM, draftNum);
        tResponse.put(ApimgmtConstant.UNDER_REVIEW_NUM, underReview);
        tResponse.put(ApimgmtConstant.DEVELOPING_NUM, developingNum);
        tResponse.put(ApimgmtConstant.CONFIRMED_NUM, confirmedNum);
        tResponse.put(ApimgmtConstant.DEACTIVATE_NUM, deactivateNum);
        tResponse.put(ApimgmtConstant.PAGE_TOTAL, total);
    }

}
