package com.digiwin.athena.apimgmt.service.util;

import com.digiwin.athena.apimgmt.dao.*;
import com.digiwin.athena.apimgmt.services.ApiMgmtDaoService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * dao处理类util
 */
@Service
public class DaoServiceUtil extends GenericServiceUtil<ApiMgmtDaoService> {

	private static ApiMgmtDaoService service;

	@Autowired
	@Override
	public void setService(ApiMgmtDaoService pService) {
		service = pService;
	}

	public static ApiMgmtDaoService getService() {
		if (service == null) {
			service = (ApiMgmtDaoService) org.springframework.web.context.ContextLoader.getCurrentWebApplicationContext().getBean(ApiMgmtDaoService.class.getAnnotation(Service.class).value());
		}
		return service;
	}


	// 2017-04-11 Neville Hsieh
	public static ApiMgmtStandardApiDataNameDao getStandardApiDataNameDao() {
		return getService().getStandardApiDataNameDao();
	}

	// 2017-12-05 Cherry Wang
	public static ApiMgmtStandardDataNameDao getStandardDataNameDao() {
		return getService().getStandardDataNameDao();
	}

	// 2017-08-08 Cherry Wang
	public static ApiMgmtApprovedStatusDao getApprovedStatusDao() {
		return getService().getApprovedStatusDao();
	}

	// 2017-08-08 Cherry Wang
	public static ApiMgmtStandardApiGroupDao getStandardApiGroupDao() {
		return getService().getStandardApiGroupDao();
	}
	
	public static ApiMgmtStandardApiPagingDao getStandardApiPagingDao() {
		return getService().getStandardApiPagingDao();
	}
	
	public static ApiMgmtStandardApiVersionDao getStandardApiVersionDao() {
		return getService().getStandardApiVersionDao();
	}

	public static ApiMgmtPrdApiVersionMappingDao getPrdApiVersionMappingDao() {
		return getService().getPrdApiVersionMappingDao();
	}
	
	public static ApimgmtProductDao getProductDao() {
		return getService().getProductDao();
	}
	
	public static ApiMgmtStateCodeDao getStateCodeDao() {
		return getService().getStateCodeDao();
	}

}