package com.digiwin.athena.apimgmt.services;

import cn.hutool.core.util.URLUtil;
import com.digiwin.athena.apimgmt.constants.ApimgmtConstant;
import com.digiwin.athena.apimgmt.constants.ApimgmtInterfaceConstant;
import com.digiwin.athena.apimgmt.infra.http.HttpFailedException;
import com.digiwin.athena.apimgmt.infra.http.HttpRequest;
import com.digiwin.athena.apimgmt.infra.util.HttpUtil;
import com.digiwin.athena.apimgmt.model.StandardApi;
import com.digiwin.athena.apimgmt.model.StandardApiVersion;
import com.digiwin.athena.apimgmt.service.model.ApiVer;
import com.digiwin.athena.apimgmt.service.model.DelApiInfo;
import com.digiwin.athena.apimgmt.service.model.MdcResponse;
import com.digiwin.athena.apimgmt.service.util.DaoServiceUtil;
import com.digiwin.athena.apimgmt.service.util.MailServiceUtil;
import com.google.gson.GsonBuilder;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.List;

@Slf4j
@Service
public class ApiMgmtSyncMdcDeleteService {


    /**
     * 删除API元数据
     *
     * @param pListDelApiId pListDelApiId
     * @param pSyncUrl      pSyncUrl
     * @param sendMqJudge   sendMqJudge
     */
    public void runSyncMdcMetadataDel(List<Long> pListDelApiId, String pSyncUrl, Boolean sendMqJudge, String tUserId, String tToken, String routerKey) {
        DelApiInfo tDelApiInfo = new DelApiInfo();
        if (null != sendMqJudge) {
            tDelApiInfo.setSendMqJudge(sendMqJudge);
        }
        for (Long tDelApiId : pListDelApiId) {
            StandardApiVersion tStandardApiVersion = DaoServiceUtil.getStandardApiVersionDao().get(tDelApiId);
            StandardApi tStandardApi = tStandardApiVersion.getStandardApi();
            //非esp的API不需要同步
            if (tStandardApi.skipSyncMdc()) {
                continue;
            }
            String tApiName = tStandardApi.getName();
            String tTenantId = tStandardApi.getTenantId();
            String tApiVerNum = tStandardApiVersion.getVersion();
            tTenantId = StringUtils.defaultIfBlank(tTenantId, "");
            ApiVer tApiVer = new ApiVer(tApiName, tTenantId, tApiVerNum);
            tDelApiInfo.getApi_info().add(tApiVer);
        }
        runSyncMdcMetadataDel(tDelApiInfo, pSyncUrl, tUserId, tToken, routerKey);
    }

    /**
     * API取回得时候同步删除MDC
     *
     * @param pDelApiInfo pDelApiInfo
     * @param pSyncUrl    pSyncUrl
     */
    private void runSyncMdcMetadataDel(DelApiInfo pDelApiInfo, String pSyncUrl, String tUserId, String tToken, String routerKey) {
        // 判斷是哪一區，並取得對應的參數
        String tUrl = URLUtil.completeUrl(pSyncUrl, ApimgmtInterfaceConstant.MDC_METADATA_DELETE);
        String tStrJsonRequestBody = "";
        int httpStatusCode = -1;
        String tResponseMessage = "";
        try {
            tStrJsonRequestBody = (new GsonBuilder().disableHtmlEscaping()).create().toJson(pDelApiInfo);
            HttpRequest tHttpPost = HttpRequest.ofPost(tUrl);
            tHttpPost.setEntity(tStrJsonRequestBody);
            tHttpPost.setHeader(ApimgmtConstant.TOKEN, tToken);
            tHttpPost.setHeader("userId", tUserId);
            if (null != routerKey) {
                tHttpPost.setHeader(ApimgmtConstant.ROUTER_KEY, routerKey);
            }
            MdcResponse tMdcResponse = HttpUtil.execute(tHttpPost, MdcResponse.class);
            String tMdcStatCode = tMdcResponse.getExecution().getCode();
            tResponseMessage = tMdcResponse.getExecution().getDescription();
            if (!"000".equals(tMdcStatCode)) {
                String tMailContent = MessageFormat.format("<HTML><BODY>{0} {1}<BR>{2}<BR><BR><BR>請求MDC url: {3}<BR>request message body: {4}<BR>HTTP狀態碼: {5}<BR>MDC回應的訊息: {6}</BODY></HTML>",
                        ApimgmtConstant.SUBJECT_SYNC_DEL_FAIL,
                        (new SimpleDateFormat("yyyy-MM-dd HH:mm:ss")).format(Calendar.getInstance().getTime()),
                        genDelApiDataInfoStr(pDelApiInfo),
                        tUrl, tStrJsonRequestBody, httpStatusCode, tResponseMessage);
                MailServiceUtil.sendMailToAdmin(tMailContent, ApimgmtConstant.SUBJECT_SYNC_DEL_FAIL);
            }
        } catch (Exception e) {
            if (e instanceof HttpFailedException) {
                httpStatusCode = ((HttpFailedException) e).getStatusCode();
                tResponseMessage = ((HttpFailedException) e).getRespBody();
            } else {
                httpStatusCode = 500;
                tResponseMessage = e.getMessage();
            }
            String tMailContent = MessageFormat.format("<HTML><BODY>{0} {1}<BR>{2}<BR><BR><BR>請求MDC url: {3}<BR>request message body: {4}<BR>HTTP狀態碼: {5}<BR>MDC回應的訊息: {6}</BODY></HTML>",
                    ApimgmtConstant.SUBJECT_SYNC_DEL_FAIL,
                    (new SimpleDateFormat("yyyy-MM-dd HH:mm:ss")).format(Calendar.getInstance().getTime()),
                    genDelApiDataInfoStr(pDelApiInfo),
                    tUrl, tStrJsonRequestBody, httpStatusCode, tResponseMessage);
            MailServiceUtil.sendMailToAdmin(tMailContent, ApimgmtConstant.SUBJECT_SYNC_DEL_FAIL);
        }
    }

    private String genDelApiDataInfoStr(DelApiInfo pDelApiInfo) {
        String tStr = "";
        try {
            for (ApiVer tDelApiVer : pDelApiInfo.getApi_info()) {
                String tApiName = tDelApiVer.getName();
                String tApiVer = tDelApiVer.getVersion();
                String tTenantId = tDelApiVer.getTenant_id();
                tStr = MessageFormat.format("{0}{1}API名稱: {2}, API版本: {3}, 租戶ID: {4}", tStr, "<BR>", tApiName, tApiVer, tTenantId);
            }
        } catch (Exception e) {
            log.error(e.getMessage(), e);
        }
        return tStr;
    }

}
