/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.apimgmt.dao.impl.mybatis;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.IdUtil;
import com.digiwin.athena.apimgmt.dao.ApiMgmtStandardApiDataNameDao;
import com.digiwin.athena.apimgmt.dao.impl.mybatis.ApiMgmtProductApiDataNameDaoMybatisImpl;
import com.digiwin.athena.apimgmt.dao.impl.mybatis.GenericDaoMybatisImpl;
import com.digiwin.athena.apimgmt.dao.impl.mybatis.mapper.ApiMgmtStandardApiDataNameMapper;
import com.digiwin.athena.apimgmt.model.ProductApiDataName;
import com.digiwin.athena.apimgmt.model.StandardApiDataName;
import com.digiwin.athena.apimgmt.model.StandardApiVersion;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Repository;

@Primary
@Repository
public class ApiMgmtStandardApiDataNameDaoMybatisImpl
extends GenericDaoMybatisImpl<ApiMgmtStandardApiDataNameMapper, StandardApiDataName, Integer>
implements ApiMgmtStandardApiDataNameDao {
    protected ApiMgmtProductApiDataNameDaoMybatisImpl productApiDataNameDao;

    @Override
    public List<StandardApiDataName> getByApiVerId(Long pApiId, Boolean pShowField) {
        return ((ApiMgmtStandardApiDataNameMapper)this.baseMapper).getByApiVerId(pApiId, pShowField);
    }

    @Override
    public List<StandardApiDataName> getByApiVerIdAndMsgType(Long pApiId, Integer pMsgType, Boolean pShowField) {
        return ((ApiMgmtStandardApiDataNameMapper)this.baseMapper).getByApiVerIdAndMsgType(pApiId, pMsgType, pShowField);
    }

    @Override
    public List<StandardApiDataName> selectByVersionIds(List<Long> subIdList) {
        return ((ApiMgmtStandardApiDataNameMapper)this.baseMapper).selectByVersionIds(subIdList);
    }

    @Override
    public void batchSave(List<StandardApiDataName> list) {
        if (CollUtil.isEmpty(list)) {
            return;
        }
        this.setParentId(null, list);
        List allList = list.stream().flatMap(StandardApiDataName::flatten).collect(Collectors.toList());
        List<ProductApiDataName> productApiDataNameList = allList.stream().flatMap(v -> v.getProductApiDataNames().stream()).collect(Collectors.toList());
        CollUtil.split(allList, (int)200).forEach(v -> ((ApiMgmtStandardApiDataNameMapper)this.baseMapper).insertList((List<StandardApiDataName>)v));
        this.productApiDataNameDao.batchSave(productApiDataNameList);
    }

    protected void setParentId(StandardApiDataName parent, List<StandardApiDataName> list) {
        if (parent != null && parent.getId() == null) {
            parent.setId(IdUtil.getSnowflakeNextId());
        }
        CollUtil.emptyIfNull(list).forEach(v -> {
            v.setParent(parent);
            this.setParentId((StandardApiDataName)v, v.getChildrens());
        });
    }

    @Override
    public int deleteByApiVerId(Long apiVerId) {
        this.productApiDataNameDao.deleteByApiVerId(apiVerId);
        return ((ApiMgmtStandardApiDataNameMapper)this.baseMapper).deleteByApiVerId(apiVerId);
    }

    @Override
    public void fillStandardApiDataNames(List<StandardApiVersion> versions) {
        if (CollUtil.isEmpty(versions)) {
            return;
        }
        CollUtil.split(versions, (int)50).forEach(subList -> {
            List<Long> subIdList = subList.stream().map(StandardApiVersion::getId).collect(Collectors.toList());
            List<StandardApiDataName> dataNames = this.selectByVersionIds(subIdList);
            Map<Long, List<StandardApiDataName>> dataNameMap = dataNames.stream().collect(Collectors.groupingBy(StandardApiDataName::getApiVerId));
            subList.forEach(ver -> {
                List list = (List)dataNameMap.get(ver.getId());
                if (CollUtil.isNotEmpty((Collection)list)) {
                    list.forEach(v -> v.setStandardApiVersion((StandardApiVersion)ver));
                    ver.setStandardApiDataNames(list);
                }
            });
        });
    }

    @Autowired
    public void setProductApiDataNameMapper(ApiMgmtProductApiDataNameDaoMybatisImpl productApiDataNameDao) {
        this.productApiDataNameDao = productApiDataNameDao;
    }
}

