package com.digiwin.athena.apimgmt.dto;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.apimgmt.model.ApiParamText;

import java.util.Date;

public class ApiParamTextResDto {
    private Long textId;
    private JSONObject requestText;
    private JSONObject responseText;

    private String createdBy;
    private Date createdTime;
    private String editBy;
    private Date editTime;

    public static ApiParamTextResDto create(ApiParamText apiParamText) {
        ApiParamTextResDto apiParamTextResDto = new ApiParamTextResDto();
        apiParamTextResDto.setTextId(apiParamText.getTextId());
        apiParamTextResDto.setCreatedBy(apiParamText.getCreatedBy());
        apiParamTextResDto.setCreatedTime(apiParamText.getCreatedTime());
        apiParamTextResDto.setEditBy(apiParamText.getEditBy());
        apiParamTextResDto.setEditTime(apiParamText.getEditTime());

        if (StrUtil.isNotEmpty(apiParamText.getRequestText())){
            apiParamTextResDto.setRequestText(JSONObject.parseObject(apiParamText.getRequestText(), JSONObject.class));
        }

        if (StrUtil.isNotEmpty(apiParamText.getResponseText())){
            apiParamTextResDto.setResponseText(JSONObject.parseObject(apiParamText.getResponseText(), JSONObject.class));
        }
        return apiParamTextResDto;
    }


    public Long getTextId() {
        return textId;
    }

    public void setTextId(Long textId) {
        this.textId = textId;
    }

    public JSONObject getRequestText() {
        return requestText;
    }

    public void setRequestText(JSONObject requestText) {
        this.requestText = requestText;
    }

    public JSONObject getResponseText() {
        return responseText;
    }

    public void setResponseText(JSONObject responseText) {
        this.responseText = responseText;
    }

    public String getCreatedBy() {
        return createdBy;
    }

    public void setCreatedBy(String createdBy) {
        this.createdBy = createdBy;
    }

    public Date getCreatedTime() {
        return createdTime;
    }

    public void setCreatedTime(Date createdTime) {
        this.createdTime = createdTime;
    }

    public String getEditBy() {
        return editBy;
    }

    public void setEditBy(String editBy) {
        this.editBy = editBy;
    }

    public Date getEditTime() {
        return editTime;
    }

    public void setEditTime(Date editTime) {
        this.editTime = editTime;
    }
}
