package com.digiwin.athena.apimgmt.apiservice;

import com.digiwin.athena.apimgmt.annotate.OperateAuthorityVerify;
import com.digiwin.athena.apimgmt.constants.ApimgmtConstant;
import com.digiwin.athena.apimgmt.constants.ApimgmtSchemaConstant;
import com.digiwin.athena.apimgmt.dao.ApiMgmtStandardApiDao;
import com.digiwin.athena.apimgmt.dao.ApiMgmtStandardApiVersionDao;
import com.digiwin.athena.apimgmt.enums.ApiAttributeEnum;
import com.digiwin.athena.apimgmt.exception.BaseException;
import com.digiwin.athena.apimgmt.model.StandardApiVersion;
import com.digiwin.athena.apimgmt.service.util.ApiVersionServiceUtil;
import com.digiwin.athena.apimgmt.validator.ValidatorResult;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * API刪除
 * /restful/standard/apimgmt/ApiDelete/Delete
 */
@Slf4j
@Service
@OperateAuthorityVerify
public class ApiDeleteService extends AbstractApiService {
	
	@Autowired
    ApiMgmtStandardApiVersionDao standardApiVersionDao;

	@Autowired
    ApiMgmtStandardApiDao standardApiDao;
	
	public ApiDeleteService() {
		super();
		jsonSchemaFileName = ApimgmtSchemaConstant.API_DELETE_SCHEMA;
	}

	/**
	 * 删除API
	 * @param validatorResult validatorResult
	 * @return map
	 * @throws BaseException BaseException
	 * @throws Exception Exception
	 */
	@Override
	protected Map<String, Object> processData(ValidatorResult validatorResult) throws BaseException, Exception {
		JsonNode tRequestJsonNode = validatorResult.getJsonContent();
		ArrayNode tApiArrayNode = (ArrayNode) tRequestJsonNode.get(ApimgmtConstant.API_LIST);
		for (JsonNode tApiNode : tApiArrayNode) {
			Map<String, String> tConditionMap = new HashMap<>();
			// 取得入參api名稱
			String tApiName = tApiNode.get(ApiAttributeEnum.apiName.toString()).asText();
			// 取得入參api版號
			String tVersion = tApiNode.get(ApiAttributeEnum.version.toString()).asText();
			// branch
			String branch = ApiVersionServiceUtil.getBranchFromVersion(tVersion);

			String tTenant = "";
			// 取得入參租戶id
			if (tApiNode.get(ApiAttributeEnum.tenantId.toString()) != null) {
				tTenant = tApiNode.get(ApiAttributeEnum.tenantId.toString()).asText();
			}
			tConditionMap.put(ApiAttributeEnum.apiName.toString(), tApiName);
			tConditionMap.put(ApiAttributeEnum.version.toString(), tVersion);
			tConditionMap.put(ApiAttributeEnum.tenantId.toString(), tTenant);
			StandardApiVersion tStandardApiVersion = standardApiVersionDao.fetchApiVersion(tConditionMap);
			if(tStandardApiVersion != null){
				List<StandardApiVersion> tStandardApiVersions = standardApiVersionDao.fetchApiVersionsByName(tApiName, branch, tTenant);
				// 如果只有一个删除api、api版本、api元数据
				standardApiVersionDao.delete(tStandardApiVersion.getId(), tStandardApiVersions.size() <= 1);
			}
		}
		Map<String, Object> tResponse = new HashMap<>();
		// 組成回傳訊息
		tResponse.put(ApimgmtConstant.CODE, "000");
		tResponse.put(ApimgmtConstant.RESULT, ApimgmtConstant.SUCCESS);
		return tResponse;
	}
	
}
