package com.digiwin.athena.apimgmt.dao.impl.mybatis;

import cn.hutool.core.collection.CollUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.digiwin.athena.apimgmt.dao.ApiMgmtProjectVersionDao;
import com.digiwin.athena.apimgmt.dao.ApiMgmtProjectVersionRelationDao;
import com.digiwin.athena.apimgmt.dao.impl.mybatis.mapper.ApiMgmtProjectVersionRelationMapper;
import com.digiwin.athena.apimgmt.facade.dto.ApiMgmtApiProjectVerDTO;
import com.digiwin.athena.apimgmt.model.ProjectVersionRelation;
import com.digiwin.athena.apimgmt.model.StandardApi;
import com.digiwin.athena.apimgmt.model.StandardApiVersion;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Repository;

import java.util.*;
import java.util.stream.Collectors;

@Primary
@Repository
public class ApiMgmtProjectVersionRelationDaoMybatisImpl
        extends GenericDaoMybatisImpl<ApiMgmtProjectVersionRelationMapper, ProjectVersionRelation, Long>
        implements ApiMgmtProjectVersionRelationDao {

    private ApiMgmtProjectVersionDao projectVersionDao;

    @Override
    public List<ProjectVersionRelation> getByProjectId(Long projectId) {
        LambdaQueryWrapper<ProjectVersionRelation> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(ProjectVersionRelation::getProjectId, projectId);
        return baseMapper.selectList(wrapper);
    }

    @Override
    public List<ProjectVersionRelation> getByProjectVersionId(String projectVersionId) {
        LambdaQueryWrapper<ProjectVersionRelation> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(ProjectVersionRelation::getProjectVersionId, projectVersionId);
        return baseMapper.selectList(wrapper);
    }

    @Override
    public List<ProjectVersionRelation> getByApiId(Long apiId) {
        LambdaQueryWrapper<ProjectVersionRelation> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(ProjectVersionRelation::getApiId, apiId);
        return baseMapper.selectList(wrapper);
    }

    @Override
    public int deleteByApiId(Long apiId) {
        LambdaQueryWrapper<ProjectVersionRelation> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(ProjectVersionRelation::getApiId, apiId);
        return baseMapper.delete(wrapper);
    }

    @Override
    public Long countByProjectId(Long projectId) {
        LambdaQueryWrapper<ProjectVersionRelation> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(ProjectVersionRelation::getProjectId, projectId);
        return baseMapper.selectCount(wrapper);
    }

    @Override
    public Long countByProjectVersionId(List<Long> projectVersionIds) {
        LambdaQueryWrapper<ProjectVersionRelation> wrapper = new LambdaQueryWrapper<>();
        wrapper.in(ProjectVersionRelation::getProjectVersionId, projectVersionIds);
        return baseMapper.selectCount(wrapper);
    }

    @Override
    public List<ProjectVersionRelation> selectByApiId(Long apiId) {
        LambdaQueryWrapper<ProjectVersionRelation> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(ProjectVersionRelation::getApiId, apiId);
        return baseMapper.selectList(wrapper);
    }

    @Override
    public void batchSave(List<ProjectVersionRelation> newProjectVersionList) {
        CollUtil.split(newProjectVersionList, 100)
                .forEach(subList -> baseMapper.saveList(
                        subList,
                        CollUtil.getFirst(subList).getRelationId() != null)
                );
    }

    @Override
    public List<ProjectVersionRelation> selectByApiIds(List<Long> apiIds) {
        if (CollUtil.isEmpty(apiIds)) {
            return CollUtil.newArrayList();
        }
        LambdaQueryWrapper<ProjectVersionRelation> wrapper = new LambdaQueryWrapper<>();
        wrapper.in(ProjectVersionRelation::getApiId, apiIds);
        return baseMapper.selectList(wrapper);
    }

    @Override
    public void fillRelationToVersion(List<StandardApiVersion> versions) {
        if (CollUtil.isEmpty(versions)) {
            return;
        }

        List<StandardApi> apiList = versions.stream()
                .map(StandardApiVersion::getStandardApi)
                .filter(Objects::nonNull)
                .distinct()
                .collect(Collectors.toList());

        fillProjectVersionRelations(apiList);
    }

    @Override
    public void fillProjectVersionRelations(List<StandardApi> apiList) {
        if (CollUtil.isEmpty(apiList)) {
            return;
        }

        CollUtil.split(apiList, 200).forEach(subList -> {
            List<Long> apiIdList = subList.stream()
                    .map(StandardApi::getId)
                    .filter(Objects::nonNull)
                    .collect(Collectors.toList());

            List<ProjectVersionRelation> relations = selectByApiIds(apiIdList);

            Map<Long, List<ProjectVersionRelation>> relationMap = relations.stream()
                    .collect(Collectors.groupingBy(ProjectVersionRelation::getApiId));

            subList.forEach(api -> {
                List<ProjectVersionRelation> list = relationMap.get(api.getId());

                if (CollUtil.isNotEmpty(list)) {
                    list.forEach(v -> v.setStandardApi(api));
                    api.setProjectVersionRelations(list);
                }
            });
        });
    }

    @Override
    public Map<Long, List<ApiMgmtApiProjectVerDTO>> selectProjectVerMapByApi(List<Long> apiIds) {
        if (CollUtil.isEmpty(apiIds)) {
            return Collections.emptyMap();
        }

        List<ApiMgmtApiProjectVerDTO> pairList = baseMapper.selectProjectVersionNamesByApiIds(apiIds);
        Set<Long> hasVersionProjectId = projectVersionDao.selectExistProjectId(
                pairList.stream()
                        .map(ApiMgmtApiProjectVerDTO::getProjectId).distinct().collect(Collectors.toList())
        );

        pairList.forEach(v -> v.setProjectHasVersion(hasVersionProjectId.contains(v.getProjectId())));


        return pairList.stream()
                .collect(Collectors.groupingBy(
                        ApiMgmtApiProjectVerDTO::getApiId
                ));
    }


    @Autowired
    public void setProjectVersionDao(ApiMgmtProjectVersionDao projectVersionDao) {
        this.projectVersionDao = projectVersionDao;
    }
}
