package com.digiwin.athena.apimgmt.service.util;

import cn.hutool.core.io.IoUtil;
import com.digiwin.athena.apimgmt.model.StandardApiVersion;
import com.digiwin.athena.apimgmt.services.ApiMgmtStandardApiExportWithXssService;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Map;

/**
 * api导出处理类util
 */
@Service
public class StandardApiExportWithXssServiceUtil extends GenericServiceUtil<ApiMgmtStandardApiExportWithXssService> {

    private static ApiMgmtStandardApiExportWithXssService service;

    @Override
    @Autowired
    public void setService(ApiMgmtStandardApiExportWithXssService pService) {
        service = pService;
    }

    public static Workbook createXSSFWorkbook() {
        return service.createXSSFWorkbook(false);
    }


    public static Workbook createSXSSFWorkbook() {
        return service.createXSSFWorkbook(true);
    }

    public static void createXSSFSheet(Workbook xssfWorkbook, StandardApiVersion tStandardApiVersion, Integer number) {
        service.createXSSFSheet(xssfWorkbook, tStandardApiVersion, number);
    }

    public static void setEasyApiInfo(Sheet xssfSheet, Map<String, Object> objectMap) {
        service.setEasyApiInfo(xssfSheet, objectMap);
    }

    public static Boolean removeFile(String pFilePath) {
        return service.removeFile(pFilePath);
    }

    public static void close(Workbook xssfWorkbook) {
        if (xssfWorkbook == null) {
            return;
        }

        IoUtil.close(xssfWorkbook);
        if (xssfWorkbook instanceof SXSSFWorkbook) {
            ((SXSSFWorkbook) xssfWorkbook).dispose();
        }
    }

}
