/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.apimgmt.dao.impl.mybatis;

import cn.hutool.core.collection.CollUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.digiwin.athena.apimgmt.dao.ApiMgmtProjectVersionDao;
import com.digiwin.athena.apimgmt.dao.impl.mybatis.GenericDaoMybatisImpl;
import com.digiwin.athena.apimgmt.dao.impl.mybatis.mapper.ApiMgmtProjectVersionMapper;
import com.digiwin.athena.apimgmt.model.ProjectVersion;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Primary
@Repository
@Transactional
public class ApiMgmtProjectVersionDaoMybatisImpl
extends GenericDaoMybatisImpl<ApiMgmtProjectVersionMapper, ProjectVersion, Long>
implements ApiMgmtProjectVersionDao {
    @Override
    public List<ProjectVersion> getByProjectId(Long projectId) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(ProjectVersion::getProjectId, (Object)projectId);
        return ((ApiMgmtProjectVersionMapper)this.baseMapper).selectList((Wrapper)wrapper);
    }

    @Override
    public List<ProjectVersion> getByProjectVersionName(String projectVersionName) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(ProjectVersion::getProjectVersionName, (Object)projectVersionName);
        return ((ApiMgmtProjectVersionMapper)this.baseMapper).selectList((Wrapper)wrapper);
    }

    @Override
    public List<ProjectVersion> getByProjectVersionNames(List<String> projectVersionNames) {
        if (CollUtil.isEmpty(projectVersionNames)) {
            return Collections.emptyList();
        }
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.in(ProjectVersion::getProjectVersionName, projectVersionNames);
        return ((ApiMgmtProjectVersionMapper)this.baseMapper).selectList((Wrapper)wrapper);
    }

    @Override
    public List<ProjectVersion> getByProjectVersionNames(Long projectId, List<String> projectVersionNames) {
        if (CollUtil.isEmpty(projectVersionNames)) {
            return Collections.emptyList();
        }
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)wrapper.eq(ProjectVersion::getProjectId, (Object)projectId)).in(ProjectVersion::getProjectVersionName, projectVersionNames);
        return ((ApiMgmtProjectVersionMapper)this.baseMapper).selectList((Wrapper)wrapper);
    }

    @Override
    public List<ProjectVersion> queryProjectVersionByIdList(List<Long> idList) {
        if (CollUtil.isEmpty(idList)) {
            return Collections.emptyList();
        }
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.in(ProjectVersion::getProjectVersionId, idList);
        return ((ApiMgmtProjectVersionMapper)this.baseMapper).selectList((Wrapper)wrapper);
    }

    @Override
    public List<ProjectVersion> selectByProjectIds(List<Long> projectIds) {
        if (CollUtil.isEmpty(projectIds)) {
            return Collections.emptyList();
        }
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.in(ProjectVersion::getProjectId, projectIds);
        return ((ApiMgmtProjectVersionMapper)this.baseMapper).selectList((Wrapper)wrapper);
    }

    @Override
    public Integer deleteByIds(List<Long> projectVersionIds) {
        if (CollUtil.isEmpty(projectVersionIds)) {
            return 0;
        }
        return ((ApiMgmtProjectVersionMapper)this.baseMapper).deleteBatchIds(projectVersionIds);
    }

    @Override
    public void batchUpdate(List<ProjectVersion> updateVersionList) {
        this.batchSave(updateVersionList);
    }

    @Override
    public void deleteByProjectId(Long projectId) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(ProjectVersion::getProjectId, (Object)projectId);
        ((ApiMgmtProjectVersionMapper)this.baseMapper).delete((Wrapper)wrapper);
    }

    @Override
    public void batchSave(List<ProjectVersion> projectVersionList) {
        if (CollUtil.isEmpty(projectVersionList)) {
            return;
        }
        CollUtil.split(projectVersionList, (int)50).forEach(list -> ((ApiMgmtProjectVersionMapper)this.baseMapper).batchSave((List<ProjectVersion>)list, ((ProjectVersion)CollUtil.getFirst((Iterable)list)).getProjectVersionId() != null));
    }

    @Override
    public Set<Long> selectExistProjectId(List<Long> projectIds) {
        if (CollUtil.isEmpty(projectIds)) {
            return Collections.emptySet();
        }
        return ((ApiMgmtProjectVersionMapper)this.baseMapper).selectExistProjectId(projectIds);
    }
}

