/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.apimgmt.services;

import cn.hutool.core.collection.CollUtil;
import com.digiwin.athena.apimgmt.dao.ApimgmtProductDao;
import com.digiwin.athena.apimgmt.enums.MessageTypeEnum;
import com.digiwin.athena.apimgmt.enums.SyncMetaDataCacheResultEnum;
import com.digiwin.athena.apimgmt.infra.prop.ApiMgmtMdcProp;
import com.digiwin.athena.apimgmt.model.Product;
import com.digiwin.athena.apimgmt.model.ProductApiDataName;
import com.digiwin.athena.apimgmt.model.StandardApi;
import com.digiwin.athena.apimgmt.model.StandardApiDataName;
import com.digiwin.athena.apimgmt.model.StandardApiVersion;
import com.digiwin.athena.apimgmt.model.SyncMdcFailData;
import com.digiwin.athena.apimgmt.service.model.AddApiData;
import com.digiwin.athena.apimgmt.service.model.AddApiVer;
import com.digiwin.athena.apimgmt.service.model.ApiDataName;
import com.digiwin.athena.apimgmt.service.model.ApiDataNameLength;
import com.digiwin.athena.apimgmt.service.model.ApiDataNamePrecision;
import com.digiwin.athena.apimgmt.service.model.ApiMetaData;
import com.digiwin.athena.apimgmt.service.model.ApiVerInfo;
import com.digiwin.athena.apimgmt.service.model.Description;
import com.digiwin.athena.apimgmt.service.model.HeaderField;
import com.digiwin.athena.apimgmt.service.model.IRequest;
import com.digiwin.athena.apimgmt.service.model.ListEnum;
import com.digiwin.athena.apimgmt.service.model.Remark;
import com.digiwin.athena.apimgmt.service.model.Request;
import com.digiwin.athena.apimgmt.service.model.ResponseFailed;
import com.digiwin.athena.apimgmt.service.model.ResponseSuccess;
import com.digiwin.athena.apimgmt.service.util.DaoServiceUtil;
import com.digiwin.athena.apimgmt.services.ApiMgmtSyncMdcService;
import com.digiwin.athena.apimgmt.util.StandardApiMessageUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ApiMgmtSyncMdcAddService {
    @Autowired
    private ApimgmtProductDao productDao;
    @Autowired
    private ApiMgmtSyncMdcService syncMdcService;
    @Autowired
    private ApiMgmtMdcProp mdcProp;

    public Map<String, String> runSyncMdcMetadataAdd(List<Long> pListApiVerIdNeedToSyncMetadata, String pSyncUrl, String tUserId, String tToken, String routerKey) {
        HashMap<String, String> tResult = new HashMap<String, String>();
        int tSize = pListApiVerIdNeedToSyncMetadata.size();
        if (0 < tSize) {
            Integer mdcBatchNum = this.mdcProp.getBatchNum();
            int sum = (int)Math.ceil(1.0 * (double)tSize / (double)mdcBatchNum.intValue());
            for (int i = 0; i < sum; ++i) {
                AddApiData tAddApiData = new AddApiData();
                List<Long> data = pListApiVerIdNeedToSyncMetadata.subList(i * mdcBatchNum, Math.min(i * mdcBatchNum + mdcBatchNum, tSize));
                for (Long tApiVerId : data) {
                    AddApiVer tAddApiVer = this.buildModel(tApiVerId);
                    if (StandardApi.skipSyncMdc(tAddApiVer.getApiType(), tAddApiVer.getApi_extend())) continue;
                    tAddApiData.getApi_data().add(tAddApiVer);
                }
                this.syncMdcService.reqSyncMdcMetadataAdd(data, tAddApiData, pSyncUrl, tUserId, tToken, routerKey);
            }
        }
        tResult.put(SyncMetaDataCacheResultEnum.RESULT.toString(), Boolean.TRUE.toString());
        return tResult;
    }

    public void reqSyncMdcMetadataAddCompensate(List<SyncMdcFailData> syncMdcFailDataList, String pSyncUrl) {
        int tSize = syncMdcFailDataList.size();
        if (0 < tSize) {
            Integer mdcBatchNum = this.mdcProp.getBatchNum();
            int sum = (int)Math.ceil(1.0 * (double)tSize / (double)mdcBatchNum.intValue());
            for (int i = 0; i < sum; ++i) {
                AddApiData tAddApiData = new AddApiData();
                List<SyncMdcFailData> data = syncMdcFailDataList.subList(i * mdcBatchNum, Math.min(i * mdcBatchNum + mdcBatchNum, tSize));
                for (SyncMdcFailData syncMdcFailData : data) {
                    AddApiVer tAddApiVer = this.buildModel(syncMdcFailData.getApiVerId());
                    if (StandardApi.skipSyncMdc(tAddApiVer.getApiType(), tAddApiVer.getApi_extend())) continue;
                    tAddApiData.getApi_data().add(tAddApiVer);
                }
                this.syncMdcService.reqSyncMdcMetadataAddCompensate(data, tAddApiData, pSyncUrl);
            }
        }
    }

    private void buildSubModel(ApiDataName pApiDataName, List<StandardApiDataName> pListOfHierarchyNodes) {
        for (StandardApiDataName tStandardApiDataName : pListOfHierarchyNodes) {
            ApiDataName tApiDataName = new ApiDataName();
            tApiDataName.setData_name(tStandardApiDataName.getStandardDataName());
            if (null != tStandardApiDataName.getChildrens() && 0 < tStandardApiDataName.getChildrens().size()) {
                tApiDataName.setData_type("object");
                this.buildSubModel(tApiDataName, tStandardApiDataName.getChildrens());
            } else if ("M".equals(tStandardApiDataName.getColumnType())) {
                tApiDataName.setData_type("object");
                tApiDataName.setField(new ArrayList<ApiDataName>());
            } else {
                tApiDataName.setData_type(tStandardApiDataName.getDataType());
            }
            tApiDataName.setRequired(tStandardApiDataName.getIsRequired());
            tApiDataName.setIs_datakey(tStandardApiDataName.getIsDatakey());
            tApiDataName.setIs_array(tStandardApiDataName.getIsArray());
            tApiDataName.setCanSort(tStandardApiDataName.getCanSort());
            tApiDataName.setCanFilter(tStandardApiDataName.getCanFilter());
            tApiDataName.setIs_business_key(tStandardApiDataName.getIsBusinesskey());
            tApiDataName.setDescription(new Description(tStandardApiDataName.getDescriptionZhTw(), tStandardApiDataName.getDescriptionZhCn(), tStandardApiDataName.getDescriptionEnUs()));
            tApiDataName.setListEnum(new ListEnum(tStandardApiDataName.getListEnumZhTw(), tStandardApiDataName.getListEnumZhCn(), tStandardApiDataName.getListEnumEn()));
            if (null != tStandardApiDataName.getRemarkZhTw()) {
                tApiDataName.setRemark(new Remark(tStandardApiDataName.getRemarkZhTw(), tStandardApiDataName.getRemarkZhCn(), tStandardApiDataName.getRemarkEnUs()));
            }
            ApiDataNameLength tApiDataNameLength = new ApiDataNameLength();
            for (ProductApiDataName tProductApiDataName : tStandardApiDataName.getProductApiDataNames()) {
                ApiDataNamePrecision tApiDataNamePrecision = new ApiDataNamePrecision();
                tApiDataNamePrecision.setProd_name(tProductApiDataName.getProductName());
                if ("string".equals(tStandardApiDataName.getDataType())) {
                    tApiDataNamePrecision.setPrecision(tProductApiDataName.getLength());
                } else if ("numeric".equals(tStandardApiDataName.getDataType())) {
                    tApiDataNamePrecision.setPrecision(tProductApiDataName.getLength(), tProductApiDataName.getPrecision());
                }
                tApiDataNameLength.getProd_type().add(tApiDataNamePrecision);
            }
            tApiDataName.setData_length(tApiDataNameLength);
            pApiDataName.getField().add(tApiDataName);
        }
    }

    private ApiDataName buildStdDataModel(ApiDataName pApiDataName_StdData, Long pApiVerId, MessageTypeEnum pStandardApiMessageType) {
        List<StandardApiDataName> tListOfHierarchyNodes_Parameter;
        List<StandardApiDataName> tListOfHierarchyNodes = StandardApiMessageUtil.generateListOfHierarchyNodes(DaoServiceUtil.getStandardApiDataNameDao().getByApiVerIdAndMsgType(pApiVerId, pStandardApiMessageType.getValue(), true), pApiVerId);
        List<StandardApiDataName> tListOfHierarchyNodes_Execution = StandardApiMessageUtil.filterHierarchyNodes(tListOfHierarchyNodes, "E");
        if (0 != tListOfHierarchyNodes_Execution.size()) {
            ApiDataName tApiDataName_Execution = new ApiDataName("execution", "object", Boolean.TRUE);
            this.buildSubModel(tApiDataName_Execution, tListOfHierarchyNodes_Execution);
            pApiDataName_StdData.getField().add(tApiDataName_Execution);
        }
        if (0 != (tListOfHierarchyNodes_Parameter = StandardApiMessageUtil.filterOutHierarchyNodesForParameter(tListOfHierarchyNodes)).size()) {
            ApiDataName tApiDataName_Parameter = new ApiDataName("parameter", "object", Boolean.TRUE);
            this.buildSubModel(tApiDataName_Parameter, tListOfHierarchyNodes_Parameter);
            pApiDataName_StdData.getField().add(tApiDataName_Parameter);
        }
        return pApiDataName_StdData;
    }

    private IRequest buildRequestModel(IRequest pRe, Long pApiVerId, MessageTypeEnum pStandardApiMessageType) {
        pRe.getHeader().add(new HeaderField("ContentType", new Description("application/json", "application/json", "application/json")));
        if (MessageTypeEnum.REQUEST.equals((Object)pStandardApiMessageType)) {
            pRe.getHeader().add(new HeaderField("digi-type", new Description("\u8abf\u7528\u6a21\u5f0f\uff1async(\u540c\u6b65)/async(\u7570\u6b65)/fasync(\u5168\u7570\u6b65)", "\u8c03\u7528\u6a21\u5f0f\uff1async(\u540c\u6b65)/async(\u5f02\u6b65)/fasync(\u5168\u5f02\u6b65)", "Integration Type\uff1async/async/fasync")));
            pRe.getHeader().add(new HeaderField("digi-host", new Description("\u767c\u8d77\u65b9\u8cc7\u8a0a\uff1a{\"prod\":\"Athena\",\"ver\":\"1.0\",\"ip\":\"\",\"id\":\"BpmCloud\",\"lang\":\"zh_CN\",\"acct\":\"DS\",\"timestamp\":\"20200605151102484\"}", "\u767c\u8d77\u65b9\u8d44\u8baf\uff1a{\"prod\":\"Athena\",\"ver\":\"1.0\",\"ip\":\"\",\"id\":\"BpmCloud\",\"lang\":\"zh_CN\",\"acct\":\"DS\",\"timestamp\":\"20200605151102484\"}", "host info\uff1a{\"prod\":\"Athena\",\"ver\":\"1.0\",\"ip\":\"\",\"id\":\"BpmCloud\",\"lang\":\"zh_CN\",\"acct\":\"DS\",\"timestamp\":\"20200605151102484\"}")));
            pRe.getHeader().add(new HeaderField("digi-service", new Description("\u670d\u52d9\u65b9\u8cc7\u8a0a\uff1a{\"tenant_id\":\"athenaTestW\",\"prod\":\"WFGP\",\"uid\":\"WF_335\",\"name\":\"purchase.order.creation.process\"}", "\u670d\u52a1\u65b9\u8cc7\u8a0a\uff1a{\"tenant_id\":\"athenaTestW\",\"prod\":\"WFGP\",\"uid\":\"WF_335\",\"name\":\"purchase.order.creation.process\"}", "service info\uff1a{\"tenant_id\":\"athenaTestW\",\"prod\":\"WFGP\",\"uid\":\"WF_335\",\"name\":\"purchase.order.creation.process\"}")));
            pRe.getHeader().add(new HeaderField("digi-key", new Description("\u5b89\u5168\u78bc\uff1aMD5 encode(digi-host + digi-service)", "\u5b89\u5168\u7801\uff1aMD5 encode(digi-host + digi-service)", "security key\uff1aMD5 encode(digi-host + digi-service)")));
        }
        List<StandardApiDataName> tListOfHierarchyNodes = StandardApiMessageUtil.generateListOfHierarchyNodes(DaoServiceUtil.getStandardApiDataNameDao().getByApiVerIdAndMsgType(pApiVerId, pStandardApiMessageType.getValue(), true), pApiVerId);
        List<StandardApiDataName> tListOfHierarchyNodes_H = StandardApiMessageUtil.filterHierarchyNodes(tListOfHierarchyNodes, "H");
        for (StandardApiDataName tStandardApiDataName : tListOfHierarchyNodes_H) {
            pRe.getHeader().add(new HeaderField(tStandardApiDataName.getStandardDataName(), new Description(tStandardApiDataName.getDescriptionZhTw(), tStandardApiDataName.getDescriptionZhCn(), tStandardApiDataName.getDescriptionEnUs())));
        }
        pRe.setBody(this.buildStdDataModel(new ApiDataName("std_data", "object", Boolean.TRUE), pApiVerId, pStandardApiMessageType));
        return pRe;
    }

    private AddApiVer CreateAddApiVer(StandardApi pStandardApi) {
        String tApiName = pStandardApi.getName();
        String tType = pStandardApi.getStandardApiSyncType().getNameEnUs();
        String tCategory = pStandardApi.getStandardApiCategory().getNameZhTw();
        String provider = pStandardApi.getProvider();
        String tParentApiName = pStandardApi.getParentApiName();
        Description tDescription = new Description(pStandardApi.getDescriptionZhTw(), pStandardApi.getDescriptionZhCn(), pStandardApi.getDescriptionEnUs());
        String tApiExtend = pStandardApi.getApiExtend();
        AddApiVer addApiVer = new AddApiVer(tApiName, tType, tCategory, provider, tDescription, tParentApiName, tApiExtend);
        addApiVer.setApiType(pStandardApi.getApiType());
        return addApiVer;
    }

    private ApiVerInfo CreateApiVerInfo(StandardApiVersion pStandardApiVersion) {
        ApiVerInfo tApiVerInfo = new ApiVerInfo();
        tApiVerInfo.setApi_version(pStandardApiVersion.getVersion());
        tApiVerInfo.setIdempotency(pStandardApiVersion.getIdempotency());
        tApiVerInfo.setApproved_status(String.valueOf(pStandardApiVersion.getApprovedStatus().getId()));
        return tApiVerInfo;
    }

    public ApiMetaData CreateApiMetaData(Long pApiVerId) {
        ApiMetaData tApiMetaData = new ApiMetaData();
        IRequest tRequest = this.buildRequestModel(new Request(), pApiVerId, MessageTypeEnum.REQUEST);
        IRequest tResponseSuccess = this.buildRequestModel(new ResponseSuccess(), pApiVerId, MessageTypeEnum.RESPONSE_SUCCESS);
        IRequest tResponseFailed = this.buildRequestModel(new ResponseFailed(), pApiVerId, MessageTypeEnum.RESPONSE_FAILED);
        tApiMetaData.setRequest((Request)tRequest);
        tApiMetaData.setResponse_success((ResponseSuccess)tResponseSuccess);
        tApiMetaData.setResponse_failed((ResponseFailed)tResponseFailed);
        return tApiMetaData;
    }

    private boolean IsApi(List<Product> pListPrd, StandardApi tStandardApi) {
        return CollUtil.emptyIfNull(pListPrd).stream().filter(tProduct -> Boolean.TRUE.equals(tProduct.getIsAgile())).anyMatch(tProduct -> tProduct.getName().equals(tStandardApi.getProvider()));
    }

    private void IsTenantId(StandardApi pStandardApi, AddApiVer pAddApiVer) {
        String tTenantId = pStandardApi.getTenantId();
        if (!StringUtils.isBlank((CharSequence)tTenantId)) {
            pAddApiVer.setTenant_id(tTenantId);
            String tPackageName = pStandardApi.getPackageName();
            if (!StringUtils.isBlank((CharSequence)tPackageName)) {
                pAddApiVer.setPackage_name(tPackageName);
            } else {
                pAddApiVer.setPackage_name("");
            }
        }
    }

    private AddApiVer buildModel(Long tApiVerId) {
        StandardApiVersion tStandardApiVersion = (StandardApiVersion)DaoServiceUtil.getStandardApiVersionDao().get(tApiVerId);
        StandardApi tStandardApi = tStandardApiVersion.getStandardApi();
        AddApiVer tAddApiVer = this.CreateAddApiVer(tStandardApi);
        List<Product> tListPrd = this.productDao.getAll();
        if (this.IsApi(tListPrd, tStandardApi)) {
            tAddApiVer.setApp_name(tStandardApi.getProvider());
        }
        this.IsTenantId(tStandardApi, tAddApiVer);
        if (null != tStandardApi.getRemarkZhTw()) {
            Remark tRemark = new Remark(tStandardApi.getRemarkZhTw(), tStandardApi.getRemarkZhCn(), tStandardApi.getRemarkEnUs());
            tAddApiVer.setRemark(tRemark);
        }
        ApiVerInfo tApiVerInfo = this.CreateApiVerInfo(tStandardApiVersion);
        ApiMetaData tApiMetaData = this.CreateApiMetaData(tApiVerId);
        tApiVerInfo.setData_metadata(tApiMetaData);
        tAddApiVer.getApi_version_info().add(tApiVerInfo);
        return tAddApiVer;
    }
}

