/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.apimgmt.services;

import cn.hutool.core.util.URLUtil;
import com.digiwin.athena.apimgmt.infra.context.ApiMgmtServiceContextHolder;
import com.digiwin.athena.apimgmt.infra.http.HttpRequest;
import com.digiwin.athena.apimgmt.infra.util.HttpUtil;
import com.digiwin.athena.apimgmt.infra.util.PropertyUtil;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;

public abstract class AbstractService {
    ObjectMapper mapper = new ObjectMapper();

    protected String localeTranslate(String content, String convertType) throws Exception {
        String tTranslateCenterUrl = PropertyUtil.getApiMgmtProp().getTranslateCenterUrl();
        HttpRequest tPost = HttpRequest.ofPost((String)URLUtil.completeUrl((String)tTranslateCenterUrl, (String)"/restful/service/translater/IDWTranslateService/translate"));
        ArrayNode convertTypesArrayNode = this.mapper.createArrayNode();
        convertTypesArrayNode.add(convertType);
        ObjectNode objectNode = this.mapper.createObjectNode();
        objectNode.put("content", content);
        objectNode.set("convertTypes", (JsonNode)convertTypesArrayNode);
        tPost.setEntity((Object)objectNode);
        tPost.addHeader("Content-Type", (Object)"application/json;charset=UTF-8");
        if (null != ApiMgmtServiceContextHolder.getRouterKey()) {
            tPost.setHeader("routerKey", (Object)ApiMgmtServiceContextHolder.getRouterKey());
        }
        String tResponse = (String)HttpUtil.execute((HttpRequest)tPost, String.class);
        JsonNode responseObject = this.mapper.readTree(tResponse);
        return responseObject.get("response").get("data").get(convertType).asText();
    }
}

