/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.apimgmt.apiservice;

import cn.hutool.extra.spring.SpringUtil;
import com.digiwin.athena.apimgmt.annotate.OperateAuthorityVerify;
import com.digiwin.athena.apimgmt.dao.ApiMgmtStateCodeDao;
import com.digiwin.athena.apimgmt.enums.ValidateStateEnum;
import com.digiwin.athena.apimgmt.exception.BaseException;
import com.digiwin.athena.apimgmt.infra.prop.ApiMgmtProp;
import com.digiwin.athena.apimgmt.model.StateCode;
import com.digiwin.athena.apimgmt.util.StringUtil;
import com.digiwin.athena.apimgmt.validator.JsonSchemaValidator;
import com.digiwin.athena.apimgmt.validator.ValidatorResult;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.lang.annotation.Annotation;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractApiService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractApiService.class);
    final JsonSchemaValidator jsonSchemaValidator = new JsonSchemaValidator();
    ObjectMapper mapper = new ObjectMapper();
    protected String jsonSchemaFileName;
    protected String requestMsg;
    @Autowired
    private ApiMgmtProp prop;
    @Autowired
    private ApiMgmtStateCodeDao stateCodeDao;

    public Map<String, Object> execute(String pRequestMsg) throws Exception {
        StateCode tStateCode;
        StringBuilder tDescription = new StringBuilder();
        this.requestMsg = pRequestMsg;
        try {
            log.info("[Thread.id " + Thread.currentThread().getId() + "]\u63a5\u53e3: " + this.getClass() + ", \u539f\u59cb\u8a0a\u606f: " + pRequestMsg);
            if (this.prop.isEnvType()) {
                for (Annotation annotation : this.getClass().getAnnotations()) {
                    if (!OperateAuthorityVerify.class.isAssignableFrom(annotation.annotationType())) continue;
                    throw new Exception("\u6b64\u64cd\u4f5c\u4e0d\u5bf9\u5916\u5f00\u653e,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458!");
                }
            }
            ValidatorResult tValidatorResult = this.validate(pRequestMsg);
            AbstractApiService thisProxy = (AbstractApiService)SpringUtil.getBean(this.getClass());
            return thisProxy.processData(tValidatorResult);
        }
        catch (BaseException e) {
            log.error(e.getMessage(), (Throwable)e);
            tStateCode = this.getStateCode(e.getStateEnum().getCode());
            tDescription.append(tStateCode.getDescription());
            if (!StringUtil.isEmptyOrSpace((Object)e.getMessage())) {
                tDescription.append(" ").append(e.getMessage());
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            tStateCode = this.getStateCode(ValidateStateEnum.UNEXPECTED_ERROR.getCode());
            tDescription.append(tStateCode.getDescription()).append(" ").append(e.getClass().toString()).append(":").append(e.getMessage());
        }
        return this.converJsonNodeToMap((JsonNode)this.createResponseJsonNode(tStateCode.getCode(), tDescription.toString()));
    }

    protected Map<String, Object> converJsonNodeToMap(JsonNode pJsonNode) {
        log.debug("[Thread.id " + Thread.currentThread().getId() + "]\u63a5\u53e3: " + this.getClass() + ", \u56de\u50b3\u8a0a\u606f: " + pJsonNode.toString());
        return (Map)this.mapper.convertValue((Object)pJsonNode, (TypeReference)new TypeReference<Map<String, Object>>(){});
    }

    protected StateCode getStateCode(String pStateCode) {
        return this.stateCodeDao.getStateCodeByCode(pStateCode);
    }

    protected ObjectNode createResponseJsonNode(String pCode, String pDescription, ObjectNode pResponseNode) {
        ObjectNode tResponseNode = pResponseNode == null ? this.mapper.createObjectNode() : pResponseNode;
        tResponseNode.put("code", pCode);
        if (!StringUtil.isEmptyOrSpace((Object)pDescription)) {
            tResponseNode.put("description", pDescription);
        }
        return tResponseNode;
    }

    protected abstract Map<String, Object> processData(ValidatorResult var1) throws BaseException, Exception;

    private ObjectNode createResponseJsonNode(String pCode, String pDescription) {
        return this.createResponseJsonNode(pCode, pDescription, null);
    }

    private ValidatorResult validate(String pMsg) throws BaseException, Exception {
        return this.jsonSchemaValidator.validate(pMsg, this.jsonSchemaFileName);
    }
}

