/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.apimgmt.dao.impl.mybatis;

import cn.hutool.core.collection.CollUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.digiwin.athena.apimgmt.dao.ApiMgmtProjectVersionDao;
import com.digiwin.athena.apimgmt.dao.ApiMgmtProjectVersionRelationDao;
import com.digiwin.athena.apimgmt.dao.impl.mybatis.GenericDaoMybatisImpl;
import com.digiwin.athena.apimgmt.dao.impl.mybatis.mapper.ApiMgmtProjectVersionRelationMapper;
import com.digiwin.athena.apimgmt.facade.dto.ApiMgmtApiProjectVerDTO;
import com.digiwin.athena.apimgmt.model.ProjectVersionRelation;
import com.digiwin.athena.apimgmt.model.StandardApi;
import com.digiwin.athena.apimgmt.model.StandardApiVersion;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Repository;

@Primary
@Repository
public class ApiMgmtProjectVersionRelationDaoMybatisImpl
extends GenericDaoMybatisImpl<ApiMgmtProjectVersionRelationMapper, ProjectVersionRelation, Long>
implements ApiMgmtProjectVersionRelationDao {
    private ApiMgmtProjectVersionDao projectVersionDao;

    @Override
    public List<ProjectVersionRelation> getByProjectId(Long projectId) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(ProjectVersionRelation::getProjectId, (Object)projectId);
        return ((ApiMgmtProjectVersionRelationMapper)this.baseMapper).selectList((Wrapper)wrapper);
    }

    @Override
    public List<ProjectVersionRelation> getByProjectVersionId(String projectVersionId) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(ProjectVersionRelation::getProjectVersionId, (Object)projectVersionId);
        return ((ApiMgmtProjectVersionRelationMapper)this.baseMapper).selectList((Wrapper)wrapper);
    }

    @Override
    public List<ProjectVersionRelation> getByApiId(Long apiId) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(ProjectVersionRelation::getApiId, (Object)apiId);
        return ((ApiMgmtProjectVersionRelationMapper)this.baseMapper).selectList((Wrapper)wrapper);
    }

    @Override
    public int deleteByApiId(Long apiId) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(ProjectVersionRelation::getApiId, (Object)apiId);
        return ((ApiMgmtProjectVersionRelationMapper)this.baseMapper).delete((Wrapper)wrapper);
    }

    @Override
    public Long countByProjectId(Long projectId) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(ProjectVersionRelation::getProjectId, (Object)projectId);
        return ((ApiMgmtProjectVersionRelationMapper)this.baseMapper).selectCount((Wrapper)wrapper);
    }

    @Override
    public Long countByProjectVersionId(List<Long> projectVersionIds) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.in(ProjectVersionRelation::getProjectVersionId, projectVersionIds);
        return ((ApiMgmtProjectVersionRelationMapper)this.baseMapper).selectCount((Wrapper)wrapper);
    }

    @Override
    public List<ProjectVersionRelation> selectByApiId(Long apiId) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(ProjectVersionRelation::getApiId, (Object)apiId);
        return ((ApiMgmtProjectVersionRelationMapper)this.baseMapper).selectList((Wrapper)wrapper);
    }

    @Override
    public void batchSave(List<ProjectVersionRelation> newProjectVersionList) {
        CollUtil.split(newProjectVersionList, (int)100).forEach(subList -> ((ApiMgmtProjectVersionRelationMapper)this.baseMapper).saveList((List<ProjectVersionRelation>)subList, ((ProjectVersionRelation)CollUtil.getFirst((Iterable)subList)).getRelationId() != null));
    }

    @Override
    public List<ProjectVersionRelation> selectByApiIds(List<Long> apiIds) {
        if (CollUtil.isEmpty(apiIds)) {
            return CollUtil.newArrayList((Object[])new ProjectVersionRelation[0]);
        }
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.in(ProjectVersionRelation::getApiId, (Collection)CollUtil.distinct(apiIds));
        return ((ApiMgmtProjectVersionRelationMapper)this.baseMapper).selectList((Wrapper)wrapper);
    }

    @Override
    public void fillRelationToVersion(List<StandardApiVersion> versions) {
        if (CollUtil.isEmpty(versions)) {
            return;
        }
        List<StandardApi> apiList = versions.stream().map(StandardApiVersion::getStandardApi).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        this.fillProjectVersionRelations(apiList);
    }

    @Override
    public void fillProjectVersionRelations(List<StandardApi> apiList) {
        if (CollUtil.isEmpty(apiList)) {
            return;
        }
        CollUtil.split(apiList, (int)500).forEach(subList -> {
            List<Long> apiIdList = subList.stream().map(StandardApi::getId).filter(Objects::nonNull).collect(Collectors.toList());
            List<ProjectVersionRelation> relations = this.selectByApiIds(apiIdList);
            Map<Long, List<ProjectVersionRelation>> relationMap = relations.stream().collect(Collectors.groupingBy(ProjectVersionRelation::getApiId));
            subList.forEach(api -> {
                List<ProjectVersionRelation> list = relationMap.getOrDefault(api.getId(), Collections.emptyList());
                list.forEach(v -> v.setStandardApi((StandardApi)api));
                api.setProjectVersionRelations(list);
            });
        });
    }

    @Override
    public Map<Long, List<ApiMgmtApiProjectVerDTO>> selectProjectVerMapByApi(List<Long> apiIds) {
        if (CollUtil.isEmpty(apiIds)) {
            return Collections.emptyMap();
        }
        List<ApiMgmtApiProjectVerDTO> pairList = ((ApiMgmtProjectVersionRelationMapper)this.baseMapper).selectProjectVersionNamesByApiIds(apiIds);
        Set<Long> hasVersionProjectId = this.projectVersionDao.selectExistProjectId(pairList.stream().map(ApiMgmtApiProjectVerDTO::getProjectId).distinct().collect(Collectors.toList()));
        pairList.forEach(v -> v.setProjectHasVersion(hasVersionProjectId.contains(v.getProjectId())));
        return pairList.stream().collect(Collectors.groupingBy(ApiMgmtApiProjectVerDTO::getApiId));
    }

    @Autowired
    public void setProjectVersionDao(ApiMgmtProjectVersionDao projectVersionDao) {
        this.projectVersionDao = projectVersionDao;
    }
}

