/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.apimgmt.schedule;

import cn.hutool.core.collection.CollUtil;
import com.digiwin.athena.apimgmt.dao.ApiMgmtSyncMdcFailDataDao;
import com.digiwin.athena.apimgmt.infra.prop.ApiMgmtProp;
import com.digiwin.athena.apimgmt.model.SyncMdcFailData;
import com.digiwin.athena.apimgmt.services.ApiMgmtSyncMdcServiceProcessor;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ApiMgmtSyncMdcFailDataTask {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ApiMgmtSyncMdcFailDataTask.class);
    private final ApiMgmtSyncMdcFailDataDao syncMdcFailDataDao;
    private final ApiMgmtSyncMdcServiceProcessor syncMdcServiceProcessor;
    private final ApiMgmtProp apiMgmtProp;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void syncMdcFailData() {
        long startTime = System.currentTimeMillis();
        try {
            log.info("\u5b9a\u65f6\u4efb\u52a1\u5f00\u542f: {}", (Object)Calendar.getInstance().getTime());
            List<SyncMdcFailData> list = this.syncMdcFailDataDao.getData();
            log.info("\u67e5\u8be2\u51fa\u7684\u6570\u636e\u91cf: {}", (Object)list.size());
            if (CollUtil.isNotEmpty(list)) {
                Map<String, List<SyncMdcFailData>> map = list.stream().collect(Collectors.groupingBy(SyncMdcFailData::getSyncFactory));
                for (String syncFactory : map.keySet()) {
                    this.syncMdcServiceProcessor.reqSyncMdcMetadataAddCompensate(map.get(syncFactory), syncFactory);
                }
            }
        }
        catch (Exception e) {
            log.error("\u8865\u507f\u4efb\u52a1\u6267\u884c\u5b8c\u6bd5\u8017\u65f6\uff1a{}", (Object)e.getMessage());
        }
        finally {
            log.info("\u8865\u507f\u4efb\u52a1\u6267\u884c\u5b8c\u6bd5\u8017\u65f6\uff1a{}", (Object)(System.currentTimeMillis() - startTime));
        }
    }

    @Generated
    public ApiMgmtSyncMdcFailDataTask(ApiMgmtSyncMdcFailDataDao syncMdcFailDataDao, ApiMgmtSyncMdcServiceProcessor syncMdcServiceProcessor, ApiMgmtProp apiMgmtProp) {
        this.syncMdcFailDataDao = syncMdcFailDataDao;
        this.syncMdcServiceProcessor = syncMdcServiceProcessor;
        this.apiMgmtProp = apiMgmtProp;
    }
}

