package com.digiwin.athena.apimgmt.apiservice;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.apimgmt.constants.ApimgmtConstant;
import com.digiwin.athena.apimgmt.dao.ApiMgmtStandardApiVersionDao;
import com.digiwin.athena.apimgmt.dao.ApiMgmtApiParamTextDao;
import com.digiwin.athena.apimgmt.dto.ApiParamTextReqDto;
import com.digiwin.athena.apimgmt.dto.ApiParamTextResDto;
import com.digiwin.athena.apimgmt.enums.*;
import com.digiwin.athena.apimgmt.infra.context.ApiMgmtServiceContextHolder;
import com.digiwin.athena.apimgmt.model.ApiParamText;
import com.digiwin.athena.apimgmt.model.StandardApiVersion;
import com.digiwin.athena.apimgmt.service.util.ApiVersionServiceUtil;
import com.digiwin.athena.apimgmt.service.util.StandardApiMessageServiceUtil;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

import java.io.IOException;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.UUID;

@Service
public class ApiParamTextService {

    @Autowired
    private ApiMgmtApiParamTextDao apiParamTextDao;
    @Autowired
    ApiMgmtStandardApiVersionDao standardApiVersionDao;
    ObjectMapper mapper = new ObjectMapper();

    @Transactional(rollbackFor = Exception.class)
    public ApiParamText save(ApiParamTextReqDto apiParamTextReqDto) throws Exception {
        String userId = ApiMgmtServiceContextHolder.getUserId();
        if (apiParamTextReqDto.getTextId()!=null){
            ApiParamText oldApiParamText = apiParamTextDao.get(apiParamTextReqDto.getTextId());
            Assert.notNull(oldApiParamText,"请求范本不存在");

            if (apiParamTextReqDto.getRequestText()!=null){
                oldApiParamText.setRequestText(JSONObject.toJSONString(apiParamTextReqDto.getRequestText()));
            }
            if (apiParamTextReqDto.getResponseText()!=null){
                oldApiParamText.setResponseText(JSONObject.toJSONString(apiParamTextReqDto.getResponseText()));
            }

            oldApiParamText.setEditTime(new Date());
            oldApiParamText.setEditBy(userId);
            return apiParamTextDao.save(oldApiParamText);
        }else{

            ApiParamText apiParamText = new ApiParamText();

            if (apiParamTextReqDto.getRequestText()!=null){
                apiParamText.setRequestText(JSONObject.toJSONString(apiParamTextReqDto.getRequestText()));
            }
            if (apiParamTextReqDto.getResponseText()!=null){
                apiParamText.setResponseText(JSONObject.toJSONString(apiParamTextReqDto.getResponseText()));
            }

            apiParamText.setCreatedBy(userId);
            apiParamText.setEditBy(userId);
            apiParamText.setCreatedTime(new Date());
            apiParamText.setEditTime(new Date());

            return apiParamTextDao.save(apiParamText);
        }

    }

    public ApiParamTextResDto getApiParamText(Long textId) {
        ApiParamText apiParamText = apiParamTextDao.get(textId);
        Assert.notNull(apiParamText,"请求范本不存在");
        return ApiParamTextResDto.create(apiParamText);
    }

    public String generateApiParamText(String body) throws IOException {
        // response
        JsonNode tRequestNode = mapper.readTree(body);
        // 取得語系
        String tLocale = ApiMgmtServiceContextHolder.getLocale();
        // header沒傳語系的話，默認回傳英文
        tLocale = tLocale == null ? LocaleEnum.EN_US.getType() : tLocale;
        // 取得入參
        String tApiName = tRequestNode.get(ApiAttributeEnum.apiName.toString()).asText();
        // branch
        String branch = ApimgmtConstant.DEFAULT_BRANCH;
        String tServiceProduct = tRequestNode.get(ApiAttributeEnum.serviceProduct.toString()).asText();
        String tHostProduct = tRequestNode.get(ApiAttributeEnum.hostProduct.toString()).asText();
        String tMsgFormat = tRequestNode.get(ApiAttributeEnum.msgFormat.toString()).asText();
        String tDevelopRole = tRequestNode.get(ApiAttributeEnum.developRole.toString()).asText();
        String tMessageType = tRequestNode.get(ApiAttributeEnum.messageType.toString()).asText();
        String tTenant = "";
        if (tRequestNode.get(ApiAttributeEnum.tenantId.toString()) != null) {
            tTenant = tRequestNode.get(ApiAttributeEnum.tenantId.toString()).asText();
        }
        String tVersion = null;
        if (tRequestNode.get(ApiAttributeEnum.apiVersion.toString()) != null) {
            tVersion = tRequestNode.get(ApiAttributeEnum.apiVersion.toString()).asText();
            // branch
            branch = ApiVersionServiceUtil.getBranchFromVersion(tVersion);
        }

        List<StandardApiVersion> tStandardApiVersionList = standardApiVersionDao.fetchApiVersionsByName(tApiName, branch, tTenant);
        StandardApiVersion tTargetApiVersion = null;
        for (StandardApiVersion tStandardApiVersion : tStandardApiVersionList) {
            // 取得對應版本號
            if (tStandardApiVersion.getVersion().equals(tVersion)) {
                tTargetApiVersion = tStandardApiVersion;
            }
        }
        String tCustomUUID = UUID.randomUUID().toString();
        Map<String, String> tMessageMap = StandardApiMessageServiceUtil.generateStandardApiMessage(tTargetApiVersion.getId(), tTargetApiVersion.getStandardApi(),
                MessageFormatEnum.valueOf(tMsgFormat).getMsgFormat(), tHostProduct, tServiceProduct,
                MessageTextSampleTypeEnum.valueOf(tMessageType).toString(), DeveloperRoleEnum.valueOf(tDevelopRole).toString(),
                tCustomUUID, tLocale);
        String tMessageGenerated = tMessageMap.get("MESSAGE_GENERATED");
        return tMessageGenerated;
    }
}
