/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.apimgmt.apiservice;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import com.digiwin.athena.apimgmt.ApiMgmtApplicationParameter;
import com.digiwin.athena.apimgmt.annotate.OperateAuthorityVerify;
import com.digiwin.athena.apimgmt.apiservice.AbstractApiService;
import com.digiwin.athena.apimgmt.dao.ApiMgmtApprovedStatusDao;
import com.digiwin.athena.apimgmt.dao.ApiMgmtStandardApiDao;
import com.digiwin.athena.apimgmt.dao.ApiMgmtStandardApiDataNameDao;
import com.digiwin.athena.apimgmt.dao.ApiMgmtStandardApiVersionDao;
import com.digiwin.athena.apimgmt.dao.ApiMgmtStandardDataNameDao;
import com.digiwin.athena.apimgmt.dao.ApiMgmtTenantConfigDao;
import com.digiwin.athena.apimgmt.enums.ApiAttributeEnum;
import com.digiwin.athena.apimgmt.enums.ApiVersionEnum;
import com.digiwin.athena.apimgmt.enums.MessageFormatEnum;
import com.digiwin.athena.apimgmt.enums.ValidateStateEnum;
import com.digiwin.athena.apimgmt.exception.BaseException;
import com.digiwin.athena.apimgmt.infra.context.ApiMgmtServiceContextHolder;
import com.digiwin.athena.apimgmt.infra.prop.ApiMgmtMdcProp;
import com.digiwin.athena.apimgmt.model.ApprovedStatus;
import com.digiwin.athena.apimgmt.model.StandardApi;
import com.digiwin.athena.apimgmt.model.StandardApiDataName;
import com.digiwin.athena.apimgmt.model.StandardApiVersion;
import com.digiwin.athena.apimgmt.model.StandardDataName;
import com.digiwin.athena.apimgmt.model.StateCode;
import com.digiwin.athena.apimgmt.service.util.ApiDataNameServiceUtil;
import com.digiwin.athena.apimgmt.service.util.ApiVersionServiceUtil;
import com.digiwin.athena.apimgmt.service.util.DevelopmentPlatformServiceUtil;
import com.digiwin.athena.apimgmt.service.util.DmcFileServiceUtil;
import com.digiwin.athena.apimgmt.service.util.StandardApiExportServiceUtil;
import com.digiwin.athena.apimgmt.service.util.StandardApiFileReadServiceUtil;
import com.digiwin.athena.apimgmt.services.ApiMgmtApiSaveAndReviewVerifyProcessor;
import com.digiwin.athena.apimgmt.services.ApiMgmtSyncMdcServiceProcessor;
import com.digiwin.athena.apimgmt.validator.ValidatorResult;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import lombok.Generated;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Sheet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@OperateAuthorityVerify
public class ApiReviewUpdateService
extends AbstractApiService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ApiReviewUpdateService.class);
    private static final Lock LOCK = new ReentrantLock(true);
    @Autowired
    ApiMgmtStandardApiDao standardApiDao;
    @Autowired
    ApiMgmtStandardApiVersionDao standardApiVersionDao;
    @Autowired
    ApiMgmtStandardApiDataNameDao standardApiDataNameDao;
    @Autowired
    ApiMgmtApprovedStatusDao approvedStatusDao;
    @Autowired
    ApiMgmtTenantConfigDao tenantConfigDao;
    @Autowired
    ApiMgmtStandardDataNameDao standardDataNameDao;
    @Autowired
    private ApiMgmtSyncMdcServiceProcessor syncMdcServiceProcessor;
    @Autowired
    private ApiMgmtApiSaveAndReviewVerifyProcessor apiSaveAndReviewVerifyProcessor;
    @Autowired
    private ApiMgmtMdcProp mdcProp;

    public ApiReviewUpdateService() {
        this.jsonSchemaFileName = "api_review_schema.json";
    }

    @Override
    protected Map<String, Object> processData(ValidatorResult validatorResult) throws BaseException, Exception {
        HashMap<String, Object> tResponse = new HashMap<String, Object>();
        StateCode tStateCode = this.getStateCode(ValidateStateEnum.SUCCESS.getCode());
        String tDescription = tStateCode.getDescription();
        ArrayList<Long> tListApiVerIdNeedToSyncMetadata = new ArrayList<Long>();
        String routerKey = ApiMgmtServiceContextHolder.getRouterKey();
        String tTenantId = ApiMgmtServiceContextHolder.getTenantId();
        String tUserId = ApiMgmtServiceContextHolder.getUserId();
        boolean tSkipReview = this.tenantConfigDao.getSkipReviewDataNameTenant(tTenantId);
        boolean tTanantIsSkipReview = this.tenantConfigDao.getSkipReviewTenant(tTenantId);
        boolean tApiSpecErrorExist = false;
        HashMap<String, List<Map<String, String>>> tTotalApiErrorMap = new HashMap<String, List<Map<String, String>>>();
        JsonNode tRequestJsonNode = validatorResult.getJsonContent();
        ArrayNode tApiArrayNode = (ArrayNode)tRequestJsonNode.get("apiList");
        for (JsonNode tApiNode : tApiArrayNode) {
            HashMap<String, String> tReqErrorLog;
            String tApiName = tApiNode.get(ApiAttributeEnum.apiName.toString()).asText();
            String tVersion = tApiNode.get(ApiAttributeEnum.version.toString()).asText();
            HashMap<String, String> tConditionMap = new HashMap<String, String>();
            tConditionMap.put(ApiAttributeEnum.apiName.toString(), tApiName);
            tConditionMap.put(ApiAttributeEnum.version.toString(), tVersion);
            if (tApiNode.get(ApiAttributeEnum.tenantId.toString()) != null) {
                tConditionMap.put(ApiAttributeEnum.tenantId.toString(), tApiNode.get(ApiAttributeEnum.tenantId.toString()).asText());
            }
            StandardApiVersion tStandardApiVersion = this.standardApiVersionDao.fetchApiVersion(tConditionMap);
            StandardApi tStandardApi = tStandardApiVersion.getStandardApi();
            List<StandardApiDataName> tStandardApiDataNames = this.standardApiDataNameDao.getByApiVerId(tStandardApiVersion.getId(), true);
            Map<String, StandardApiDataName> tAddDataName = this.convertToMap(tStandardApiDataNames);
            String tPreviousVersion = ApiVersionServiceUtil.getPreviousVersion(tVersion);
            HashMap<String, String> tVersionCondition = new HashMap<String, String>();
            tVersionCondition.put(ApiVersionEnum.API_NAME.toString(), tApiName);
            tVersionCondition.put(ApiVersionEnum.API_VERSION.toString(), tPreviousVersion);
            if (tApiNode.get(ApiAttributeEnum.tenantId.toString()) != null) {
                tVersionCondition.put(ApiVersionEnum.TENANT_ID_FULL_MATCHING.toString(), tApiNode.get(ApiAttributeEnum.tenantId.toString()).asText());
            }
            List<StandardApiVersion> tPreviStandardApiVersionList = this.standardApiVersionDao.fetch(tVersionCondition);
            ArrayList<Map<String, String>> tApiDataNameCheckResult = new ArrayList<Map<String, String>>();
            this.apiSaveAndReviewVerifyProcessor.checkListEnum(tApiDataNameCheckResult, tAddDataName);
            if ((tStandardApi.getRequester().equalsIgnoreCase("Athena") || tStandardApi.getProvider().equalsIgnoreCase("Athena")) && !tStandardApi.getMsgFormat().equals(MessageFormatEnum.JSON.getMsgFormat())) {
                tReqErrorLog = new HashMap<String, String>();
                tReqErrorLog.put("description", "\u767c\u8d77\u65b9\u3001\u63a5\u6536\u65b9\u7522\u54c1\u5305\u542b\u300cAthena\u300d\uff0c\u5247\u4fe1\u606f\u683c\u5f0f\u5fc5\u9808\u70ba\u300cJSON\u300d");
                tApiDataNameCheckResult.add(tReqErrorLog);
            }
            this.apiSaveAndReviewVerifyProcessor.checkRequiredDataName(tApiDataNameCheckResult, tAddDataName);
            if (tStandardApi.getStandardApiPaging().getId() == 2L || tStandardApi.getStandardApiPaging().getId() == 3L) {
                this.apiSaveAndReviewVerifyProcessor.checkPagingRequiredDataName(tApiDataNameCheckResult, tAddDataName);
            }
            this.apiSaveAndReviewVerifyProcessor.checkIsArrayCannotBeY(tApiDataNameCheckResult, tAddDataName);
            this.apiSaveAndReviewVerifyProcessor.checkDataKey(tApiDataNameCheckResult, tAddDataName);
            if (!tPreviStandardApiVersionList.isEmpty()) {
                List<StandardApiDataName> tPreviApiDataName = this.standardApiDataNameDao.getByApiVerId(tPreviStandardApiVersionList.get(0).getId(), true);
                this.apiSaveAndReviewVerifyProcessor.compareDataName(tApiDataNameCheckResult, tPreviApiDataName, tAddDataName);
            }
            if (tStandardApi.getStandardApiSyncType().getId() == 2L && !tStandardApi.getMsgFormat().equals(MessageFormatEnum.JSON.getMsgFormat())) {
                tReqErrorLog = new HashMap();
                tReqErrorLog.put("description", "\u8abf\u7528\u6a21\u5f0f\u70ba\u300c\u5168\u7570\u6b65\u300d\uff0c\u5247\u4fe1\u606f\u683c\u5f0f\u5fc5\u9808\u70ba\u300cJSON\u300d");
                tApiDataNameCheckResult.add(tReqErrorLog);
            }
            if (!tApiDataNameCheckResult.isEmpty()) {
                String tApiError = tApiName + "/" + tVersion;
                tTotalApiErrorMap.put(tApiError, tApiDataNameCheckResult);
                tApiSpecErrorExist = true;
                continue;
            }
            this.checkNewDataName(tStandardApiDataNames, tUserId, tSkipReview);
            ApprovedStatus tApprovedStatus = tTanantIsSkipReview ? (ApprovedStatus)this.approvedStatusDao.get(3L) : (ApprovedStatus)this.approvedStatusDao.get(2L);
            tStandardApiVersion.setApprovedStatus(tApprovedStatus);
            tStandardApiVersion.setApprovedTime(LocalDateTime.now());
            this.standardApiVersionDao.saveOrupdate(tStandardApiVersion);
            Long tApiVerId = tStandardApiVersion.getId();
            if (tVersion.startsWith("1.")) {
                tListApiVerIdNeedToSyncMetadata.add(tApiVerId);
            }
            if (!StrUtil.isNotEmpty((CharSequence)ApiMgmtApplicationParameter.SYNC_DEV_URL) || !tVersion.startsWith("1.")) continue;
            DevelopmentPlatformServiceUtil.sendApiToDevelopmentPlatform(tStandardApiVersion);
        }
        if (tTanantIsSkipReview && !tListApiVerIdNeedToSyncMetadata.isEmpty() && CollUtil.isNotEmpty((Collection)this.mdcProp.getReviewUrlList())) {
            String tToken = ApiMgmtServiceContextHolder.getToken();
            for (String url : this.mdcProp.getReviewUrlList()) {
                this.syncMdcServiceProcessor.runSyncMdcMetadata(tListApiVerIdNeedToSyncMetadata, url, tUserId, tToken, routerKey);
            }
        }
        if (tApiSpecErrorExist) {
            return this.result(tStateCode, tDescription, tTotalApiErrorMap);
        }
        tDescription = tStateCode.getDescription();
        tResponse.put("code", tStateCode.getCode());
        tResponse.put("description", tDescription);
        return tResponse;
    }

    private Map<String, Object> result(StateCode tStateCode, String tDescription, Map<String, List<Map<String, String>>> pTotalApiErrorMap) throws Exception {
        ObjectNode tResponseNode = this.mapper.createObjectNode();
        ObjectNode tResponseJsonNode = this.createResponseJsonNode(tStateCode.getCode(), tDescription, tResponseNode);
        tStateCode = this.getStateCode(ValidateStateEnum.IMPORT_SPEC_FORMAT_ERROR.getCode());
        tDescription = tStateCode.getDescription();
        HSSFWorkbook tHSSFWorkbook = StandardApiExportServiceUtil.getTemplateFile(false);
        HSSFSheet tErrorSheet = tHSSFWorkbook.createSheet("\u932f\u8aa4\u660e\u7d30");
        StandardApiFileReadServiceUtil.writeImportErrorFile((Sheet)tErrorSheet, pTotalApiErrorMap);
        String tFileName = ApiMgmtApplicationParameter._TEMPLATE_FILE_NAME;
        String tFileExportPath = ApiMgmtApplicationParameter._FILE_EXPORT_PATH + "/" + tFileName;
        FileOutputStream fileOut = new FileOutputStream(tFileExportPath);
        tHSSFWorkbook.write((OutputStream)fileOut);
        fileOut.close();
        int pFailedNum = pTotalApiErrorMap.keySet().size();
        DmcFileServiceUtil.uploadFileAndGenerateDownloadLink(tResponseNode, tFileExportPath, tFileName, true, pFailedNum);
        tResponseNode.put("code", tStateCode.getCode());
        tResponseNode.put("description", tDescription);
        return this.converJsonNodeToMap((JsonNode)tResponseJsonNode);
    }

    private Map<String, StandardApiDataName> convertToMap(List<StandardApiDataName> pStandardApiDataNameList) {
        HashMap<String, StandardApiDataName> tDataNameMap = new HashMap<String, StandardApiDataName>();
        for (StandardApiDataName tStandardApiDataName : pStandardApiDataNameList) {
            String tColumnType = tStandardApiDataName.getColumnType();
            String tDataName = tStandardApiDataName.getStandardDataName();
            String tDataType = tStandardApiDataName.getMsgType().toString();
            StandardApiDataName tParent = tStandardApiDataName.getParent();
            String tParentDataName = tParent == null ? "" : tParent.getStandardDataName();
            tDataNameMap.put(tColumnType + tDataName + tDataType + tParentDataName, tStandardApiDataName);
        }
        return tDataNameMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkNewDataName(List<StandardApiDataName> pStandardApiDataNames, String pUserId, boolean pSkipReview) {
        List<String> tDataNameAllList = null;
        LOCK.lock();
        try {
            if (!pSkipReview) {
                tDataNameAllList = ApiDataNameServiceUtil.getApiDataNameList();
                Long tDataNameCount = this.standardDataNameDao.getDataNameCount();
                if ((long)tDataNameAllList.size() != tDataNameCount) {
                    tDataNameAllList = this.standardDataNameDao.getAllDataName();
                    ApiDataNameServiceUtil.setApiDataNameList(tDataNameAllList);
                }
            }
        }
        finally {
            LOCK.unlock();
        }
        if (!pSkipReview) {
            for (StandardApiDataName tStandardApiDataName : pStandardApiDataNames) {
                String tDataName = tStandardApiDataName.getStandardDataName();
                String tFlag = tDataNameAllList.stream().filter(dataName -> dataName.contains(tDataName)).findAny().orElse(null);
                if (tFlag != null) continue;
                this.addDataName(tDataName, tStandardApiDataName.getDescriptionZhTw(), tStandardApiDataName.getDescriptionZhCn(), tStandardApiDataName.getDescriptionEnUs(), pUserId, pUserId, LocalDateTime.now());
            }
        }
    }

    private void addDataName(String pDataName, String pDescriptionZhTW, String pDescriptionZhCN, String pDescriptionEnUs, String tBuildAcct, String pLoginAcct, LocalDateTime pBuildTime) {
        StandardDataName tStandardDataName = new StandardDataName();
        tStandardDataName.setDataName(pDataName);
        tStandardDataName.setDescriptionZhTw(pDescriptionZhTW);
        tStandardDataName.setDescriptionZhCn(pDescriptionZhCN);
        tStandardDataName.setDescriptionEnUs(pDescriptionEnUs);
        tStandardDataName.setApprovedStatus(1L);
        tStandardDataName.setApprovedAcct(pLoginAcct);
        tStandardDataName.setApprovedTime(LocalDateTime.now());
        tStandardDataName.setBuildTime(pBuildTime);
        tStandardDataName.setBuildAcct(tBuildAcct);
        tStandardDataName.setLastUpdateTime(LocalDateTime.now());
        tStandardDataName.setDirty(false);
        this.standardDataNameDao.saveOrupdate(tStandardDataName);
    }
}

