/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.apimgmt.apiservice;

import com.digiwin.athena.apimgmt.dao.impl.mybatis.mapper.ApiMgmtApprovedStatusMapper;
import com.digiwin.athena.apimgmt.dao.impl.mybatis.mapper.ApiMgmtStandardApiCategoryMapper;
import com.digiwin.athena.apimgmt.dao.impl.mybatis.mapper.ApiMgmtStandardApiMapper;
import com.digiwin.athena.apimgmt.dao.impl.mybatis.mapper.ApiMgmtStandardApiSyncTypeMapper;
import com.digiwin.athena.apimgmt.dao.impl.mybatis.mapper.ApiMgmtStandardApiVersionMapper;
import com.digiwin.athena.apimgmt.dto.ApiInfoResDto;
import com.digiwin.athena.apimgmt.dto.PageReqCondition;
import com.digiwin.athena.apimgmt.dto.PaginationResDto;
import com.digiwin.athena.apimgmt.model.ApprovedStatus;
import com.digiwin.athena.apimgmt.model.StandardApi;
import com.digiwin.athena.apimgmt.model.StandardApiCategory;
import com.digiwin.athena.apimgmt.model.StandardApiSyncType;
import com.digiwin.athena.apimgmt.model.StandardApiVersion;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ApiMgmtServiceV2 {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ApiMgmtServiceV2.class);
    @Autowired
    private ApiMgmtStandardApiVersionMapper apiMgmtStandardApiVersionMapper;
    @Autowired
    private ApiMgmtApprovedStatusMapper apiMgmtApprovedStatusMapper;
    @Autowired
    private ApiMgmtStandardApiCategoryMapper apiMgmtStandardApiCategoryMapper;
    @Autowired
    private ApiMgmtStandardApiMapper apiMgmtStandardApiMapper;
    @Autowired
    private ApiMgmtStandardApiSyncTypeMapper apiMgmtStandardApiSyncTypeMapper;

    public PaginationResDto searchApi(PageReqCondition<String> pagination) {
        PageHelper.startPage((int)pagination.getPageNum(), (int)pagination.getPageSize());
        List<StandardApiVersion> standardApiVersionList = this.apiMgmtStandardApiVersionMapper.searchApi((String)pagination.getCondition());
        List<Object> res = new ArrayList();
        if (!standardApiVersionList.isEmpty()) {
            List apiIds = standardApiVersionList.stream().map(StandardApiVersion::getApiId).collect(Collectors.toList());
            List approvedStatuses = this.apiMgmtApprovedStatusMapper.selectList(null);
            List standardApiCategories = this.apiMgmtStandardApiCategoryMapper.selectList(null);
            List standardApiSyncTypes = this.apiMgmtStandardApiSyncTypeMapper.selectList(null);
            List standardApis = this.apiMgmtStandardApiMapper.selectBatchIds(apiIds);
            Map<Long, ApprovedStatus> approvedStatuseMap = approvedStatuses.stream().collect(Collectors.toMap(ApprovedStatus::getId, s -> s));
            Map<Long, StandardApi> standardApiMap = standardApis.stream().collect(Collectors.toMap(StandardApi::getId, s -> s));
            Map<Long, StandardApiCategory> standardApiCategoriesMap = standardApiCategories.stream().collect(Collectors.toMap(StandardApiCategory::getId, s -> s));
            Map<Long, StandardApiSyncType> standardApiSyncTypeMap = standardApiSyncTypes.stream().collect(Collectors.toMap(StandardApiSyncType::getId, s -> s));
            res = standardApiVersionList.stream().map(s -> {
                ApprovedStatus approvedStatus = (ApprovedStatus)approvedStatuseMap.get(s.getApprovedStatusCode());
                StandardApi standardApi = (StandardApi)standardApiMap.get((long)s.getApiId());
                StandardApiCategory standardApiCategory = (StandardApiCategory)standardApiCategoriesMap.get((long)standardApi.getCategory());
                StandardApiSyncType standardApiSyncType = (StandardApiSyncType)standardApiSyncTypeMap.get(standardApi.getSyncType());
                ApiInfoResDto apiInfoResDto = ApiInfoResDto.create(s, standardApi, approvedStatus, standardApiCategory, standardApiSyncType);
                return apiInfoResDto;
            }).collect(Collectors.toList());
        }
        PageInfo pageInfo = new PageInfo(res);
        PaginationResDto paginationResDto = new PaginationResDto();
        paginationResDto.setValue((Object)pageInfo.getList());
        paginationResDto.setPageTotal(Integer.valueOf(pageInfo.getPages()));
        paginationResDto.setPageSize(Integer.valueOf(pageInfo.getPageSize()));
        paginationResDto.setPageNum(Integer.valueOf(pageInfo.getPageNum()));
        return paginationResDto;
    }
}

