package com.digiwin.athena.apimgmt.apiservice;

import cn.hutool.core.date.DateUtil;
import com.digiwin.athena.apimgmt.constants.ApimgmtConstant;
import com.digiwin.athena.apimgmt.dao.ApiMgmtStandardApiDao;
import com.digiwin.athena.apimgmt.dao.ApiMgmtStandardApiVersionDao;
import com.digiwin.athena.apimgmt.enums.ApiAttributeEnum;
import com.digiwin.athena.apimgmt.enums.LocaleEnum;
import com.digiwin.athena.apimgmt.infra.context.ApiMgmtServiceContextHolder;
import com.digiwin.athena.apimgmt.model.StandardApi;
import com.digiwin.athena.apimgmt.model.StandardApiVersion;
import com.digiwin.athena.apimgmt.util.StringUtil;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.github.fge.jackson.JsonLoader;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * API設計進階查詢
 * /restful/standard/apimgmt/ApiDesignAdvanceSearchList/Get
 */
@Slf4j
@Service
@Deprecated
public class ApiDesignAdvanceSearchListGetService {


    @Autowired
    ApiMgmtStandardApiDao standardApiDao;

    @Autowired
    ApiMgmtStandardApiVersionDao standardApiVersionDao;

    public ApiDesignAdvanceSearchListGetService() {
        super();
    }

    public ArrayList<Map<String, Object>> execute(String validatorResult) throws Exception {
        log.info("[Thread.id " + Thread.currentThread().getId() + "]" + "接口：" + this.getClass()
                + "，原始訊息：" + validatorResult);
        // 取得語系
        String tLocale = ApiMgmtServiceContextHolder.getLocale();
        // header沒傳語系的話，默認回傳英文
        tLocale = tLocale == null ? LocaleEnum.EN_US.getType() : tLocale;
        // 取得用戶資訊
        String teamType = ApiMgmtServiceContextHolder.getTeamType();
        String tTenant = ApiMgmtServiceContextHolder.getTenantId();
        String tUserId = ApiMgmtServiceContextHolder.getUserId();
        ArrayList<Map<String, Object>> tResponse = new ArrayList<>();
        JsonNode tRequestJsonNode = JsonLoader.fromString(validatorResult);
        ArrayNode tConditionArrayNode = (ArrayNode) tRequestJsonNode.get(ApimgmtConstant.CONDITION_LIST);
        boolean tIsVerifyAcct = false;
        if (!StringUtil.isEmptyOrSpace(tRequestJsonNode.get(ApimgmtConstant.VERIFY_ACCT).asText())) {
            tIsVerifyAcct = true;
        }
        ArrayList<Map<String, String>> tConditionList = new ArrayList<>();
        String tProvider = null;
        String tStatus = null;
        // 登入用戶所屬租戶
        Map<String, String> tTenantIdCondition = new HashMap<>();
        tTenantIdCondition.put(ApimgmtConstant.TENANT, tTenant);
        tConditionList.add(tTenantIdCondition);
        Map<String, String> tUserIdCondition = new HashMap<>();
        if (tIsVerifyAcct) {
            // 是審核者的話，顯示全部待審核的API
            tUserId = null;
        } else {
            // 不是審核者的話，只顯示該用戶導入的API
            tUserIdCondition.put(ApimgmtConstant.USER_ID, tUserId);
            tConditionList.add(tUserIdCondition);
        }
        if (tConditionArrayNode.isArray()) {
            for (JsonNode tConditionNode : tConditionArrayNode) {
                Map<String, String> tConditionMap = new HashMap<>();
                String tCondition = tConditionNode.get(ApimgmtConstant.CONDITION).asText();
                // 取得字段內容放入tConditionMap
                switch (tCondition) {
                    case ApimgmtConstant.API_NAME:
                        tConditionMap.put(ApimgmtConstant.API_NAME, tConditionNode.get(ApimgmtConstant.CONTENT).asText());
                        tConditionMap.put(ApimgmtConstant.API_NAME_EQ, tConditionNode.get(ApimgmtConstant.EQUATION).asText());
                        break;
                    case ApimgmtConstant.API_TAG:
                        tConditionMap.put(ApimgmtConstant.API_TAG, tConditionNode.get(ApimgmtConstant.CONTENT).asText());
                        tConditionMap.put(ApimgmtConstant.API_TAG_EQ, tConditionNode.get(ApimgmtConstant.EQUATION).asText());
                        break;
                    case ApimgmtConstant.API_DATANAME:
                        tConditionMap.put(ApimgmtConstant.API_DATANAME, tConditionNode.get(ApimgmtConstant.CONTENT).asText());
                        tConditionMap.put(ApimgmtConstant.API_DATANAME_EQ, tConditionNode.get(ApimgmtConstant.EQUATION).asText());
                        break;
                    case ApimgmtConstant.API_DESC:
                        tConditionMap.put(ApimgmtConstant.API_DESC, tConditionNode.get(ApimgmtConstant.CONTENT).asText());
                        tConditionMap.put(ApimgmtConstant.API_DESC_EQ, tConditionNode.get(ApimgmtConstant.EQUATION).asText());
                        break;
                    case ApimgmtConstant.API_REMARK:
                        tConditionMap.put(ApimgmtConstant.API_REMARK, tConditionNode.get(ApimgmtConstant.CONTENT).asText());
                        tConditionMap.put(ApimgmtConstant.API_REMARK_EQ, tConditionNode.get(ApimgmtConstant.EQUATION).asText());
                        break;
                    case ApimgmtConstant.API_SYNC_TYPE:
                        tConditionMap.put(ApimgmtConstant.API_SYNC_TYPE, tConditionNode.get(ApimgmtConstant.CONTENT).asText());
                        break;
                    case ApimgmtConstant.API_CATEGORY:
                        tConditionMap.put(ApimgmtConstant.API_CATEGORY, tConditionNode.get(ApimgmtConstant.CONTENT).asText());
                        break;
                    case ApimgmtConstant.PROVIDER:
                        tProvider = tConditionNode.get(ApimgmtConstant.CONTENT).asText();
                        tConditionMap.put(ApimgmtConstant.PROVIDER, tConditionNode.get(ApimgmtConstant.CONTENT).asText());
                        break;
                    case ApimgmtConstant.API_STATUS:
                        tStatus = tConditionNode.get(ApimgmtConstant.CONTENT).asText();
                        tConditionMap.put(ApimgmtConstant.API_STATUS, tConditionNode.get(ApimgmtConstant.CONTENT).asText());
                        break;
                    case ApimgmtConstant.TENANT_ID:
                        tConditionMap.put(ApimgmtConstant.TENANT_ID, tConditionNode.get(ApimgmtConstant.CONTENT).asText());
                        tConditionMap.put(ApimgmtConstant.TENANT_ID_EQ, tConditionNode.get(ApimgmtConstant.EQUATION).asText());
                        break;
                    default:
                        log.info("输入条件不成立!");
                        break;
                }
                tConditionList.add(tConditionMap);
            }
        }
        List<StandardApi> tStandardApiList = standardApiDao.advanceSearch(tConditionList, teamType, true, false);
        if (tStandardApiList != null) {
            for (StandardApi tStandardApi : tStandardApiList) {
                // 檢查接收方產品名稱是否完全符合
                boolean tProviderBoolean = false;
                if (tProvider != null) {
                    String tProviders = tStandardApi.getProvider().trim();
                    String[] tProviderArr = tProviders.split(",");
                    for (String s : tProviderArr) {
                        if (s.trim().equals(tProvider)) {
                            tProviderBoolean = true;
                            break;
                        }
                    }
                } else {
                    tProviderBoolean = true;
                }
                if (tProviderBoolean) {
                    List<StandardApiVersion> tStandardApiVersions = standardApiVersionDao.getVersionByApiId(tStandardApi.getId(), tUserId, tStatus);
                    for (StandardApiVersion tStandardApiVersion : tStandardApiVersions) {
                        Map<String, Object> tApiMap = new HashMap<>();
                        String tApprovedStatus;
                        long tApprovedStatusCode;
                        String tDescription;
                        String tRemark;
                        String tSyncType;
                        String tCategory;
                        switch (tLocale) {
                            case ApimgmtConstant.ZH_CN:
                                tApprovedStatus = tStandardApiVersion.getApprovedStatus().getNameZhCn();
                                tApprovedStatusCode = tStandardApiVersion.getApprovedStatus().getId();
                                tDescription = tStandardApi.getDescriptionZhCn();
                                tRemark = tStandardApi.getRemarkZhCn();
                                tSyncType = tStandardApi.getStandardApiSyncType().getNameZhCn();
                                tCategory = tStandardApi.getStandardApiCategory().getNameZhCn();
                                break;
                            case ApimgmtConstant.ZH_TW:
                                tApprovedStatus = tStandardApiVersion.getApprovedStatus().getNameZhTw();
                                tApprovedStatusCode = tStandardApiVersion.getApprovedStatus().getId();
                                tDescription = tStandardApi.getDescriptionZhTw();
                                tRemark = tStandardApi.getRemarkZhTw();
                                tSyncType = tStandardApi.getStandardApiSyncType().getNameZhTw();
                                tCategory = tStandardApi.getStandardApiCategory().getNameZhTw();
                                break;
                            case ApimgmtConstant.EN_US:
                            default:
                                tApprovedStatus = tStandardApiVersion.getApprovedStatus().getNameEnUs();
                                tApprovedStatusCode = tStandardApiVersion.getApprovedStatus().getId();
                                tDescription = tStandardApi.getDescriptionEnUs();
                                tRemark = tStandardApi.getRemarkEnUs();
                                tSyncType = tStandardApi.getStandardApiSyncType().getNameEnUs();
                                tCategory = tStandardApi.getStandardApiCategory().getNameEnUs();
                                break;
                        }
                        // 組成回傳訊息
                        tApiMap.put(ApimgmtConstant.NAME, tStandardApi.getName());
                        tApiMap.put(ApimgmtConstant.VERSION, tStandardApiVersion.getVersion());
                        tApiMap.put(ApimgmtConstant.APPROVED_STATUS, tApprovedStatus);
                        tApiMap.put(ApimgmtConstant.APPROVED_STATUS_CODE, tApprovedStatusCode);
                        tApiMap.put(ApiAttributeEnum.approvedTime.toString(), DateUtil.formatLocalDateTime(tStandardApiVersion.getApprovedTime()));
                        tApiMap.put(ApimgmtConstant.DESCRIPTION, tDescription);
                        tApiMap.put(ApimgmtConstant.REMARK, tRemark);
                        tApiMap.put(ApimgmtConstant.SYNC_TYPE, tSyncType);
                        tApiMap.put(ApimgmtConstant.CATEGORY_ID, tStandardApi.getStandardApiCategory().getId());
                        tApiMap.put(ApimgmtConstant.CATEGORY_NAME, tCategory);
                        tApiMap.put(ApimgmtConstant.MSG_FORMAT, tStandardApi.getMsgFormat());
                        tApiMap.put(ApimgmtConstant.PROVIDER, tStandardApi.getProvider());
                        tApiMap.put(ApimgmtConstant.TENANT_ID, tStandardApi.getTenantId());
                        tApiMap.put(ApimgmtConstant.STATUS_ID, tStandardApiVersion.getApprovedStatus().getId());
                        tResponse.add(tApiMap);
                    }
                }
            }
        }
        return tResponse;
    }
}
