package com.digiwin.athena.apimgmt.dto;

import cn.hutool.core.date.DateUtil;
import com.digiwin.athena.apimgmt.constants.ApimgmtConstant;
import com.digiwin.athena.apimgmt.infra.context.ApiMgmtServiceContextHolder;
import com.digiwin.athena.apimgmt.model.ApprovedStatus;
import com.digiwin.athena.apimgmt.model.StandardApi;
import com.digiwin.athena.apimgmt.model.StandardApiCategory;
import com.digiwin.athena.apimgmt.model.StandardApiSyncType;
import com.digiwin.athena.apimgmt.model.StandardApiVersion;
import lombok.Data;
import org.springframework.beans.BeanUtils;

@Data
public class ApiInfoResDto {
    private Long apiId;
    private String name;
    private String branch;
    private String version;
    private String approvedStatus;
    private String approvedTime;
    private Integer approvedStatusCode;
    private String description;
    private String remark;
    private String syncType;
    private Integer categoryId;
    private String categoryName;
    private String msgFormat;
    private String requester;
    private String provider;
    private String tenantId;
    private String apiBuildAcct;
    private String apiBuildTime;
    private String designTenantId;
    private String teamId;
    private Integer statusId;
    private String apiType;
    private String projectName;
    private String hasVersions;
    private String projectVersionNameList;
    private String projectVersionNameListStr;

    public static ApiInfoResDto create(StandardApiVersion standardApiVersion, StandardApi standardApi, ApprovedStatus approvedStatus, StandardApiCategory standardApiCategory, StandardApiSyncType standardApiSyncType) {
        ApiInfoResDto apiInfoResDto = new ApiInfoResDto();

        BeanUtils.copyProperties(standardApiVersion, apiInfoResDto,"approvedTime");
        apiInfoResDto.name = standardApi.getName();
        apiInfoResDto.branch = standardApi.getBranch();
        apiInfoResDto.approvedTime = DateUtil.formatLocalDateTime(standardApiVersion.getApprovedTime());
        apiInfoResDto.categoryId = standardApi.getCategory().intValue();
        apiInfoResDto.setMsgFormat(standardApi.getMsgFormat());
        apiInfoResDto.requester=  standardApi.getRequester();
        apiInfoResDto.provider= standardApi.getProvider();
        apiInfoResDto.tenantId = standardApi.getTenantId();
        apiInfoResDto.apiBuildAcct = standardApi.getBuildAcct();
        apiInfoResDto.apiBuildTime = DateUtil.formatLocalDateTime(standardApi.getBuildTime());
        apiInfoResDto.designTenantId = standardApi.getDesignTenantId();
        apiInfoResDto.teamId =  standardApi.getTeamId();
        apiInfoResDto.statusId =  approvedStatus.getId().intValue();
        apiInfoResDto.apiType =  standardApi.getApiType();
        apiInfoResDto.projectName = standardApi.getProjectName();

        String tLocale = ApiMgmtServiceContextHolder.getLocale();

        switch (tLocale) {
            case ApimgmtConstant.ZH_CN:
                apiInfoResDto.setApprovedStatus(approvedStatus.getNameZhCn());
                apiInfoResDto.setApprovedStatusCode(approvedStatus.getId().intValue());
                apiInfoResDto.setDescription(standardApi.getDescriptionZhCn());
                apiInfoResDto.setRemark(standardApi.getRemarkZhCn());
                apiInfoResDto.setSyncType(standardApiSyncType.getNameZhCn());
                apiInfoResDto.setCategoryName(standardApiCategory.getNameZhCn());
                break;
            case ApimgmtConstant.ZH_TW:

                apiInfoResDto.setApprovedStatus(approvedStatus.getNameZhTw());
                apiInfoResDto.setApprovedStatusCode(approvedStatus.getId().intValue());
                apiInfoResDto.setDescription(standardApi.getDescriptionZhTw());
                apiInfoResDto.setRemark(standardApi.getRemarkZhTw());
                apiInfoResDto.setSyncType(standardApiSyncType.getNameZhTw());
                apiInfoResDto.setCategoryName(standardApiCategory.getNameZhTw());
                break;
            case ApimgmtConstant.EN_US:
            default:

                apiInfoResDto.setApprovedStatus(approvedStatus.getNameEnUs());
                apiInfoResDto.setApprovedStatusCode(approvedStatus.getId().intValue());
                apiInfoResDto.setDescription(standardApi.getDescriptionEnUs());
                apiInfoResDto.setRemark(standardApi.getRemarkEnUs());
                apiInfoResDto.setSyncType(standardApiSyncType.getNameEnUs());
                apiInfoResDto.setCategoryName(standardApiCategory.getNameEnUs());
                break;
        }

        return apiInfoResDto;
    }

}
