package com.digiwin.athena.apimgmt.model;

import cn.hutool.core.collection.ListUtil;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.*;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

/**
 * The persistent class for the standard_api_version database table.
 * 
 */
@Data
@ToString(onlyExplicitlyIncluded= true)
@EqualsAndHashCode(exclude = {"standardApiDataNames", "standardApi"})
@TableName(value = "standard_api_version", resultMap = "BaseResultMap")
public class StandardApiVersion implements Serializable {
	private static final long serialVersionUID = 1L;

    @TableId(type = IdType.AUTO)
	private Long id;

    @TableField("approved_status")
    private Integer approvedStatusCode;

    @TableField("approved_acct")
	private String approvedAcct;

    @TableField("applicant")
	private String applicant;

    @TableField("user_id")
	private String userId;

    @TableField("idempotency")
	private Boolean idempotency;

    @TableField(exist = false)
	private ApprovedStatus approvedStatus;

    @TableField("approved_time")
    private LocalDateTime approvedTime;

	private String version;

    @TableField(exist = false)
	// bi-directional many-to-one association to StandardApiDataName
	private List<StandardApiDataName> standardApiDataNames = new ArrayList<>();

    @Getter
    @Setter
    @TableField(value = "api_id")
    private Long apiId;

    @TableField(exist = false)
    // bi-directional many-to-one association to StandardApi
	private StandardApi standardApi;

    @TableField("update_history")
	private String updateHistory;

	public StandardApiVersion() {
	}

    public void setId(Long id) {
        this.id = id;
        if (standardApiDataNames != null) {
            standardApiDataNames.forEach(v -> v.setStandardApiVersion(this));
        }
    }

    public void setStandardApi(StandardApi standardApi) {
        this.standardApi = standardApi;
        if (standardApi != null) {
            this.apiId = standardApi.getId();
        }
    }

    public void setApprovedStatus(ApprovedStatus approvedStatus) {
        this.approvedStatus = approvedStatus;
        if (approvedStatus != null) {
            this.approvedStatusCode = Optional.ofNullable(approvedStatus.getId())
                    .map(Long::intValue).orElse(null);
        }
    }

    public StandardApiDataName addStandardApiDataName(StandardApiDataName standardApiDataName) {
		getStandardApiDataNames().add(standardApiDataName);
		standardApiDataName.setStandardApiVersion(this);

		return standardApiDataName;
	}

    public enum Status {
        DRAFT(1),
        UNDER_REVIEW(2),
        DEVELOPING(3),
        COMFIRMED(4),
        DEACTIVATE(5);

        @Getter
        private final int code;

        Status(int code) {
            this.code = code;
        }

        public static List<Integer> needVerifyAcct() {
            return ListUtil.of(UNDER_REVIEW.code);
        }

        public static List<Integer> notNeedVerifyAcct() {
            return ListUtil.of(DRAFT.code, UNDER_REVIEW.code, DEVELOPING.code,
                    COMFIRMED.code, DEACTIVATE.code);
        }
    }
}