package com.digiwin.athena.apimgmt.dao.impl.mybatis;

import cn.hutool.core.map.MapUtil;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.digiwin.athena.apimgmt.dto.PageReqCondition;
import com.digiwin.athena.apimgmt.enums.UIParamEnum;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Map;

@EqualsAndHashCode(callSuper = true)
@Data
@NoArgsConstructor
public class MpPage<T extends Serializable> extends Page<T> implements Serializable {
    private static final long serialVersionUID = 1L;

    public MpPage(long pageNo, long pageSize) {
        super(pageNo, pageSize);
    }

    public static <E extends Serializable> MpPage<E> from(PageReqCondition<?> pageInfo) {
        MpPage<E> mpPage = new MpPage<>();
        if (pageInfo.getPageNum() != null) {
            mpPage.setPages(pageInfo.getPageNum());
        }
        if (pageInfo.getPageSize() != null) {
            mpPage.setSize(pageInfo.getPageSize());
        }
//        mpPage.setSearchCount(pageInfo.getSearchCount());
//        mpPage.setOrders(BeanUtil.copyList(pageInfo.getOrderList(), OrderItem.class));
        return mpPage;
    }

    public static <E extends Serializable> MpPage<E> from(Map<String, String> map) {
        MpPage<E> mpPage = new MpPage<>();
        mpPage.setPages(MapUtil.getLong(map, UIParamEnum.PAGING_DATASIZE_OFPAGE.toString(), 1L));
        mpPage.setSize(MapUtil.getInt(map, UIParamEnum.PAGING_CURRPAGE_NUM.toString(), 20));
        return mpPage;
    }



    public com.digiwin.athena.apimgmt.service.model.Page<T> toResult() {
        com.digiwin.athena.apimgmt.service.model.Page<T> resp = new com.digiwin.athena.apimgmt.service.model.Page<>();

        resp.setPageTotal(getTotal());
        resp.setList(getRecords());
        resp.setPageNum((int) getCurrent());
        resp.setPageSize((int) getSize());

        return resp;

    }
}
