package com.digiwin.athena.apimgmt.services;

import cn.hutool.core.util.URLUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.apimgmt.constants.ApimgmtConstant;
import com.digiwin.athena.apimgmt.constants.ApimgmtInterfaceConstant;
import com.digiwin.athena.apimgmt.exception.TeamIdNotFindValidationException;
import com.digiwin.athena.apimgmt.exception.TenantInfoRetrievedException;
import com.digiwin.athena.apimgmt.infra.context.ApiMgmtServiceContextHolder;
import com.digiwin.athena.apimgmt.infra.http.HttpFailedException;
import com.digiwin.athena.apimgmt.infra.http.HttpRequest;
import com.digiwin.athena.apimgmt.infra.http.RequestOption;
import com.digiwin.athena.apimgmt.infra.prop.ApiMgmtProp;
import com.digiwin.athena.apimgmt.infra.util.HttpUtil;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.Map;

@Service
@Slf4j
public class ApiMgmtIamVerifyService {


	ObjectMapper mapper = new ObjectMapper();

    @Autowired
    private ApiMgmtProp prop;

	/**
	 * 取得user id
	 */
	public String getUserId(String pUserToken) throws Exception {
		Map<String, String> tResponse = getUserInfo(pUserToken);
		String tUserId = null;
		if (tResponse.get("userId") != null) {
			tUserId = tResponse.get("userId");
		}
		return tUserId;
	}

	/**
	 * 取得user name
	 */
	public String getUserName(String pUserToken) throws Exception {
		Map<String, String> tResponse = getUserInfo(pUserToken);
		String tUserName = null;
		if (tResponse.get("name") != null) {
			tUserName = tResponse.get("name");
		}
		return tUserName;
	}

	/**
	 * 取得tenant id
	 */
	public String getTenantId(String pUserToken) throws Exception {
		Map<String, String> tResponse = getUserInfo(pUserToken);
		String tTenantId = null;
		if (tResponse.get("tenantId") != null) {
			tTenantId = tResponse.get("tenantId");
		}
		return tTenantId;
	}

	/**
	 * 取得user info
	 */
	public Map<String, String> getUserInfo(String pUserToken) throws Exception {
		Map<String, String> tResult = new HashMap<>();
		JsonNode tResponseNode = analyzeToken(pUserToken);
		if (tResponseNode.get("tenantId") != null) {
			tResult.put(ApimgmtConstant.TENANT_ID, tResponseNode.get("tenantId").asText());
		}
        if (tResponseNode.get("tenantName") != null) {
            tResult.put(ApimgmtConstant.TENANT_NAME, tResponseNode.get("tenantName").asText());
        }
		if (tResponseNode.get("id") != null) {
			tResult.put(ApimgmtConstant.USER_ID, tResponseNode.get("id").asText());
		}
		if (tResponseNode.get("name") != null) {
			tResult.put(ApimgmtConstant.USER_NAME, tResponseNode.get("name").asText());
		}
		return tResult;
	}

	/**
	 * 通过token获取用户信息
	 * @param pUserToken pUserToken
	 * @return JsonNode
	 * @throws Exception Exception
	 */
	public JsonNode analyzeToken(String pUserToken) throws Exception {
		try {
            String tDmcHost = prop.getIamUrl();
            String tUri = tDmcHost + ApimgmtInterfaceConstant.IAM_ANALYZE_TOKEN_PATH;
			log.info("token: " + pUserToken + " tUri: " + tUri);
            HttpRequest tPost = HttpRequest.ofPost(tUri);
			//设置请求参数【超时时间】
            RequestOption options = RequestOption.of().setTimeout(prop.getIamSocketTimeout());
			// http header
			tPost.setHeader("Content-Type", "application/json;charset=UTF-8");
			tPost.setHeader(ApimgmtConstant.DIGI_MIDDLEWARE_AUTH_USER, pUserToken);
            tPost.setHeader(ApimgmtConstant.DIGI_MIDDLEWARE_AUTH_APP, prop.getIamToken());
			tPost.setHeader(ApimgmtConstant.TOKEN, pUserToken);
            if (null != ApiMgmtServiceContextHolder.getRouterKey()) {
                tPost.setHeader(ApimgmtConstant.ROUTER_KEY, ApiMgmtServiceContextHolder.getRouterKey());
			}
			log.info("token: " + pUserToken + " tPost: " + tPost);
            String tResponse = HttpUtil.execute(tPost, String.class, options);
			log.info("token: " + pUserToken + " tResponse: " + tResponse);
			return mapper.readTree(tResponse);
        } catch (Exception e) {
            if (e instanceof HttpFailedException) {
                int statusCode = ((HttpFailedException) e).getStatusCode();
                if (HttpStatus.UNAUTHORIZED.value() == statusCode) {
                    throw new TenantInfoRetrievedException("用户登录过期！", this.getClass());
                }
            }

			log.error("获取租户解析失败!token:" + pUserToken + e.getMessage(), e);
			throw new TenantInfoRetrievedException(e.getMessage(), this.getClass());
		}
	}

	/**
	 * 获取teamId
	 * @return String
	 * @throws Exception Exception
	 */
	public String getTeamId(String pUserToken) throws Exception {
		try {
            String tDmcHost = prop.getIamUrl();
            HttpRequest tGet = HttpRequest.ofGet(URLUtil.completeUrl(tDmcHost, ApimgmtInterfaceConstant.IAM_CURRENT_PATH));
			// http header
			tGet.setHeader("Content-Type", "application/json;charset=UTF-8");
			tGet.setHeader(ApimgmtConstant.DIGI_MIDDLEWARE_AUTH_USER, pUserToken);
            tGet.setHeader(ApimgmtConstant.DIGI_MIDDLEWARE_AUTH_APP, prop.getIamToken());
			tGet.setHeader(ApimgmtConstant.TOKEN, pUserToken);
            if (null != ApiMgmtServiceContextHolder.getRouterKey()) {
                tGet.setHeader(ApimgmtConstant.ROUTER_KEY, ApiMgmtServiceContextHolder.getRouterKey());
			}
            String tResponse = HttpUtil.execute(tGet, String.class);
			JsonNode tResponseNode = mapper.readTree(tResponse);
			String teamId = null;
			if (null != tResponseNode.get("data").get("teamId")) {
				teamId = tResponseNode.get("data").get("teamId").asText();
			}
			return teamId;
		} catch (Exception e) {
			log.error("获取teamId解析失败!token:" + pUserToken + e.getMessage(), e);
			throw new TeamIdNotFindValidationException("获取teamId解析失败:" + pUserToken, this.getClass());
		}
	}

//	public String getIntegrationToken(String tenantId) {
//		try {
//
//			String tDmcHost = DWModulePropertiesUtils.getProperty("deployService.url");
//			URI tUri = uriBuilder.create(tDmcHost + String.format(ApimgmtInterfaceConstant.GET_INTEGRATION_TOKEN,tenantId)).build();
//			log.info("getIntegrationToken url:" + tUri.toString());
//
//			HttpGet tGet = new HttpGet(tUri);
//			tGet.setHeader("Content-Type", "application/json;charset=UTF-8");
//			if (null != ServiceContext.getRequestHeader().get(ApimgmtConstant.ROUTER_KEY)) {
//				tGet.setHeader(ApimgmtConstant.ROUTER_KEY, ServiceContext.getRequestHeader().get(ApimgmtConstant.ROUTER_KEY).toString());
//			}
//			String tResponse = httpClient.execute(tGet, String.class);
//			JsonNode tResponseNode = mapper.readTree(tResponse);
//			return tResponseNode.get("data").asText();
//
//		} catch (Exception e) {
//			log.error("getIntegrationToken:" + e.getMessage(), e);
//			throw new RuntimeException("获取集成token失败："+e.getMessage());
//		}
//	}

	public String getIntegrationToken(String tenantId) {
		try {

            String tDmcHost = prop.getIamUrl();
            String tUri = URLUtil.completeUrl(tDmcHost, ApimgmtInterfaceConstant.GET_INTEGRATION_TOKEN);
            log.info("getIntegrationToken url:" + tUri);

            HttpRequest tPost = HttpRequest.ofPost(tUri);
            RequestOption options = RequestOption.of().setTimeout(prop.getIamSocketTimeout());
			// http header
			tPost.setHeader("Content-Type", "application/json;charset=UTF-8");
            tPost.setHeader(ApimgmtConstant.DIGI_MIDDLEWARE_AUTH_APP, prop.getIamToken());
			Map<String, String> requestBody = new HashMap<>();
			requestBody.put("tenantId", tenantId);
            requestBody.put("userId", prop.getIntegrationUserId());
            requestBody.put("passwordHash", prop.getIntegrationPwd());
			tPost.setEntity(requestBody);

            if (null != ApiMgmtServiceContextHolder.getRouterKey()) {
                tPost.setHeader(ApimgmtConstant.ROUTER_KEY, ApiMgmtServiceContextHolder.getRouterKey());
			}
            String tResponse = HttpUtil.execute(tPost, String.class, options);
			JSONObject responseObj = JSON.parseObject(tResponse);
			return responseObj.getString("token");

		} catch (Exception e) {
			log.error("getIntegrationToken:" + e.getMessage(), e);
			throw new RuntimeException("获取集成token失败："+e.getMessage());
		}
	}
}
