/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.apimgmt.apiservice;

import cn.hutool.core.util.ObjectUtil;
import com.digiwin.athena.apimgmt.apiservice.AbstractApiService;
import com.digiwin.athena.apimgmt.constants.ApiTypeConstants;
import com.digiwin.athena.apimgmt.dao.ApiMgmtApprovedStatusDao;
import com.digiwin.athena.apimgmt.dao.ApiMgmtProductCategoryDao;
import com.digiwin.athena.apimgmt.dao.ApiMgmtStandardApiCategoryDao;
import com.digiwin.athena.apimgmt.dao.ApiMgmtStandardApiSyncTypeDao;
import com.digiwin.athena.apimgmt.enums.LocaleEnum;
import com.digiwin.athena.apimgmt.exception.BaseException;
import com.digiwin.athena.apimgmt.infra.context.ApiMgmtServiceContextHolder;
import com.digiwin.athena.apimgmt.model.ApprovedStatus;
import com.digiwin.athena.apimgmt.model.ProductCategory;
import com.digiwin.athena.apimgmt.model.StandardApiCategory;
import com.digiwin.athena.apimgmt.model.StandardApiSyncType;
import com.digiwin.athena.apimgmt.util.StringUtil;
import com.digiwin.athena.apimgmt.validator.ValidatorResult;
import com.fasterxml.jackson.databind.JsonNode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ApiMgmtSearchConditionListGetService
extends AbstractApiService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ApiMgmtSearchConditionListGetService.class);
    @Autowired
    ApiMgmtStandardApiCategoryDao standardApiCategoryDao;
    @Autowired
    ApiMgmtStandardApiSyncTypeDao standardApiSyncTypeDao;
    @Autowired
    ApiMgmtProductCategoryDao productCategoryDao;
    @Autowired
    ApiMgmtApprovedStatusDao approvedStatusDao;

    public ApiMgmtSearchConditionListGetService() {
        this.jsonSchemaFileName = "search_condition_list_get_schema.json";
    }

    @Override
    protected Map<String, Object> processData(ValidatorResult validatorResult) throws BaseException, Exception {
        String tLocale = ApiMgmtServiceContextHolder.getLocale();
        tLocale = tLocale == null ? LocaleEnum.EN_US.getType() : tLocale;
        JsonNode tRequestJsonNode = validatorResult.getJsonContent();
        String tReqCategory = ObjectUtil.isNotNull((Object)tRequestJsonNode.get("categoryId")) ? tRequestJsonNode.get("categoryId").asText() : null;
        String tReqStatus = ObjectUtil.isNotNull((Object)tRequestJsonNode.get("statusId")) ? tRequestJsonNode.get("statusId").asText() : null;
        ArrayList<String> conditionList = new ArrayList<String>();
        conditionList.add("apiName");
        conditionList.add("apiTag");
        conditionList.add("apiDescription");
        conditionList.add("apiRemark");
        conditionList.add("apiSyncType");
        conditionList.add("requester");
        conditionList.add("provider");
        conditionList.add("apiType");
        conditionList.add("apiCategory");
        conditionList.add("apiStatus");
        if (!StringUtil.isEmptyOrSpace((Object)tReqCategory)) {
            conditionList.remove("apiCategory");
        }
        if (!StringUtil.isEmptyOrSpace((Object)tReqStatus)) {
            conditionList.remove("apiStatus");
        }
        HashMap<String, Object> tResponse = new HashMap<String, Object>();
        ArrayList tCondition = new ArrayList();
        for (String condition : conditionList) {
            HashMap<String, Object> tConditionMap = new HashMap<String, Object>();
            ArrayList<String> tEquation = new ArrayList<String>();
            ArrayList<String> tOptionStr = new ArrayList<String>();
            ArrayList tOptionMap = new ArrayList();
            tConditionMap.put("condition", condition);
            switch (condition) {
                case "apiName": 
                case "apiTag": 
                case "apiDataName": 
                case "apiDescription": 
                case "apiRemark": 
                case "tenantId": 
                case "requester": {
                    tEquation.add("like");
                    tEquation.add("equal");
                    tConditionMap.put("equation", tEquation);
                    break;
                }
                case "apiSyncType": {
                    List tStandardApiSyncTypeList = this.standardApiSyncTypeDao.getAll();
                    for (Object tStandardApiSyncType : tStandardApiSyncTypeList) {
                        String tGroupName;
                        HashMap<String, Object> tGroupMap = new HashMap<String, Object>();
                        switch (tLocale) {
                            case "zh_CN": {
                                tGroupName = ((StandardApiSyncType)tStandardApiSyncType).getNameZhCn();
                                break;
                            }
                            case "zh_TW": {
                                tGroupName = ((StandardApiSyncType)tStandardApiSyncType).getNameZhTw();
                                break;
                            }
                            default: {
                                tGroupName = ((StandardApiSyncType)tStandardApiSyncType).getNameEnUs();
                            }
                        }
                        tGroupMap.put("id", ((StandardApiSyncType)tStandardApiSyncType).getId());
                        tGroupMap.put("name", tGroupName);
                        tOptionMap.add(tGroupMap);
                    }
                    tEquation.add("equal");
                    tConditionMap.put("equation", tEquation);
                    tConditionMap.put("option", tOptionMap);
                    break;
                }
                case "apiCategory": {
                    Object tStandardApiSyncType;
                    List tStandardApiCategoryList = this.standardApiCategoryDao.getAll();
                    tStandardApiSyncType = tStandardApiCategoryList.iterator();
                    while (tStandardApiSyncType.hasNext()) {
                        String tCategory;
                        StandardApiCategory tStandardApiCategory = (StandardApiCategory)tStandardApiSyncType.next();
                        HashMap<String, Object> tCategoryMap = new HashMap<String, Object>();
                        switch (tLocale) {
                            case "zh_CN": {
                                tCategory = tStandardApiCategory.getNameZhCn();
                                break;
                            }
                            case "zh_TW": {
                                tCategory = tStandardApiCategory.getNameZhTw();
                                break;
                            }
                            default: {
                                tCategory = tStandardApiCategory.getNameEnUs();
                            }
                        }
                        tCategoryMap.put("id", tStandardApiCategory.getId());
                        tCategoryMap.put("name", tCategory);
                        tOptionMap.add(tCategoryMap);
                    }
                    tEquation.add("equal");
                    tConditionMap.put("equation", tEquation);
                    tConditionMap.put("option", tOptionMap);
                    break;
                }
                case "provider": {
                    List tProductCategoryList = this.productCategoryDao.getAll();
                    for (ProductCategory tProductCategory : tProductCategoryList) {
                        String tGroup;
                        switch (tLocale) {
                            case "zh_CN": {
                                tGroup = tProductCategory.getNameZhCn();
                                break;
                            }
                            case "zh_TW": {
                                tGroup = tProductCategory.getNameZhTw();
                                break;
                            }
                            default: {
                                tGroup = tProductCategory.getNameEnUs();
                            }
                        }
                        tOptionStr.add(tGroup);
                    }
                    tEquation.add("like");
                    tEquation.add("equal");
                    tConditionMap.put("equation", tEquation);
                    tConditionMap.put("option", tOptionStr);
                    break;
                }
                case "apiStatus": {
                    List tApprovedStatusList = this.approvedStatusDao.getAll();
                    for (ApprovedStatus tApprovedStatus : tApprovedStatusList) {
                        String tStatus;
                        HashMap<String, Object> tStatusMap = new HashMap<String, Object>();
                        switch (tLocale) {
                            case "zh_CN": {
                                tStatus = tApprovedStatus.getNameZhCn();
                                break;
                            }
                            case "zh_TW": {
                                tStatus = tApprovedStatus.getNameZhTw();
                                break;
                            }
                            default: {
                                tStatus = tApprovedStatus.getNameEnUs();
                            }
                        }
                        tStatusMap.put("id", tApprovedStatus.getId());
                        tStatusMap.put("name", tStatus);
                        tOptionMap.add(tStatusMap);
                    }
                    tEquation.add("equal");
                    tConditionMap.put("equation", tEquation);
                    tConditionMap.put("option", tOptionMap);
                    break;
                }
                case "apiType": {
                    tEquation.add("equal");
                    tConditionMap.put("equation", tEquation);
                    tConditionMap.put("option", ApiTypeConstants.LANG_OPTIONS.get(tLocale));
                }
            }
            tCondition.add(tConditionMap);
        }
        tResponse.put("conditionList", tCondition);
        return tResponse;
    }
}

