package com.digiwin.athena.apimgmt.services;

import com.digiwin.athena.apimgmt.enums.ApiAttributeEnum;
import com.digiwin.athena.apimgmt.infra.file.ApiMgmtFileService;
import com.digiwin.athena.apimgmt.util.StringUtil;
import com.fasterxml.jackson.databind.node.ObjectNode;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.io.File;

@Slf4j
@Service
public class ApiMgmtDmcFileService {

    @Autowired
    private ApiMgmtFileService apiMgmtFileService;

    /**
     * 上傳檔案並提供下載連結
     **/
    public void uploadFileAndGenerateDownloadLink(ObjectNode pResponseNode, String pFilePath, String pFileName, boolean pIsDetail, int pFailedNum) throws Exception {
        String tSharedDownloadLink = apiMgmtFileService.uploadFileAndGenerateDownloadLink(new File(pFilePath), pFileName);
        if (!StringUtil.isEmptyOrSpace(tSharedDownloadLink)) {
            // 提供API規格檔下載連結
            if (pIsDetail) {
                pResponseNode.put(ApiAttributeEnum.detailFileLink.toString(), tSharedDownloadLink);
                if (pFailedNum != 0) {
                    pResponseNode.put(ApiAttributeEnum.failedNum.toString(), pFailedNum);
                }
            } else {
                pResponseNode.put(ApiAttributeEnum.fileLink.toString(), tSharedDownloadLink);
                pResponseNode.put(ApiAttributeEnum.fileName.toString(), pFileName);
            }
        }
    }

    public String uploadFile(File pFile, String pFileName) throws Exception {
        return apiMgmtFileService.uploadFile(pFile, pFileName);
    }

    public String generateShareDownloadLink(String pFileId) throws Exception {
        return apiMgmtFileService.generateDownloadLink(pFileId);
    }
}
