/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.apimgmt.model;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.digiwin.athena.apimgmt.constants.ApimgmtConstant;
import com.digiwin.athena.apimgmt.dto.ApiParamTextReqDto;
import com.digiwin.athena.apimgmt.enums.LocaleEnum;
import com.digiwin.athena.apimgmt.model.ProjectVersionRelation;
import com.digiwin.athena.apimgmt.model.StandardApiCategory;
import com.digiwin.athena.apimgmt.model.StandardApiExtendDTO;
import com.digiwin.athena.apimgmt.model.StandardApiGroup;
import com.digiwin.athena.apimgmt.model.StandardApiPaging;
import com.digiwin.athena.apimgmt.model.StandardApiSyncType;
import com.digiwin.athena.apimgmt.model.StandardApiVersion;
import jakarta.annotation.Nonnull;
import java.beans.Transient;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import lombok.Generated;

@TableName(value="standard_api", resultMap="StandardApiResultMap")
public class StandardApi
implements Serializable {
    private static final long serialVersionUID = 1L;
    @TableId(type=IdType.AUTO)
    private Long id;
    @TableField(value="build_acct")
    private String buildAcct;
    @TableField(value="build_time")
    private LocalDateTime buildTime;
    @TableField(value="description_en_us")
    private String descriptionEnUs;
    @TableField(value="description_zh_cn")
    private String descriptionZhCn;
    @TableField(value="description_zh_tw")
    private String descriptionZhTw;
    private String name;
    private String provider;
    @TableField(value="remark_en_us")
    private String remarkEnUs;
    @TableField(value="remark_zh_cn")
    private String remarkZhCn;
    @TableField(value="remark_zh_tw")
    private String remarkZhTw;
    private String requester;
    @TableField(value="tag_en_us")
    private String tagEnUs;
    @TableField(value="tag_zh_cn")
    private String tagZhCn;
    @TableField(value="tag_zh_tw")
    private String tagZhTw;
    @TableField(value="is_batch")
    private Boolean isBatch;
    @TableField(value="msg_m_data")
    private Boolean msgMdata = true;
    @TableField(value="msg_format")
    private String msgFormat;
    @TableField(value="tenant_id")
    private String tenantId = "";
    @TableField(value="package_name")
    private String packageName;
    @TableField(value="`group`")
    private Integer group;
    @TableField(exist=false)
    private StandardApiGroup standardApiGroup;
    private Integer syncType;
    @TableField(exist=false)
    private StandardApiSyncType standardApiSyncType;
    private Integer paging;
    @TableField(exist=false)
    private StandardApiPaging standardApiPaging;
    private Long category;
    @TableField(exist=false)
    private StandardApiCategory standardApiCategory;
    @TableField(exist=false)
    private List<StandardApiVersion> standardApiVersions = new ArrayList<StandardApiVersion>();
    @TableField(exist=false)
    private Long projectId;
    @TableField(exist=false)
    private List<Long> projectVersion;
    @TableField(value="design_tenant_id")
    private String designTenantId;
    @TableField(value="team_id")
    private String teamId;
    @TableField(value="team_type")
    private String teamType;
    @TableField(value="parent_api_name")
    private String parentApiName;
    @TableField(value="parent_branch")
    private String parentBranch;
    @TableField(value="parent_api_tenant_id")
    private String parentApiTenantId;
    @TableField(value="api_extend")
    private String apiExtend;
    @TableField(value="first_applicant")
    private String firstApplicant;
    @TableField(value="api_type")
    private String apiType;
    @TableField(value="protocol")
    private String protocol;
    @TableField(value="request_method")
    private String requestMethod;
    @TableField(value="branch")
    private String branch;
    @TableField(value="api_path")
    private String apiPath;
    @TableField(value="text_id")
    private Long textId;
    @TableField(value="use_product")
    private String useProduct;
    @TableField(value="source_product")
    private String sourceProduct;
    @TableField(exist=false)
    private List<ProjectVersionRelation> projectVersionRelations = new ArrayList<ProjectVersionRelation>();
    @TableField(exist=false)
    private String projectName;
    @TableField(exist=false)
    private List<String> projectVersionNameList;
    @TableField(exist=false)
    private Boolean hasVersions = false;
    @TableField(exist=false)
    private ApiParamTextReqDto apiParamText;

    public static boolean validateName(@Nonnull String apiType, String apiName) {
        if (StrUtil.isBlank((CharSequence)apiName)) {
            return false;
        }
        if ("esp".equals(apiType)) {
            return ApimgmtConstant.PATTERN_API_NAME.matcher(apiName).matches();
        }
        if ("openapi".equals(apiType)) {
            return ApimgmtConstant.PATTERN_OPEN_API_NAME.matcher(apiName).matches();
        }
        return false;
    }

    public static boolean skipSyncMdc(String apiType, String apiExtend) {
        StandardApiExtendDTO dto = StandardApiExtendDTO.fromJson(apiExtend);
        if (dto != null && dto.getSyncMdc() != null) {
            return dto.getSyncMdc() == false;
        }
        return StrUtil.isNotBlank((CharSequence)apiType) && !"esp".equals(apiType);
    }

    public static boolean skipSyncDev(String apiType) {
        return StrUtil.isNotBlank((CharSequence)apiType) && !"esp".equals(apiType);
    }

    public boolean skipSyncDev() {
        return StandardApi.skipSyncDev(this.getApiType());
    }

    public boolean skipSyncMdc() {
        return StandardApi.skipSyncMdc(this.getApiType(), this.getApiExtend());
    }

    public Boolean getBatch() {
        return this.isBatch;
    }

    public void setBatch(Boolean batch) {
        this.isBatch = batch;
    }

    public String buildProjectVerNameStr(String locale) {
        boolean hasBindVer = CollUtil.isNotEmpty(this.getProjectVersionNameList());
        if (hasBindVer) {
            return String.join((CharSequence)",", this.getProjectVersionNameList());
        }
        if (Boolean.TRUE.equals(this.getHasVersions())) {
            if (LocaleEnum.EN_US.getType().equals(locale)) {
                return "All versions are universal";
            }
            return "\u6240\u6709\u7248\u672c\u901a\u7528";
        }
        return "-";
    }

    public StandardApiVersion addStandardApiVersion(StandardApiVersion standardApiVersion) {
        this.getStandardApiVersions().add(standardApiVersion);
        standardApiVersion.setStandardApi(this);
        return standardApiVersion;
    }

    @Transient
    public String getApiTypeOrDefault() {
        String apiType = this.getApiType();
        if (StrUtil.isBlank((CharSequence)apiType)) {
            return "esp";
        }
        return apiType;
    }

    public boolean validateName() {
        return StandardApi.validateName(this.getApiTypeOrDefault(), this.getName());
    }

    public boolean validateBranch() {
        return ApimgmtConstant.PATTERN_BRANCH.matcher(this.getBranch()).matches();
    }

    public boolean isOpenApi() {
        return "openapi".equals(this.getApiTypeOrDefault());
    }

    public void setId(Long id) {
        this.id = id;
        if (this.standardApiVersions != null) {
            this.standardApiVersions.forEach(v -> v.setStandardApi(this));
        }
        if (this.projectVersionRelations != null) {
            this.projectVersionRelations.forEach(v -> v.setStandardApi(this));
        }
    }

    public void setStandardApiCategory(StandardApiCategory standardApiCategory) {
        this.standardApiCategory = standardApiCategory;
        if (standardApiCategory != null) {
            this.category = standardApiCategory.getId();
        }
    }

    public void setStandardApiGroup(StandardApiGroup standardApiGroup) {
        this.standardApiGroup = standardApiGroup;
        if (standardApiGroup != null) {
            this.group = Optional.ofNullable(standardApiGroup.getId()).map(Long::intValue).orElse(null);
        }
    }

    public void setStandardApiSyncType(StandardApiSyncType standardApiSyncType) {
        this.standardApiSyncType = standardApiSyncType;
        if (standardApiSyncType != null) {
            this.syncType = Optional.ofNullable(standardApiSyncType.getId()).map(Long::intValue).orElse(null);
        }
    }

    public void setStandardApiPaging(StandardApiPaging standardApiPaging) {
        this.standardApiPaging = standardApiPaging;
        if (standardApiPaging != null) {
            this.paging = Optional.ofNullable(standardApiPaging.getId()).map(Long::intValue).orElse(null);
        }
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public String getBuildAcct() {
        return this.buildAcct;
    }

    @Generated
    public LocalDateTime getBuildTime() {
        return this.buildTime;
    }

    @Generated
    public String getDescriptionEnUs() {
        return this.descriptionEnUs;
    }

    @Generated
    public String getDescriptionZhCn() {
        return this.descriptionZhCn;
    }

    @Generated
    public String getDescriptionZhTw() {
        return this.descriptionZhTw;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getProvider() {
        return this.provider;
    }

    @Generated
    public String getRemarkEnUs() {
        return this.remarkEnUs;
    }

    @Generated
    public String getRemarkZhCn() {
        return this.remarkZhCn;
    }

    @Generated
    public String getRemarkZhTw() {
        return this.remarkZhTw;
    }

    @Generated
    public String getRequester() {
        return this.requester;
    }

    @Generated
    public String getTagEnUs() {
        return this.tagEnUs;
    }

    @Generated
    public String getTagZhCn() {
        return this.tagZhCn;
    }

    @Generated
    public String getTagZhTw() {
        return this.tagZhTw;
    }

    @Generated
    public Boolean getIsBatch() {
        return this.isBatch;
    }

    @Generated
    public Boolean getMsgMdata() {
        return this.msgMdata;
    }

    @Generated
    public String getMsgFormat() {
        return this.msgFormat;
    }

    @Generated
    public String getTenantId() {
        return this.tenantId;
    }

    @Generated
    public String getPackageName() {
        return this.packageName;
    }

    @Generated
    public Integer getGroup() {
        return this.group;
    }

    @Generated
    public StandardApiGroup getStandardApiGroup() {
        return this.standardApiGroup;
    }

    @Generated
    public Integer getSyncType() {
        return this.syncType;
    }

    @Generated
    public StandardApiSyncType getStandardApiSyncType() {
        return this.standardApiSyncType;
    }

    @Generated
    public Integer getPaging() {
        return this.paging;
    }

    @Generated
    public StandardApiPaging getStandardApiPaging() {
        return this.standardApiPaging;
    }

    @Generated
    public Long getCategory() {
        return this.category;
    }

    @Generated
    public StandardApiCategory getStandardApiCategory() {
        return this.standardApiCategory;
    }

    @Generated
    public List<StandardApiVersion> getStandardApiVersions() {
        return this.standardApiVersions;
    }

    @Generated
    public Long getProjectId() {
        return this.projectId;
    }

    @Generated
    public List<Long> getProjectVersion() {
        return this.projectVersion;
    }

    @Generated
    public String getDesignTenantId() {
        return this.designTenantId;
    }

    @Generated
    public String getTeamId() {
        return this.teamId;
    }

    @Generated
    public String getTeamType() {
        return this.teamType;
    }

    @Generated
    public String getParentApiName() {
        return this.parentApiName;
    }

    @Generated
    public String getParentBranch() {
        return this.parentBranch;
    }

    @Generated
    public String getParentApiTenantId() {
        return this.parentApiTenantId;
    }

    @Generated
    public String getApiExtend() {
        return this.apiExtend;
    }

    @Generated
    public String getFirstApplicant() {
        return this.firstApplicant;
    }

    @Generated
    public String getApiType() {
        return this.apiType;
    }

    @Generated
    public String getProtocol() {
        return this.protocol;
    }

    @Generated
    public String getRequestMethod() {
        return this.requestMethod;
    }

    @Generated
    public String getBranch() {
        return this.branch;
    }

    @Generated
    public String getApiPath() {
        return this.apiPath;
    }

    @Generated
    public Long getTextId() {
        return this.textId;
    }

    @Generated
    public String getUseProduct() {
        return this.useProduct;
    }

    @Generated
    public String getSourceProduct() {
        return this.sourceProduct;
    }

    @Generated
    public List<ProjectVersionRelation> getProjectVersionRelations() {
        return this.projectVersionRelations;
    }

    @Generated
    public String getProjectName() {
        return this.projectName;
    }

    @Generated
    public List<String> getProjectVersionNameList() {
        return this.projectVersionNameList;
    }

    @Generated
    public Boolean getHasVersions() {
        return this.hasVersions;
    }

    @Generated
    public ApiParamTextReqDto getApiParamText() {
        return this.apiParamText;
    }

    @Generated
    public void setBuildAcct(String buildAcct) {
        this.buildAcct = buildAcct;
    }

    @Generated
    public void setBuildTime(LocalDateTime buildTime) {
        this.buildTime = buildTime;
    }

    @Generated
    public void setDescriptionEnUs(String descriptionEnUs) {
        this.descriptionEnUs = descriptionEnUs;
    }

    @Generated
    public void setDescriptionZhCn(String descriptionZhCn) {
        this.descriptionZhCn = descriptionZhCn;
    }

    @Generated
    public void setDescriptionZhTw(String descriptionZhTw) {
        this.descriptionZhTw = descriptionZhTw;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setProvider(String provider) {
        this.provider = provider;
    }

    @Generated
    public void setRemarkEnUs(String remarkEnUs) {
        this.remarkEnUs = remarkEnUs;
    }

    @Generated
    public void setRemarkZhCn(String remarkZhCn) {
        this.remarkZhCn = remarkZhCn;
    }

    @Generated
    public void setRemarkZhTw(String remarkZhTw) {
        this.remarkZhTw = remarkZhTw;
    }

    @Generated
    public void setRequester(String requester) {
        this.requester = requester;
    }

    @Generated
    public void setTagEnUs(String tagEnUs) {
        this.tagEnUs = tagEnUs;
    }

    @Generated
    public void setTagZhCn(String tagZhCn) {
        this.tagZhCn = tagZhCn;
    }

    @Generated
    public void setTagZhTw(String tagZhTw) {
        this.tagZhTw = tagZhTw;
    }

    @Generated
    public void setIsBatch(Boolean isBatch) {
        this.isBatch = isBatch;
    }

    @Generated
    public void setMsgMdata(Boolean msgMdata) {
        this.msgMdata = msgMdata;
    }

    @Generated
    public void setMsgFormat(String msgFormat) {
        this.msgFormat = msgFormat;
    }

    @Generated
    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    @Generated
    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    @Generated
    public void setGroup(Integer group) {
        this.group = group;
    }

    @Generated
    public void setSyncType(Integer syncType) {
        this.syncType = syncType;
    }

    @Generated
    public void setPaging(Integer paging) {
        this.paging = paging;
    }

    @Generated
    public void setCategory(Long category) {
        this.category = category;
    }

    @Generated
    public void setStandardApiVersions(List<StandardApiVersion> standardApiVersions) {
        this.standardApiVersions = standardApiVersions;
    }

    @Generated
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    @Generated
    public void setProjectVersion(List<Long> projectVersion) {
        this.projectVersion = projectVersion;
    }

    @Generated
    public void setDesignTenantId(String designTenantId) {
        this.designTenantId = designTenantId;
    }

    @Generated
    public void setTeamId(String teamId) {
        this.teamId = teamId;
    }

    @Generated
    public void setTeamType(String teamType) {
        this.teamType = teamType;
    }

    @Generated
    public void setParentApiName(String parentApiName) {
        this.parentApiName = parentApiName;
    }

    @Generated
    public void setParentBranch(String parentBranch) {
        this.parentBranch = parentBranch;
    }

    @Generated
    public void setParentApiTenantId(String parentApiTenantId) {
        this.parentApiTenantId = parentApiTenantId;
    }

    @Generated
    public void setApiExtend(String apiExtend) {
        this.apiExtend = apiExtend;
    }

    @Generated
    public void setFirstApplicant(String firstApplicant) {
        this.firstApplicant = firstApplicant;
    }

    @Generated
    public void setApiType(String apiType) {
        this.apiType = apiType;
    }

    @Generated
    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    @Generated
    public void setRequestMethod(String requestMethod) {
        this.requestMethod = requestMethod;
    }

    @Generated
    public void setBranch(String branch) {
        this.branch = branch;
    }

    @Generated
    public void setApiPath(String apiPath) {
        this.apiPath = apiPath;
    }

    @Generated
    public void setTextId(Long textId) {
        this.textId = textId;
    }

    @Generated
    public void setUseProduct(String useProduct) {
        this.useProduct = useProduct;
    }

    @Generated
    public void setSourceProduct(String sourceProduct) {
        this.sourceProduct = sourceProduct;
    }

    @Generated
    public void setProjectVersionRelations(List<ProjectVersionRelation> projectVersionRelations) {
        this.projectVersionRelations = projectVersionRelations;
    }

    @Generated
    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    @Generated
    public void setProjectVersionNameList(List<String> projectVersionNameList) {
        this.projectVersionNameList = projectVersionNameList;
    }

    @Generated
    public void setHasVersions(Boolean hasVersions) {
        this.hasVersions = hasVersions;
    }

    @Generated
    public void setApiParamText(ApiParamTextReqDto apiParamText) {
        this.apiParamText = apiParamText;
    }

    @Generated
    public String toString() {
        return "StandardApi()";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StandardApi)) {
            return false;
        }
        StandardApi other = (StandardApi)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Boolean this$isBatch = this.getIsBatch();
        Boolean other$isBatch = other.getIsBatch();
        if (this$isBatch == null ? other$isBatch != null : !((Object)this$isBatch).equals(other$isBatch)) {
            return false;
        }
        Boolean this$msgMdata = this.getMsgMdata();
        Boolean other$msgMdata = other.getMsgMdata();
        if (this$msgMdata == null ? other$msgMdata != null : !((Object)this$msgMdata).equals(other$msgMdata)) {
            return false;
        }
        Integer this$group = this.getGroup();
        Integer other$group = other.getGroup();
        if (this$group == null ? other$group != null : !((Object)this$group).equals(other$group)) {
            return false;
        }
        Integer this$syncType = this.getSyncType();
        Integer other$syncType = other.getSyncType();
        if (this$syncType == null ? other$syncType != null : !((Object)this$syncType).equals(other$syncType)) {
            return false;
        }
        Integer this$paging = this.getPaging();
        Integer other$paging = other.getPaging();
        if (this$paging == null ? other$paging != null : !((Object)this$paging).equals(other$paging)) {
            return false;
        }
        Long this$category = this.getCategory();
        Long other$category = other.getCategory();
        if (this$category == null ? other$category != null : !((Object)this$category).equals(other$category)) {
            return false;
        }
        Long this$projectId = this.getProjectId();
        Long other$projectId = other.getProjectId();
        if (this$projectId == null ? other$projectId != null : !((Object)this$projectId).equals(other$projectId)) {
            return false;
        }
        Long this$textId = this.getTextId();
        Long other$textId = other.getTextId();
        if (this$textId == null ? other$textId != null : !((Object)this$textId).equals(other$textId)) {
            return false;
        }
        Boolean this$hasVersions = this.getHasVersions();
        Boolean other$hasVersions = other.getHasVersions();
        if (this$hasVersions == null ? other$hasVersions != null : !((Object)this$hasVersions).equals(other$hasVersions)) {
            return false;
        }
        String this$buildAcct = this.getBuildAcct();
        String other$buildAcct = other.getBuildAcct();
        if (this$buildAcct == null ? other$buildAcct != null : !this$buildAcct.equals(other$buildAcct)) {
            return false;
        }
        LocalDateTime this$buildTime = this.getBuildTime();
        LocalDateTime other$buildTime = other.getBuildTime();
        if (this$buildTime == null ? other$buildTime != null : !((Object)this$buildTime).equals(other$buildTime)) {
            return false;
        }
        String this$descriptionEnUs = this.getDescriptionEnUs();
        String other$descriptionEnUs = other.getDescriptionEnUs();
        if (this$descriptionEnUs == null ? other$descriptionEnUs != null : !this$descriptionEnUs.equals(other$descriptionEnUs)) {
            return false;
        }
        String this$descriptionZhCn = this.getDescriptionZhCn();
        String other$descriptionZhCn = other.getDescriptionZhCn();
        if (this$descriptionZhCn == null ? other$descriptionZhCn != null : !this$descriptionZhCn.equals(other$descriptionZhCn)) {
            return false;
        }
        String this$descriptionZhTw = this.getDescriptionZhTw();
        String other$descriptionZhTw = other.getDescriptionZhTw();
        if (this$descriptionZhTw == null ? other$descriptionZhTw != null : !this$descriptionZhTw.equals(other$descriptionZhTw)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$provider = this.getProvider();
        String other$provider = other.getProvider();
        if (this$provider == null ? other$provider != null : !this$provider.equals(other$provider)) {
            return false;
        }
        String this$remarkEnUs = this.getRemarkEnUs();
        String other$remarkEnUs = other.getRemarkEnUs();
        if (this$remarkEnUs == null ? other$remarkEnUs != null : !this$remarkEnUs.equals(other$remarkEnUs)) {
            return false;
        }
        String this$remarkZhCn = this.getRemarkZhCn();
        String other$remarkZhCn = other.getRemarkZhCn();
        if (this$remarkZhCn == null ? other$remarkZhCn != null : !this$remarkZhCn.equals(other$remarkZhCn)) {
            return false;
        }
        String this$remarkZhTw = this.getRemarkZhTw();
        String other$remarkZhTw = other.getRemarkZhTw();
        if (this$remarkZhTw == null ? other$remarkZhTw != null : !this$remarkZhTw.equals(other$remarkZhTw)) {
            return false;
        }
        String this$requester = this.getRequester();
        String other$requester = other.getRequester();
        if (this$requester == null ? other$requester != null : !this$requester.equals(other$requester)) {
            return false;
        }
        String this$tagEnUs = this.getTagEnUs();
        String other$tagEnUs = other.getTagEnUs();
        if (this$tagEnUs == null ? other$tagEnUs != null : !this$tagEnUs.equals(other$tagEnUs)) {
            return false;
        }
        String this$tagZhCn = this.getTagZhCn();
        String other$tagZhCn = other.getTagZhCn();
        if (this$tagZhCn == null ? other$tagZhCn != null : !this$tagZhCn.equals(other$tagZhCn)) {
            return false;
        }
        String this$tagZhTw = this.getTagZhTw();
        String other$tagZhTw = other.getTagZhTw();
        if (this$tagZhTw == null ? other$tagZhTw != null : !this$tagZhTw.equals(other$tagZhTw)) {
            return false;
        }
        String this$msgFormat = this.getMsgFormat();
        String other$msgFormat = other.getMsgFormat();
        if (this$msgFormat == null ? other$msgFormat != null : !this$msgFormat.equals(other$msgFormat)) {
            return false;
        }
        String this$tenantId = this.getTenantId();
        String other$tenantId = other.getTenantId();
        if (this$tenantId == null ? other$tenantId != null : !this$tenantId.equals(other$tenantId)) {
            return false;
        }
        String this$packageName = this.getPackageName();
        String other$packageName = other.getPackageName();
        if (this$packageName == null ? other$packageName != null : !this$packageName.equals(other$packageName)) {
            return false;
        }
        List<Long> this$projectVersion = this.getProjectVersion();
        List<Long> other$projectVersion = other.getProjectVersion();
        if (this$projectVersion == null ? other$projectVersion != null : !((Object)this$projectVersion).equals(other$projectVersion)) {
            return false;
        }
        String this$designTenantId = this.getDesignTenantId();
        String other$designTenantId = other.getDesignTenantId();
        if (this$designTenantId == null ? other$designTenantId != null : !this$designTenantId.equals(other$designTenantId)) {
            return false;
        }
        String this$teamId = this.getTeamId();
        String other$teamId = other.getTeamId();
        if (this$teamId == null ? other$teamId != null : !this$teamId.equals(other$teamId)) {
            return false;
        }
        String this$teamType = this.getTeamType();
        String other$teamType = other.getTeamType();
        if (this$teamType == null ? other$teamType != null : !this$teamType.equals(other$teamType)) {
            return false;
        }
        String this$parentApiName = this.getParentApiName();
        String other$parentApiName = other.getParentApiName();
        if (this$parentApiName == null ? other$parentApiName != null : !this$parentApiName.equals(other$parentApiName)) {
            return false;
        }
        String this$parentBranch = this.getParentBranch();
        String other$parentBranch = other.getParentBranch();
        if (this$parentBranch == null ? other$parentBranch != null : !this$parentBranch.equals(other$parentBranch)) {
            return false;
        }
        String this$parentApiTenantId = this.getParentApiTenantId();
        String other$parentApiTenantId = other.getParentApiTenantId();
        if (this$parentApiTenantId == null ? other$parentApiTenantId != null : !this$parentApiTenantId.equals(other$parentApiTenantId)) {
            return false;
        }
        String this$apiExtend = this.getApiExtend();
        String other$apiExtend = other.getApiExtend();
        if (this$apiExtend == null ? other$apiExtend != null : !this$apiExtend.equals(other$apiExtend)) {
            return false;
        }
        String this$firstApplicant = this.getFirstApplicant();
        String other$firstApplicant = other.getFirstApplicant();
        if (this$firstApplicant == null ? other$firstApplicant != null : !this$firstApplicant.equals(other$firstApplicant)) {
            return false;
        }
        String this$apiType = this.getApiType();
        String other$apiType = other.getApiType();
        if (this$apiType == null ? other$apiType != null : !this$apiType.equals(other$apiType)) {
            return false;
        }
        String this$protocol = this.getProtocol();
        String other$protocol = other.getProtocol();
        if (this$protocol == null ? other$protocol != null : !this$protocol.equals(other$protocol)) {
            return false;
        }
        String this$requestMethod = this.getRequestMethod();
        String other$requestMethod = other.getRequestMethod();
        if (this$requestMethod == null ? other$requestMethod != null : !this$requestMethod.equals(other$requestMethod)) {
            return false;
        }
        String this$branch = this.getBranch();
        String other$branch = other.getBranch();
        if (this$branch == null ? other$branch != null : !this$branch.equals(other$branch)) {
            return false;
        }
        String this$apiPath = this.getApiPath();
        String other$apiPath = other.getApiPath();
        if (this$apiPath == null ? other$apiPath != null : !this$apiPath.equals(other$apiPath)) {
            return false;
        }
        String this$useProduct = this.getUseProduct();
        String other$useProduct = other.getUseProduct();
        if (this$useProduct == null ? other$useProduct != null : !this$useProduct.equals(other$useProduct)) {
            return false;
        }
        String this$sourceProduct = this.getSourceProduct();
        String other$sourceProduct = other.getSourceProduct();
        if (this$sourceProduct == null ? other$sourceProduct != null : !this$sourceProduct.equals(other$sourceProduct)) {
            return false;
        }
        ApiParamTextReqDto this$apiParamText = this.getApiParamText();
        ApiParamTextReqDto other$apiParamText = other.getApiParamText();
        return !(this$apiParamText == null ? other$apiParamText != null : !this$apiParamText.equals(other$apiParamText));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof StandardApi;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Boolean $isBatch = this.getIsBatch();
        result = result * 59 + ($isBatch == null ? 43 : ((Object)$isBatch).hashCode());
        Boolean $msgMdata = this.getMsgMdata();
        result = result * 59 + ($msgMdata == null ? 43 : ((Object)$msgMdata).hashCode());
        Integer $group = this.getGroup();
        result = result * 59 + ($group == null ? 43 : ((Object)$group).hashCode());
        Integer $syncType = this.getSyncType();
        result = result * 59 + ($syncType == null ? 43 : ((Object)$syncType).hashCode());
        Integer $paging = this.getPaging();
        result = result * 59 + ($paging == null ? 43 : ((Object)$paging).hashCode());
        Long $category = this.getCategory();
        result = result * 59 + ($category == null ? 43 : ((Object)$category).hashCode());
        Long $projectId = this.getProjectId();
        result = result * 59 + ($projectId == null ? 43 : ((Object)$projectId).hashCode());
        Long $textId = this.getTextId();
        result = result * 59 + ($textId == null ? 43 : ((Object)$textId).hashCode());
        Boolean $hasVersions = this.getHasVersions();
        result = result * 59 + ($hasVersions == null ? 43 : ((Object)$hasVersions).hashCode());
        String $buildAcct = this.getBuildAcct();
        result = result * 59 + ($buildAcct == null ? 43 : $buildAcct.hashCode());
        LocalDateTime $buildTime = this.getBuildTime();
        result = result * 59 + ($buildTime == null ? 43 : ((Object)$buildTime).hashCode());
        String $descriptionEnUs = this.getDescriptionEnUs();
        result = result * 59 + ($descriptionEnUs == null ? 43 : $descriptionEnUs.hashCode());
        String $descriptionZhCn = this.getDescriptionZhCn();
        result = result * 59 + ($descriptionZhCn == null ? 43 : $descriptionZhCn.hashCode());
        String $descriptionZhTw = this.getDescriptionZhTw();
        result = result * 59 + ($descriptionZhTw == null ? 43 : $descriptionZhTw.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $provider = this.getProvider();
        result = result * 59 + ($provider == null ? 43 : $provider.hashCode());
        String $remarkEnUs = this.getRemarkEnUs();
        result = result * 59 + ($remarkEnUs == null ? 43 : $remarkEnUs.hashCode());
        String $remarkZhCn = this.getRemarkZhCn();
        result = result * 59 + ($remarkZhCn == null ? 43 : $remarkZhCn.hashCode());
        String $remarkZhTw = this.getRemarkZhTw();
        result = result * 59 + ($remarkZhTw == null ? 43 : $remarkZhTw.hashCode());
        String $requester = this.getRequester();
        result = result * 59 + ($requester == null ? 43 : $requester.hashCode());
        String $tagEnUs = this.getTagEnUs();
        result = result * 59 + ($tagEnUs == null ? 43 : $tagEnUs.hashCode());
        String $tagZhCn = this.getTagZhCn();
        result = result * 59 + ($tagZhCn == null ? 43 : $tagZhCn.hashCode());
        String $tagZhTw = this.getTagZhTw();
        result = result * 59 + ($tagZhTw == null ? 43 : $tagZhTw.hashCode());
        String $msgFormat = this.getMsgFormat();
        result = result * 59 + ($msgFormat == null ? 43 : $msgFormat.hashCode());
        String $tenantId = this.getTenantId();
        result = result * 59 + ($tenantId == null ? 43 : $tenantId.hashCode());
        String $packageName = this.getPackageName();
        result = result * 59 + ($packageName == null ? 43 : $packageName.hashCode());
        List<Long> $projectVersion = this.getProjectVersion();
        result = result * 59 + ($projectVersion == null ? 43 : ((Object)$projectVersion).hashCode());
        String $designTenantId = this.getDesignTenantId();
        result = result * 59 + ($designTenantId == null ? 43 : $designTenantId.hashCode());
        String $teamId = this.getTeamId();
        result = result * 59 + ($teamId == null ? 43 : $teamId.hashCode());
        String $teamType = this.getTeamType();
        result = result * 59 + ($teamType == null ? 43 : $teamType.hashCode());
        String $parentApiName = this.getParentApiName();
        result = result * 59 + ($parentApiName == null ? 43 : $parentApiName.hashCode());
        String $parentBranch = this.getParentBranch();
        result = result * 59 + ($parentBranch == null ? 43 : $parentBranch.hashCode());
        String $parentApiTenantId = this.getParentApiTenantId();
        result = result * 59 + ($parentApiTenantId == null ? 43 : $parentApiTenantId.hashCode());
        String $apiExtend = this.getApiExtend();
        result = result * 59 + ($apiExtend == null ? 43 : $apiExtend.hashCode());
        String $firstApplicant = this.getFirstApplicant();
        result = result * 59 + ($firstApplicant == null ? 43 : $firstApplicant.hashCode());
        String $apiType = this.getApiType();
        result = result * 59 + ($apiType == null ? 43 : $apiType.hashCode());
        String $protocol = this.getProtocol();
        result = result * 59 + ($protocol == null ? 43 : $protocol.hashCode());
        String $requestMethod = this.getRequestMethod();
        result = result * 59 + ($requestMethod == null ? 43 : $requestMethod.hashCode());
        String $branch = this.getBranch();
        result = result * 59 + ($branch == null ? 43 : $branch.hashCode());
        String $apiPath = this.getApiPath();
        result = result * 59 + ($apiPath == null ? 43 : $apiPath.hashCode());
        String $useProduct = this.getUseProduct();
        result = result * 59 + ($useProduct == null ? 43 : $useProduct.hashCode());
        String $sourceProduct = this.getSourceProduct();
        result = result * 59 + ($sourceProduct == null ? 43 : $sourceProduct.hashCode());
        ApiParamTextReqDto $apiParamText = this.getApiParamText();
        result = result * 59 + ($apiParamText == null ? 43 : $apiParamText.hashCode());
        return result;
    }
}

