/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.apimgmt.services;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.apimgmt.constants.ApimgmtConstant;
import com.digiwin.athena.apimgmt.dao.ApiMgmtApprovedStatusDao;
import com.digiwin.athena.apimgmt.dao.ApiMgmtProjectDao;
import com.digiwin.athena.apimgmt.dao.ApiMgmtProjectVersionRelationDao;
import com.digiwin.athena.apimgmt.dao.ApiMgmtStandardApiCategoryDao;
import com.digiwin.athena.apimgmt.dao.ApiMgmtStandardApiGroupDao;
import com.digiwin.athena.apimgmt.dao.ApiMgmtStandardApiPagingDao;
import com.digiwin.athena.apimgmt.dao.ApiMgmtStandardApiSyncTypeDao;
import com.digiwin.athena.apimgmt.dao.ApimgmtProductDao;
import com.digiwin.athena.apimgmt.dto.ApiParamTextReqDto;
import com.digiwin.athena.apimgmt.enums.APIExportImportEnums;
import com.digiwin.athena.apimgmt.enums.ApiAttributeEnum;
import com.digiwin.athena.apimgmt.enums.ColumnTypeEnum;
import com.digiwin.athena.apimgmt.enums.DataTypeEnum;
import com.digiwin.athena.apimgmt.enums.LocaleEnum;
import com.digiwin.athena.apimgmt.infra.context.ApiMgmtServiceContextHolder;
import com.digiwin.athena.apimgmt.infra.prop.ApiMgmtProp;
import com.digiwin.athena.apimgmt.model.ApprovedStatus;
import com.digiwin.athena.apimgmt.model.Product;
import com.digiwin.athena.apimgmt.model.ProductApiDataName;
import com.digiwin.athena.apimgmt.model.Project;
import com.digiwin.athena.apimgmt.model.ProjectVersionRelation;
import com.digiwin.athena.apimgmt.model.StandardApi;
import com.digiwin.athena.apimgmt.model.StandardApiCategory;
import com.digiwin.athena.apimgmt.model.StandardApiDataName;
import com.digiwin.athena.apimgmt.model.StandardApiGroup;
import com.digiwin.athena.apimgmt.model.StandardApiPaging;
import com.digiwin.athena.apimgmt.model.StandardApiSyncType;
import com.digiwin.athena.apimgmt.model.StandardApiVersion;
import com.digiwin.athena.apimgmt.service.util.ApiVersionServiceUtil;
import com.digiwin.athena.apimgmt.service.util.StandardApiFileReadServiceUtil;
import com.digiwin.athena.apimgmt.services.AbstractService;
import com.digiwin.athena.apimgmt.util.StringUtil;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="esp")
public class ApiMgmtStandardApiSpecAnalyzeService
extends AbstractService {
    @Autowired
    private ApiMgmtApprovedStatusDao approvedStatusDao;
    @Autowired
    private ApiMgmtStandardApiSyncTypeDao standardApiSyncTypeDao;
    @Autowired
    private ApiMgmtStandardApiGroupDao standardApiGroupDao;
    @Autowired
    private ApiMgmtStandardApiPagingDao standardApiPagingDao;
    @Autowired
    private ApiMgmtStandardApiCategoryDao standardApiCategoryDao;
    @Autowired
    private ApimgmtProductDao productDao;
    @Autowired
    private ApiMgmtProjectVersionRelationDao projectVersionRelationDao;
    @Autowired
    private ApiMgmtProjectDao projectDao;
    @Autowired
    private ApiMgmtProp prop;

    protected void setStandardApiExtend(List<Map<String, String>> tResult, StandardApi pStandardApi, JsonNode pRequestJsonNode, String pLocale) {
        String tApiName = pRequestJsonNode.get(ApiAttributeEnum.apiName.toString()).asText();
        pStandardApi.setName(tApiName);
        if (ApimgmtConstant.PATTERN_API_NAME.matcher(tApiName).matches()) {
            if (this.prop.isEnvType()) {
                pStandardApi.setName("dw.paas." + tApiName);
            } else {
                pStandardApi.setName(tApiName);
            }
        } else {
            StandardApiFileReadServiceUtil.uploadCheckResult(tResult, APIExportImportEnums.APINAME_WRONG.toString(), 2L, null, 0, 0, pLocale);
        }
        if (null != pRequestJsonNode.get(ApiAttributeEnum.parentApiName.toString()) && !"null".equals(pRequestJsonNode.get(ApiAttributeEnum.parentApiName.toString()).asText())) {
            pStandardApi.setParentApiName(pRequestJsonNode.get(ApiAttributeEnum.parentApiName.toString()).asText());
            String parentApiTenantId = "";
            if (null != pRequestJsonNode.get(ApiAttributeEnum.parentApiTenantId.toString()) && !"null".equals(pRequestJsonNode.get(ApiAttributeEnum.parentApiTenantId.toString()).asText())) {
                parentApiTenantId = pRequestJsonNode.get(ApiAttributeEnum.parentApiTenantId.toString()).asText();
            }
            pStandardApi.setParentApiTenantId(parentApiTenantId);
            String parentBranch = "1.0";
            if (!StrUtil.isNullOrUndefined((CharSequence)pStandardApi.getBranch())) {
                parentBranch = pStandardApi.getBranch();
            }
            pStandardApi.setParentBranch(parentBranch);
        }
        pStandardApi.setRequestMethod("POST");
    }

    public List<Map<String, String>> setStandardApi(StandardApi pStandardApi, JsonNode pRequestJsonNode, String pLocale) throws Exception {
        String tTagEnUs;
        String tTagZhCn;
        ArrayList<ProjectVersionRelation> projectVersionRelationList;
        List projectVersionList;
        ArrayList<Map<String, String>> tResult = new ArrayList<Map<String, String>>();
        String tUserName = ApiMgmtServiceContextHolder.getUserName();
        String tUserId = ApiMgmtServiceContextHolder.getUserId();
        StandardApiVersion tStandardApiVersion = new StandardApiVersion();
        tStandardApiVersion.setApprovedAcct(tUserId);
        tStandardApiVersion.setUserId(tUserId);
        pStandardApi.setBuildAcct(tUserId);
        long projectId = this.getProjectId(pRequestJsonNode);
        pStandardApi.setProjectId(projectId);
        String projectVersionStr = ObjectUtil.isNotNull((Object)pRequestJsonNode.get(ApiAttributeEnum.projectVersionIdList.toString())) ? pRequestJsonNode.get(ApiAttributeEnum.projectVersionIdList.toString()).toString() : null;
        List list = projectVersionList = StringUtils.isNotEmpty(projectVersionStr) ? JSONArray.parseArray((String)projectVersionStr, Long.class) : null;
        if (CollectionUtil.isNotEmpty((Collection)projectVersionList)) {
            projectVersionRelationList = projectVersionList.stream().map(projectVersionId -> {
                ProjectVersionRelation projectVersionRelation = new ProjectVersionRelation();
                projectVersionRelation.setProjectId(projectId);
                projectVersionRelation.setProjectVersionId((Long)projectVersionId);
                projectVersionRelation.setStandardApi(pStandardApi);
                return projectVersionRelation;
            }).collect(Collectors.toList());
        } else {
            projectVersionRelationList = new ArrayList();
            ProjectVersionRelation projectRelation = new ProjectVersionRelation();
            projectRelation.setProjectId(projectId);
            projectRelation.setStandardApi(pStandardApi);
            projectVersionRelationList.add(projectRelation);
        }
        pStandardApi.setProjectVersionRelations(projectVersionRelationList);
        String tApiName = pRequestJsonNode.get(ApiAttributeEnum.apiName.toString()).asText();
        if (StringUtil.isEmptyOrSpace((Object)tApiName)) {
            StandardApiFileReadServiceUtil.uploadCheckResult(tResult, APIExportImportEnums.REQUIRED.toString(), 1L, null, 0, 0, pLocale);
        }
        boolean tDescriptionZhTwEmpty = false;
        JsonNode tDescNode = pRequestJsonNode.get(ApiAttributeEnum.apiDescriptionMultilingual.toString());
        String tDescZhTw = tDescNode.get("zh_TW").asText();
        if (StringUtil.isEmptyOrSpace((Object)tDescZhTw)) {
            tDescriptionZhTwEmpty = true;
        } else {
            pStandardApi.setDescriptionZhTw(tDescZhTw.trim());
        }
        boolean tDescriptionZhCnEmpty = false;
        String tDescZhCn = tDescNode.get("zh_CN").asText();
        if (StringUtil.isEmptyOrSpace((Object)tDescZhCn)) {
            tDescriptionZhCnEmpty = true;
        } else {
            pStandardApi.setDescriptionZhCn(tDescZhCn.trim());
        }
        if (tDescriptionZhTwEmpty && tDescriptionZhCnEmpty) {
            StandardApiFileReadServiceUtil.uploadCheckResult(tResult, APIExportImportEnums.REQUIRED.toString(), 3L, null, 0, 0, pLocale);
        } else if (tDescriptionZhTwEmpty) {
            tDescZhTw = this.localeTranslate(tDescZhCn, LocaleEnum.ZH2HANT.getType());
            pStandardApi.setDescriptionZhTw(tDescZhTw.trim());
        } else if (tDescriptionZhCnEmpty) {
            tDescZhCn = this.localeTranslate(tDescZhTw, LocaleEnum.ZH2HANS.getType());
            pStandardApi.setDescriptionZhCn(tDescZhCn.trim());
        }
        String tDescEnUs = tDescNode.get("en_US").asText();
        if (StringUtil.isEmptyOrSpace((Object)tDescEnUs)) {
            pStandardApi.setDescriptionEnUs(tDescZhTw.trim());
        } else {
            pStandardApi.setDescriptionEnUs(tDescEnUs.trim());
        }
        String tApiVersion = pRequestJsonNode.get(ApiAttributeEnum.apiVersion.toString()).asText().trim();
        if (StringUtil.isEmptyOrSpace((Object)tApiVersion)) {
            StandardApiFileReadServiceUtil.uploadCheckResult(tResult, APIExportImportEnums.REQUIRED.toString(), 5L, null, 0, 0, pLocale);
        } else {
            if (!tApiVersion.matches("\\d+\\.\\d+")) {
                StandardApiFileReadServiceUtil.uploadCheckResult(tResult, APIExportImportEnums.INCORRECT_FORMAT_OR_CONTENT.toString(), 6L, null, 0, 0, pLocale);
            }
            pStandardApi.addStandardApiVersion(tStandardApiVersion);
            if (tApiVersion.endsWith(".0")) {
                pStandardApi.setFirstApplicant(tUserName);
            }
            String branch = ApiVersionServiceUtil.getBranchFromVersion(tApiVersion);
            pStandardApi.setBranch(branch);
            tStandardApiVersion.setStandardApi(pStandardApi);
            tStandardApiVersion.setVersion(tApiVersion);
            tStandardApiVersion.setApplicant(tUserName);
            ApprovedStatus approvedStatus = (ApprovedStatus)this.approvedStatusDao.get(1L);
            tStandardApiVersion.setApprovedStatus(approvedStatus);
        }
        String tInvokeType = pRequestJsonNode.get(ApiAttributeEnum.invokeType.toString()).asText();
        StandardApiSyncType tStandardApiSyncType = null;
        if (tInvokeType.equals("sync")) {
            tStandardApiSyncType = (StandardApiSyncType)this.standardApiSyncTypeDao.get(1L);
        } else if (tInvokeType.equals("fasync")) {
            tStandardApiSyncType = (StandardApiSyncType)this.standardApiSyncTypeDao.get(2L);
        }
        pStandardApi.setStandardApiSyncType(tStandardApiSyncType);
        long tPaging = pRequestJsonNode.get(ApiAttributeEnum.paging.toString()).asLong();
        StandardApiPaging tStandardApiPaging = (StandardApiPaging)this.standardApiPagingDao.get(tPaging);
        pStandardApi.setStandardApiPaging(tStandardApiPaging);
        String tRequester = pRequestJsonNode.get(ApiAttributeEnum.requester.toString()).asText();
        if (StringUtil.isEmptyOrSpace((Object)tRequester)) {
            StandardApiFileReadServiceUtil.uploadCheckResult(tResult, APIExportImportEnums.REQUIRED.toString(), 12L, null, 0, 0, pLocale);
        } else {
            pStandardApi.setRequester(tRequester);
        }
        String tProvider = pRequestJsonNode.get(ApiAttributeEnum.provider.toString()).asText();
        if (StringUtil.isEmptyOrSpace((Object)tProvider)) {
            StandardApiFileReadServiceUtil.uploadCheckResult(tResult, APIExportImportEnums.REQUIRED.toString(), 13L, null, 0, 0, pLocale);
        } else {
            pStandardApi.setProvider(tProvider);
        }
        boolean tIsBatch = pRequestJsonNode.get(ApiAttributeEnum.isBatch.toString()).asText().equals("Y");
        if (!tApiName.endsWith(".get") && tIsBatch) {
            StandardApiFileReadServiceUtil.uploadCheckResult(tResult, APIExportImportEnums.CAN_NOT_BATCH.toString(), 15L, null, 0, 0, pLocale);
        }
        pStandardApi.setIsBatch(tIsBatch);
        StandardApiGroup tStandardApiGroup = (StandardApiGroup)this.standardApiGroupDao.get(pRequestJsonNode.get(ApiAttributeEnum.group.toString()).asLong());
        pStandardApi.setStandardApiGroup(tStandardApiGroup);
        StandardApiCategory tStandardApiCategory = (StandardApiCategory)this.standardApiCategoryDao.get(pRequestJsonNode.get(ApiAttributeEnum.categoryId.toString()).asLong());
        pStandardApi.setStandardApiCategory(tStandardApiCategory);
        String tMsgFormat = pRequestJsonNode.get(ApiAttributeEnum.msgFormat.toString()).asText();
        pStandardApi.setMsgFormat(tMsgFormat);
        JsonNode tTagNode = pRequestJsonNode.get(ApiAttributeEnum.apiTagMultilingual.toString());
        String tTagZhTw = tTagNode.get("zh_TW").asText().trim();
        if (!StringUtil.isEmptyOrSpace((Object)tTagZhTw)) {
            pStandardApi.setTagZhTw(tTagZhTw);
        }
        if (!StringUtil.isEmptyOrSpace((Object)(tTagZhCn = tTagNode.get("zh_CN").asText().trim()))) {
            pStandardApi.setTagZhCn(tTagZhCn);
        }
        if (!StringUtil.isEmptyOrSpace((Object)(tTagEnUs = tTagNode.get("en_US").asText().trim()))) {
            pStandardApi.setTagEnUs(tTagEnUs);
        } else {
            pStandardApi.setTagEnUs(tTagZhTw);
        }
        boolean tRemarkZhTWEmpty = false;
        JsonNode tRemarkNode = pRequestJsonNode.get(ApiAttributeEnum.apiRemarkMultilingual.toString());
        String tRemarkZhTw = tRemarkNode.get("zh_TW").asText().trim();
        if (StringUtil.isEmptyOrSpace((Object)tRemarkZhTw)) {
            tRemarkZhTWEmpty = true;
        } else {
            pStandardApi.setRemarkZhTw(tRemarkZhTw);
        }
        boolean tRemarkZhCNEmpty = false;
        String tRemarkZhCn = tRemarkNode.get("zh_CN").asText().trim();
        if (StringUtil.isEmptyOrSpace((Object)tRemarkZhCn)) {
            tRemarkZhCNEmpty = true;
        } else {
            pStandardApi.setRemarkZhCn(tRemarkZhCn);
        }
        if (tRemarkZhTWEmpty && tRemarkZhCNEmpty) {
            StandardApiFileReadServiceUtil.uploadCheckResult(tResult, APIExportImportEnums.REQUIRED.toString(), 23L, null, 0, 0, pLocale);
        } else if (tRemarkZhTWEmpty) {
            tRemarkZhTw = this.localeTranslate(tRemarkZhCn, LocaleEnum.ZH2HANT.getType());
            pStandardApi.setRemarkZhTw(tRemarkZhTw);
        } else if (tRemarkZhCNEmpty) {
            tRemarkZhCn = this.localeTranslate(tRemarkZhTw, LocaleEnum.ZH2HANS.getType());
            pStandardApi.setRemarkZhCn(tRemarkZhCn);
        }
        String tRemarkEnUs = tRemarkNode.get("en_US").asText().trim();
        if (!StringUtil.isEmptyOrSpace((Object)tRemarkEnUs)) {
            pStandardApi.setRemarkEnUs(tRemarkEnUs);
        } else {
            pStandardApi.setRemarkEnUs(tRemarkZhTw);
        }
        String tTenantId = null;
        if (pRequestJsonNode.get(ApiAttributeEnum.tenantId.toString()) != null && !pRequestJsonNode.get(ApiAttributeEnum.tenantId.toString()).isNull()) {
            tTenantId = pRequestJsonNode.get(ApiAttributeEnum.tenantId.toString()).asText();
        }
        if (StringUtil.isEmptyOrSpace(tTenantId) || ApimgmtConstant.TENANT_ID_DEFAULT.equals(tTenantId)) {
            pStandardApi.setTenantId("");
        } else {
            pStandardApi.setTenantId(tTenantId);
        }
        String tPackageName = null;
        if (pRequestJsonNode.get(ApiAttributeEnum.packageName.toString()) != null) {
            tPackageName = pRequestJsonNode.get(ApiAttributeEnum.packageName.toString()).asText().trim();
        }
        if (!StringUtil.isEmptyOrSpace(tPackageName)) {
            pStandardApi.setPackageName(tPackageName);
        }
        boolean tIdempotency = pRequestJsonNode.get(ApiAttributeEnum.idempotency.toString()).asText().equals("Y");
        tStandardApiVersion.setIdempotency(tIdempotency);
        String tEditHistory = pRequestJsonNode.get(ApiAttributeEnum.editHistory.toString()).asText().trim();
        if (!StringUtil.isEmptyOrSpace((Object)tEditHistory)) {
            tStandardApiVersion.setUpdateHistory(tEditHistory);
        }
        pStandardApi.setDesignTenantId(ApiMgmtServiceContextHolder.getTenantId());
        JsonNode apiExtendNode = pRequestJsonNode.get(ApiAttributeEnum.apiExtend.toString());
        if (null != apiExtendNode) {
            pStandardApi.setApiExtend(this.mapper.writeValueAsString((Object)apiExtendNode));
        }
        if (pRequestJsonNode.get(ApiAttributeEnum.textId.toString()) != null && !pRequestJsonNode.get(ApiAttributeEnum.textId.toString()).isNull()) {
            pStandardApi.setTextId(pRequestJsonNode.get(ApiAttributeEnum.textId.toString()).asLong());
        }
        if (pRequestJsonNode.get(ApiAttributeEnum.apiParamText.toString()) != null && !pRequestJsonNode.get(ApiAttributeEnum.apiParamText.toString()).isNull()) {
            pStandardApi.setApiParamText((ApiParamTextReqDto)JSONObject.parseObject((String)pRequestJsonNode.get(ApiAttributeEnum.apiParamText.toString()).toString(), ApiParamTextReqDto.class));
        }
        pStandardApi.setUseProduct(this.getNode(pRequestJsonNode, ApiAttributeEnum.useProduct).map(JsonNode::toString).orElse(null));
        pStandardApi.setSourceProduct(this.getNode(pRequestJsonNode, ApiAttributeEnum.source).map(JsonNode::asText).orElse(null));
        this.setStandardApiExtend(tResult, pStandardApi, pRequestJsonNode, pLocale);
        return tResult;
    }

    protected long getProjectId(JsonNode pRequestJsonNode) {
        Project project;
        long projectId = this.getNode(pRequestJsonNode, ApiAttributeEnum.projectId).map(v -> v.asLong(-1L)).orElse(-1L);
        if (projectId != -1L) {
            return projectId;
        }
        String projectCode = this.getNode(pRequestJsonNode, ApiAttributeEnum.projectCode).map(JsonNode::asText).orElse(null);
        if (StrUtil.isNotBlank((CharSequence)projectCode) && (project = this.projectDao.getByName(projectCode)) != null) {
            return project.getProjectId();
        }
        return 1L;
    }

    protected Optional<JsonNode> getNode(JsonNode pRequestJsonNode, ApiAttributeEnum keyEnum) {
        return Optional.ofNullable(pRequestJsonNode.get(keyEnum.toString()));
    }

    public List<Map<String, String>> setStandardApiDataName(StandardApi pStandardApi, JsonNode pRequestJsonNode, Map<String, StandardApiDataName> pAddDataName, String pLocale) throws Exception {
        ArrayList<Map<String, String>> tResult = new ArrayList<Map<String, String>>();
        ArrayNode tRequestSpecArrayNode = (ArrayNode)pRequestJsonNode.get("requestMessageSpec");
        ArrayNode tResponseSuccessSpecArrayNode = (ArrayNode)pRequestJsonNode.get("responseMessageSuccessSpec");
        ArrayNode tResponseFailSpecArrayNode = (ArrayNode)pRequestJsonNode.get("responseMessageFailedSpec");
        ArrayList<String> productNameList = new ArrayList<String>();
        this.setStandardApiDataNameByRow(tResult, pStandardApi, tRequestSpecArrayNode, pAddDataName, 1, null, pLocale, productNameList);
        this.setStandardApiDataNameByRow(tResult, pStandardApi, tResponseSuccessSpecArrayNode, pAddDataName, 2, null, pLocale, productNameList);
        this.setStandardApiDataNameByRow(tResult, pStandardApi, tResponseFailSpecArrayNode, pAddDataName, 3, null, pLocale, productNameList);
        return tResult;
    }

    private void setStandardApiDataNameByRow(List<Map<String, String>> pResult, StandardApi pStandardApi, ArrayNode pSpecArrayNode, Map<String, StandardApiDataName> pAddDataName, Integer pMsgType, StandardApiDataName pFatherStandardApiDataName, String pLocale, List<String> productNameList) throws Exception {
        if (pSpecArrayNode.isArray()) {
            for (JsonNode tNode : pSpecArrayNode) {
                JsonNode productPrecision;
                String tEditHistory;
                String tListEnumEn;
                String tListEnumZhCn;
                String tListEnumZhTw;
                String tDataNameRemarkEnUs;
                String tDataNameRemarkZhCn;
                String tDataNameRemarkZhTw;
                String tValue;
                StandardApiDataName tStandardApiDataName = new StandardApiDataName();
                boolean tIsBusinessKey = tNode.get(ApiAttributeEnum.isBusinessKey.toString()).asText().equals("Y");
                tStandardApiDataName.setIsBusinesskey(tIsBusinessKey);
                String tColumnType = tNode.get(ApiAttributeEnum.columnType.toString()).asText();
                if (StringUtil.isEmptyOrSpace((Object)tColumnType)) {
                    StandardApiFileReadServiceUtil.uploadCheckResult(pResult, APIExportImportEnums.REQUIRED.toString(), 24L, null, 0, 0, pLocale);
                } else {
                    block58: {
                        try {
                            ColumnTypeEnum.valueOf((String)tColumnType.toUpperCase());
                        }
                        catch (IllegalArgumentException e) {
                            if (tColumnType.toUpperCase().matches("(S{1}|[0-9]+){0,1}D(F{0,1})")) break block58;
                            StandardApiFileReadServiceUtil.uploadCheckResult(pResult, APIExportImportEnums.INCORRECT_FORMAT_OR_CONTENT.toString(), 24L, null, 0, 0, pLocale);
                        }
                    }
                    tStandardApiDataName.setColumnType(tColumnType);
                }
                String tDataName = tNode.get(ApiAttributeEnum.dataName.toString()).asText().trim();
                if (StringUtil.isEmptyOrSpace((Object)tDataName)) {
                    StandardApiFileReadServiceUtil.uploadCheckResult(pResult, APIExportImportEnums.REQUIRED.toString(), 27L, null, 0, 0, pLocale);
                } else {
                    tDataName = tDataName.replaceAll("[ |\u3000]", "");
                    if (StandardApiDataName.validateName(pStandardApi.getApiType(), tDataName)) {
                        tStandardApiDataName.setStandardDataName(tDataName);
                    } else {
                        Long solutionId = pStandardApi.isOpenApi() ? 3701L : 37L;
                        StandardApiFileReadServiceUtil.uploadCheckResult(pResult, APIExportImportEnums.REQUIRED.toString(), solutionId, tDataName, 0, 0, pLocale);
                    }
                }
                String tDataType = tNode.get(ApiAttributeEnum.dataType.toString()).asText();
                if (!Arrays.asList(ApimgmtConstant.ALLOW_ARRAY_COLUMN_TYPE).contains(tColumnType.toUpperCase()) && !tColumnType.toUpperCase().matches("(S{1}|[0-9]+){0,1}D")) {
                    if (StringUtil.isEmptyOrSpace((Object)tDataType)) {
                        StandardApiFileReadServiceUtil.uploadCheckResult(pResult, APIExportImportEnums.REQUIRED.toString(), 29L, tDataName, 0, 0, pLocale);
                    } else {
                        try {
                            DataTypeEnum.valueOf((String)tDataType.toUpperCase());
                        }
                        catch (IllegalArgumentException e) {
                            StandardApiFileReadServiceUtil.uploadCheckResult(pResult, APIExportImportEnums.INCORRECT_FORMAT_OR_CONTENT.toString(), 29L, tDataName, 0, 0, pLocale);
                        }
                        tStandardApiDataName.setDataType(tDataType.toLowerCase());
                    }
                }
                boolean tIsRequired = tNode.get(ApiAttributeEnum.isRequired.toString()).asText().equals("Y");
                tStandardApiDataName.setIsRequired(tIsRequired);
                boolean tIsDatakey = tNode.get(ApiAttributeEnum.isDatakey.toString()).asText().equals("Y");
                tStandardApiDataName.setIsDatakey(tIsDatakey);
                boolean tIsArray = tNode.get(ApiAttributeEnum.isArray.toString()).asText().equals("Y");
                tStandardApiDataName.setIsArray(tIsArray);
                boolean tCanSort = tNode.get(ApiAttributeEnum.canSort.toString()).asText().equals("Y");
                tStandardApiDataName.setCanSort(tCanSort);
                boolean tCanFilter = tNode.get(ApiAttributeEnum.canFilter.toString()).asText().equals("Y");
                tStandardApiDataName.setCanFilter(tCanFilter);
                boolean tDescriptionZhTwEmpty = false;
                JsonNode tDataNameDescNode = tNode.get(ApiAttributeEnum.dataDescriptionMultilingual.toString());
                String tDataNameDescZhTw = tDataNameDescNode.get("zh_TW").asText();
                if (StringUtil.isEmptyOrSpace((Object)tDataNameDescZhTw)) {
                    tDescriptionZhTwEmpty = true;
                } else {
                    tStandardApiDataName.setDescriptionZhTw(tDataNameDescZhTw.trim());
                }
                boolean tDescriptionZhCnEmpty = false;
                String tDataNameDescZhCn = tDataNameDescNode.get("zh_CN").asText();
                if (StringUtil.isEmptyOrSpace((Object)tDataNameDescZhCn)) {
                    tDescriptionZhCnEmpty = true;
                } else {
                    tStandardApiDataName.setDescriptionZhCn(tDataNameDescZhCn.trim());
                }
                if (tDescriptionZhTwEmpty && tDescriptionZhCnEmpty) {
                    StandardApiFileReadServiceUtil.uploadCheckResult(pResult, APIExportImportEnums.REQUIRED.toString(), 31L, tDataName, 0, 0, pLocale);
                } else if (tDescriptionZhTwEmpty) {
                    tDataNameDescZhTw = this.localeTranslate(tDataNameDescZhCn, LocaleEnum.ZH2HANT.getType());
                    tStandardApiDataName.setDescriptionZhTw(tDataNameDescZhTw.trim());
                } else if (tDescriptionZhCnEmpty) {
                    tDataNameDescZhCn = this.localeTranslate(tDataNameDescZhTw, LocaleEnum.ZH2HANS.getType());
                    tStandardApiDataName.setDescriptionZhCn(tDataNameDescZhCn.trim());
                }
                String tDataNameDescEnUs = tDataNameDescNode.get("en_US").asText();
                if (!StringUtil.isEmptyOrSpace((Object)tDataNameDescEnUs)) {
                    tStandardApiDataName.setDescriptionEnUs(tDataNameDescEnUs.trim());
                } else {
                    tStandardApiDataName.setDescriptionEnUs(tDataName.replace("_", " "));
                }
                String string = tValue = tNode.has("value") ? tNode.get("value").asText() : null;
                if (!StringUtil.isEmptyOrSpace((Object)tValue)) {
                    tStandardApiDataName.setValue(tValue);
                }
                boolean tRemarkZhTwEmpty = false;
                JsonNode tDataNameRemarkNode = tNode.get(ApiAttributeEnum.dataNameRemarkMultilingual.toString());
                String string2 = tDataNameRemarkZhTw = tDataNameRemarkNode != null && tDataNameRemarkNode.has("zh_TW") ? tDataNameRemarkNode.get("zh_TW").asText() : null;
                if (StringUtil.isEmptyOrSpace(tDataNameRemarkZhTw)) {
                    tRemarkZhTwEmpty = true;
                } else {
                    tStandardApiDataName.setRemarkZhTw(tDataNameRemarkZhTw.trim());
                }
                boolean tRemarkZhCnEmpty = false;
                String string3 = tDataNameRemarkZhCn = tDataNameRemarkNode != null && tDataNameRemarkNode.has("zh_CN") ? tDataNameRemarkNode.get("zh_CN").asText() : null;
                if (StringUtil.isEmptyOrSpace(tDataNameRemarkZhCn)) {
                    tRemarkZhCnEmpty = true;
                } else {
                    tStandardApiDataName.setRemarkZhCn(tDataNameRemarkZhCn.trim());
                }
                if (tRemarkZhTwEmpty && !tRemarkZhCnEmpty) {
                    tDataNameRemarkZhTw = this.localeTranslate(tDataNameRemarkZhCn, LocaleEnum.ZH2HANT.getType());
                    tStandardApiDataName.setRemarkZhTw(tDataNameRemarkZhTw.trim());
                }
                if (tRemarkZhCnEmpty && !tRemarkZhTwEmpty) {
                    tDataNameRemarkZhCn = this.localeTranslate(tDataNameRemarkZhTw, LocaleEnum.ZH2HANS.getType());
                    tStandardApiDataName.setRemarkZhCn(tDataNameRemarkZhCn.trim());
                }
                String string4 = tDataNameRemarkEnUs = tDataNameRemarkNode != null && tDataNameRemarkNode.has("en_US") ? tDataNameRemarkNode.get("en_US").asText() : null;
                if (StringUtil.isEmptyOrSpace(tDataNameRemarkEnUs)) {
                    tStandardApiDataName.setRemarkEnUs(tStandardApiDataName.getRemarkZhTw());
                } else {
                    tStandardApiDataName.setRemarkEnUs(tDataNameRemarkEnUs.trim());
                }
                JsonNode tListEnumNode = tNode.get(ApiAttributeEnum.listEnumMultilingual.toString());
                String string5 = tListEnumZhTw = tListEnumNode != null && tListEnumNode.has("zh_TW") ? tListEnumNode.get("zh_TW").asText() : null;
                if (!StringUtil.isEmptyOrSpace(tListEnumZhTw)) {
                    tStandardApiDataName.setListEnumZhTw(tListEnumZhTw);
                }
                String string6 = tListEnumZhCn = tListEnumNode != null && tListEnumNode.has("zh_CN") ? tListEnumNode.get("zh_CN").asText() : null;
                if (!StringUtil.isEmptyOrSpace(tListEnumZhCn)) {
                    tStandardApiDataName.setListEnumZhCn(tListEnumZhCn);
                }
                String string7 = tListEnumEn = tListEnumNode != null && tListEnumNode.has("en_US") ? tListEnumNode.get("en_US").asText() : null;
                if (!StringUtil.isEmptyOrSpace(tListEnumEn)) {
                    tStandardApiDataName.setListEnumEn(tListEnumEn);
                }
                String string8 = tEditHistory = tNode.has(ApiAttributeEnum.editHistory.toString()) ? tNode.get(ApiAttributeEnum.editHistory.toString()).asText().trim() : null;
                if (!StringUtil.isEmptyOrSpace(tEditHistory)) {
                    tStandardApiDataName.setUpdateHistory(tEditHistory);
                }
                JsonNode jsonNode = productPrecision = tNode.has(ApiAttributeEnum.productPrecision.toString()) ? tNode.get(ApiAttributeEnum.productPrecision.toString()) : null;
                if (null != productPrecision) {
                    Iterator it = productPrecision.fieldNames();
                    while (it.hasNext()) {
                        String tProdName = (String)it.next();
                        ProductApiDataName productApiDataName = new ProductApiDataName();
                        productApiDataName.setApiDataName(tStandardApiDataName);
                        tStandardApiDataName.addProductApiDataName(productApiDataName);
                        if (!this.productDao.exists(tProdName) && !productNameList.contains(tProdName)) {
                            productNameList.add(tProdName);
                            StandardApiFileReadServiceUtil.uploadCheckResult(pResult, APIExportImportEnums.INVALID_PROD_NAME.toString(), 33L, tDataName, 0, 0, pLocale);
                        } else {
                            Product tProduct = (Product)this.productDao.get(tProdName);
                            productApiDataName.setProduct(tProduct);
                            productApiDataName.setApiDataName(tStandardApiDataName);
                            tStandardApiDataName.addProductApiDataName(productApiDataName);
                        }
                        try {
                            if (null != productPrecision.get(tProdName) && !"null".equals(productPrecision.get(tProdName).asText())) {
                                if ("string".equals(tStandardApiDataName.getDataType())) {
                                    productApiDataName.setLength(productPrecision.get(tProdName).asInt());
                                } else if ("numeric".equals(tStandardApiDataName.getDataType())) {
                                    productApiDataName.setLength(Integer.parseInt(productPrecision.get(tProdName).asText().split(",")[0]));
                                    productApiDataName.setPrecision(Integer.parseInt(productPrecision.get(tProdName).asText().split(",")[1]));
                                } else {
                                    StandardApiFileReadServiceUtil.uploadCheckResult(pResult, APIExportImportEnums.CAN_NOT_INPUT_PRECISIONS.toString(), 36L, tDataName, 0, 0, pLocale);
                                }
                            }
                        }
                        catch (ArrayIndexOutOfBoundsException | NumberFormatException ex) {
                            StandardApiFileReadServiceUtil.uploadCheckResult(pResult, APIExportImportEnums.INCORRECT_FORMAT_OF_PRECISION.toString(), 34L, tDataName, 0, 0, pLocale);
                        }
                        if (!StringUtil.isEmptyOrSpace((Object)tProdName) || productNameList.contains(tProdName)) continue;
                        StandardApiFileReadServiceUtil.uploadCheckResult(pResult, APIExportImportEnums.NO_INPUT_PROD_NAME.toString(), 33L, tDataName, 0, 0, pLocale);
                        productNameList.add(tProdName);
                    }
                }
                if (pStandardApi.getStandardApiVersions().size() == 0) {
                    return;
                }
                tStandardApiDataName.setStandardApiVersion(pStandardApi.getStandardApiVersions().get(0));
                tStandardApiDataName.setMsgType(pMsgType);
                tStandardApiDataName.setApiVer("1.0");
                if (tColumnType.equals(ColumnTypeEnum.E.toString()) && !ArrayUtils.contains((Object[])ApimgmtConstant.COLUMN_TYPE_E_DATA_NAME, (Object)tDataName)) {
                    StandardApiFileReadServiceUtil.uploadCheckResult(pResult, APIExportImportEnums.DATA_TYPE_WRONG.toString(), 35L, tDataName, 0, 0, pLocale);
                }
                if (!ArrayUtils.contains((Object[])ApimgmtConstant.DATANAME_FATHER_UNREQUIRED, (Object)tColumnType.toUpperCase())) {
                    if (pFatherStandardApiDataName != null) {
                        for (StandardApiDataName tExistDataName : pFatherStandardApiDataName.getChildrens()) {
                            if (!tDataName.equals(tExistDataName.getStandardDataName())) continue;
                            StandardApiFileReadServiceUtil.uploadCheckResult(pResult, APIExportImportEnums.DUPLICATE_DATANAME.toString(), 28L, tDataName, 0, 0, pLocale);
                        }
                        pFatherStandardApiDataName.addChildren(tStandardApiDataName);
                        tStandardApiDataName.setParent(pFatherStandardApiDataName);
                        String tFatherDataName = pFatherStandardApiDataName.getStandardDataName();
                        pAddDataName.put(tColumnType + tDataName + pMsgType + tFatherDataName, tStandardApiDataName);
                    } else {
                        StandardApiFileReadServiceUtil.uploadCheckResult(pResult, APIExportImportEnums.CAN_NOT_FIND_FATHER.toString(), 25L, tDataName, 0, 0, pLocale);
                    }
                } else {
                    StandardApiDataName tDataName2;
                    if ((tColumnType.toUpperCase().equals(ColumnTypeEnum.DATAKEY.toString()) || tColumnType.toUpperCase().equals(ColumnTypeEnum.P.toString()) || tColumnType.toUpperCase().equals(ColumnTypeEnum.E.toString()) || tColumnType.toUpperCase().equals(ColumnTypeEnum.M.toString()) || tColumnType.toUpperCase().equals(ColumnTypeEnum.H.toString())) && (tDataName2 = pAddDataName.get(tColumnType + tDataName + pMsgType)) != null) {
                        StandardApiFileReadServiceUtil.uploadCheckResult(pResult, APIExportImportEnums.DUPLICATE_DATANAME.toString(), 28L, tDataName, 0, 0, pLocale);
                    }
                    pAddDataName.put(tColumnType + tDataName + pMsgType, tStandardApiDataName);
                    pStandardApi.getStandardApiVersions().get(0).addStandardApiDataName(tStandardApiDataName);
                }
                if (tNode.get("childrens") == null) continue;
                ArrayNode tChildrensArrayNode = (ArrayNode)tNode.get("childrens");
                this.setStandardApiDataNameByRow(pResult, pStandardApi, tChildrensArrayNode, pAddDataName, pMsgType, tStandardApiDataName, pLocale, productNameList);
            }
        }
    }
}

