/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.apimgmt.service.util;

import cn.hutool.core.util.StrUtil;
import cn.hutool.extra.spring.SpringUtil;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.apimgmt.ApiMgmtApplicationParameter;
import com.digiwin.athena.apimgmt.event.ApiReviewedEvent;
import com.digiwin.athena.apimgmt.model.StandardApiVersion;
import com.digiwin.athena.apimgmt.service.util.GenericServiceUtil;
import com.digiwin.athena.apimgmt.services.ApiMgmtDevelopmentPlatformService;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DevelopmentPlatformServiceUtil
extends GenericServiceUtil<ApiMgmtDevelopmentPlatformService> {
    private static final Logger log = LoggerFactory.getLogger(DevelopmentPlatformServiceUtil.class);
    private static ApiMgmtDevelopmentPlatformService service;

    public static void sendApiToDevelopmentPlatform(StandardApiVersion tStandardApiVersion) throws Exception {
        if (tStandardApiVersion.getStandardApi().skipSyncDev()) {
            log.info("\u975eesp\u7684API\u4e0d\u9700\u8981\u540c\u6b65,apiName={}", (Object)tStandardApiVersion.getStandardApi().getName());
            return;
        }
        try {
            String msg = service.sendDpMessage(tStandardApiVersion);
            SpringUtil.publishEvent((Object)new ApiReviewedEvent(msg));
        }
        catch (Exception e) {
            log.info("api\u66f4\u65b0\u5904\u7406\u4e8b\u4ef6\u5f02\u5e38\uff01", (Throwable)e);
            throw new Exception("api\u66f4\u65b0\u5904\u7406\u4e8b\u4ef6\u5f02\u5e38");
        }
        if (StrUtil.isNotEmpty((CharSequence)ApiMgmtApplicationParameter._DEV_PLATE_URL)) {
            service.sendApiToDevelopmentPlatform(tStandardApiVersion);
        }
    }

    @Override
    @Autowired
    public void setService(ApiMgmtDevelopmentPlatformService pService) {
        service = pService;
    }

    public static List<String> getWithAuthList(String pUserToken, String type) throws Exception {
        Object obj;
        JSONObject jsonObject = service.getWithAuthList(pUserToken, type);
        JSONObject data = jsonObject.getJSONObject("data");
        if (null != data && null != (obj = data.get((Object)"obj"))) {
            return (List)obj;
        }
        return new ArrayList<String>();
    }
}

