/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.apimgmt.apiservice;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.lang.Assert;
import com.digiwin.athena.apimgmt.dao.ApiMgmtProjectDao;
import com.digiwin.athena.apimgmt.dao.ApiMgmtProjectVersionDao;
import com.digiwin.athena.apimgmt.dao.ApiMgmtProjectVersionRelationDao;
import com.digiwin.athena.apimgmt.dto.ApiBindProjectVersionReqDto;
import com.digiwin.athena.apimgmt.dto.PageReqCondition;
import com.digiwin.athena.apimgmt.dto.Pagination;
import com.digiwin.athena.apimgmt.dto.ProjectDto;
import com.digiwin.athena.apimgmt.infra.context.ApiMgmtServiceContextHolder;
import com.digiwin.athena.apimgmt.model.Project;
import com.digiwin.athena.apimgmt.model.ProjectVersion;
import com.digiwin.athena.apimgmt.model.ProjectVersionRelation;
import com.digiwin.athena.apimgmt.model.StandardApi;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ApiMgmtProjectService {
    @Autowired
    private ApiMgmtProjectDao projectDao;
    @Autowired
    private ApiMgmtProjectVersionDao projectVersionDao;
    @Autowired
    private ApiMgmtProjectVersionRelationDao projectVersionRelationDao;

    public Long getProjectIdByCode(String projectCode) {
        Project project = this.projectDao.getByCode(projectCode);
        if (project != null) {
            return project.getProjectId();
        }
        return Project.DEFAULT_PROJECT;
    }

    public Pagination<ProjectDto> queryProjectPage(PageReqCondition<String> pageReqCondition) {
        Long count = this.projectDao.pageCount(pageReqCondition);
        List<Project> projects = this.projectDao.selectPageable(pageReqCondition);
        List<ProjectDto> res = projects.stream().map(ProjectDto::create).collect(Collectors.toList());
        List<Long> projectIds = projects.stream().map(Project::getProjectId).collect(Collectors.toList());
        List<ProjectVersion> pvs = this.projectVersionDao.selectByProjectIds(projectIds);
        Map<Long, List<ProjectVersion>> versionMap = pvs.stream().collect(Collectors.groupingBy(p -> p.getProjectId()));
        res.forEach(r -> r.setProjectVersionList((List)versionMap.get(r.getProjectId())));
        Pagination projectDtoPagination = Pagination.buildPagination(pageReqCondition, res, (Long)count);
        return projectDtoPagination;
    }

    public List<ProjectDto> queryProject() {
        List<Project> projects = this.projectDao.selectAll();
        ArrayList<ProjectDto> res = new ArrayList<ProjectDto>();
        Iterator<Project> iterator = projects.iterator();
        while (iterator.hasNext()) {
            Project next = iterator.next();
            if (!"Athena".equals(next.getProjectName())) continue;
            res.add(ProjectDto.create(next));
            iterator.remove();
            break;
        }
        res.addAll(projects.stream().map(ProjectDto::create).collect(Collectors.toList()));
        List<Long> projectIds = res.stream().map(Project::getProjectId).collect(Collectors.toList());
        if (!projectIds.isEmpty()) {
            Set<Long> existProjectIds = this.projectVersionDao.selectExistVersionProjectId(projectIds);
            for (ProjectDto re : res) {
                if (!existProjectIds.contains(re.getProjectId())) continue;
                re.setHasVersions(true);
            }
        }
        return res;
    }

    public List<ProjectVersion> queryProjectVersion(Long projectId) {
        List<ProjectVersion> projectVersions = this.projectVersionDao.selectByProjectIds(Arrays.asList(projectId));
        return projectVersions;
    }

    @Transactional(rollbackFor={Exception.class})
    public Boolean addProject(ProjectDto projectDto) throws Exception {
        Long count = this.projectDao.countByName(projectDto.getProjectName());
        Assert.isTrue((boolean)count.equals(0L), (String)"\u5df2\u7ecf\u5b58\u5728\u540c\u540d\u7684\u4ea7\u54c1", (Object[])new Object[0]);
        Project project = projectDto.createProject();
        String userId = ApiMgmtServiceContextHolder.getUserId();
        project.setCreateBy(userId);
        project.setEditBy(userId);
        Project newProject = this.projectDao.save(project);
        List<ProjectVersion> projectVersionList = projectDto.getProjectVersionList();
        if (CollUtil.isNotEmpty(projectVersionList)) {
            Set versionNameSet = projectVersionList.stream().map(ProjectVersion::getProjectVersionName).collect(Collectors.toSet());
            Assert.isTrue((versionNameSet.size() == projectVersionList.size() ? 1 : 0) != 0, (String)"\u7248\u672c\u540d\u79f0\u5b58\u5728\u91cd\u590d", (Object[])new Object[0]);
            projectVersionList.forEach(p -> p.setProjectId(newProject.getProjectId()));
            this.projectVersionDao.batchSave(projectVersionList);
        }
        return true;
    }

    @Transactional(rollbackFor={Exception.class})
    public Boolean deleteProject(Long projectId) {
        Long count = this.projectVersionRelationDao.countByProjectId(projectId);
        Assert.isTrue((boolean)count.equals(0L), (String)"\u8be5\u4ea7\u54c1\u6709\u5173\u8054\u7684api\u4e0d\u80fd\u5220\u9664", (Object[])new Object[0]);
        this.projectDao.deleteById(projectId);
        this.projectVersionDao.deleteByProjectId(projectId);
        return true;
    }

    @Transactional(rollbackFor={Exception.class})
    public Boolean updateProject(ProjectDto projectDto) throws Exception {
        Project project = this.projectDao.selectById(projectDto.getProjectId());
        Assert.notNull((Object)project, (String)"\u4ea7\u54c1\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        if (!project.getProjectName().equals(projectDto.getProjectName())) {
            Long count = this.projectDao.countByName(projectDto.getProjectName());
            Assert.isTrue((boolean)count.equals(0L), (String)"\u5df2\u7ecf\u5b58\u5728\u540c\u540d\u7684\u4ea7\u54c1", (Object[])new Object[0]);
            project.setProjectName(projectDto.getProjectName());
        }
        project.setProjectRemark(projectDto.getProjectRemark());
        project.setProjectDesc(projectDto.getProjectDesc());
        project.setEditTime(new Date());
        project.setEditBy(ApiMgmtServiceContextHolder.getUserId());
        this.projectDao.save(project);
        List<ProjectVersion> oldProjectVersions = this.projectVersionDao.selectByProjectIds(Arrays.asList(project.getProjectId()));
        ArrayList<ProjectVersion> newVersionList = new ArrayList<ProjectVersion>();
        ArrayList<ProjectVersion> deleteVersionList = new ArrayList<ProjectVersion>();
        ArrayList<ProjectVersion> updateVersionList = new ArrayList<ProjectVersion>();
        List<ProjectVersion> projectVersionList = projectDto.getProjectVersionList();
        if (CollUtil.isEmpty(projectVersionList)) {
            deleteVersionList.addAll(oldProjectVersions);
        } else {
            Set versionNameSet = projectVersionList.stream().map(ProjectVersion::getProjectVersionName).collect(Collectors.toSet());
            Assert.isTrue((versionNameSet.size() == projectVersionList.size() ? 1 : 0) != 0, (String)"\u7248\u672c\u540d\u79f0\u5b58\u5728\u91cd\u590d", (Object[])new Object[0]);
            if (oldProjectVersions.isEmpty()) {
                newVersionList.addAll(projectVersionList);
            } else {
                Set reqVersionIds = projectVersionList.stream().map(ProjectVersion::getProjectVersionId).collect(Collectors.toSet());
                HashMap<Long, ProjectVersion> oldVersionMap = new HashMap<Long, ProjectVersion>();
                for (ProjectVersion oldProjectVersion : oldProjectVersions) {
                    oldVersionMap.put(oldProjectVersion.getProjectVersionId(), oldProjectVersion);
                }
                for (ProjectVersion projectVersion : oldProjectVersions) {
                    if (reqVersionIds.contains(projectVersion.getProjectVersionId())) continue;
                    deleteVersionList.add(projectVersion);
                }
                for (ProjectVersion projectVersion : projectVersionList) {
                    if (oldVersionMap.containsKey(projectVersion.getProjectVersionId())) {
                        ProjectVersion pv = (ProjectVersion)oldVersionMap.get(projectVersion.getProjectVersionId());
                        pv.setProjectVersionName(projectVersion.getProjectVersionName());
                        pv.setRemark(projectVersion.getRemark());
                        updateVersionList.add(pv);
                        continue;
                    }
                    newVersionList.add(projectVersion);
                }
            }
        }
        if (!deleteVersionList.isEmpty()) {
            List<Long> projectVersionIds = deleteVersionList.stream().map(ProjectVersion::getProjectVersionId).collect(Collectors.toList());
            Long count = this.projectVersionRelationDao.countByProjectVersionId(projectVersionIds);
            Assert.isTrue((boolean)count.equals(0L), (String)"\u5220\u9664\u7684\u7248\u672c\u6709\u5173\u8054\u7684api\uff0c\u65e0\u6cd5\u5220\u9664", (Object[])new Object[0]);
            this.projectVersionDao.deleteByIds(projectVersionIds);
        }
        if (!updateVersionList.isEmpty()) {
            this.projectVersionDao.batchUpdate(updateVersionList);
        }
        if (!newVersionList.isEmpty()) {
            this.projectVersionDao.batchSave(newVersionList);
        }
        return true;
    }

    @Transactional(rollbackFor={Exception.class})
    public Boolean apiBindProjectVersion(ApiBindProjectVersionReqDto apiBindProjectVersionReqDto) throws Exception {
        List<Long> apiIds = apiBindProjectVersionReqDto.getApiIds();
        Long projectId = apiBindProjectVersionReqDto.getProjectId();
        List<Long> projectVersionIds = apiBindProjectVersionReqDto.getProjectVersionIds();
        for (Long apiId : apiIds) {
            List<ProjectVersionRelation> relations = this.projectVersionRelationDao.selectByApiId(apiId);
            if (!relations.isEmpty()) {
                this.projectVersionRelationDao.deleteByApiId(apiId);
            }
            String userId = ApiMgmtServiceContextHolder.getUserId();
            if (CollUtil.isEmpty(projectVersionIds)) {
                ProjectVersionRelation projectVersionRelation = new ProjectVersionRelation();
                projectVersionRelation.setProjectId(projectId);
                StandardApi standardApi = new StandardApi();
                standardApi.setId(apiId);
                projectVersionRelation.setStandardApi(standardApi);
                projectVersionRelation.setCreatedTime(new Date());
                projectVersionRelation.setCreatedBy(userId);
                this.projectVersionRelationDao.save(projectVersionRelation);
                continue;
            }
            List<ProjectVersionRelation> newProjectVersionList = projectVersionIds.stream().map(p -> {
                ProjectVersionRelation projectVersionRelation = new ProjectVersionRelation();
                projectVersionRelation.setProjectVersionId((Long)p);
                projectVersionRelation.setProjectId(projectId);
                projectVersionRelation.setCreatedTime(new Date());
                projectVersionRelation.setCreatedBy(userId);
                StandardApi standardApi = new StandardApi();
                standardApi.setId(apiId);
                projectVersionRelation.setStandardApi(standardApi);
                return projectVersionRelation;
            }).collect(Collectors.toList());
            this.projectVersionRelationDao.batchSave(newProjectVersionList);
        }
        return true;
    }

    public ProjectDto getProjectDetail(Long projectId) {
        Project project = this.projectDao.selectById(projectId);
        Assert.notNull((Object)project, (String)"\u672a\u67e5\u8be2\u5230\u4ea7\u54c1", (Object[])new Object[0]);
        ProjectDto projectDto = ProjectDto.create(project);
        List<ProjectVersion> projectVersions = this.projectVersionDao.getByProjectId(projectId);
        projectDto.setProjectVersionList(projectVersions);
        return projectDto;
    }
}

