/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.apimgmt.apiservice;

import cn.hutool.core.date.DateUtil;
import com.digiwin.athena.apimgmt.dao.ApiMgmtStandardApiVersionDao;
import com.digiwin.athena.apimgmt.dao.ApiMgmtTenantConfigDao;
import com.digiwin.athena.apimgmt.enums.ApiAttributeEnum;
import com.digiwin.athena.apimgmt.enums.LocaleEnum;
import com.digiwin.athena.apimgmt.infra.context.ApiMgmtServiceContextHolder;
import com.digiwin.athena.apimgmt.model.StandardApi;
import com.digiwin.athena.apimgmt.model.StandardApiVersion;
import com.digiwin.athena.apimgmt.service.util.ApiVersionServiceUtil;
import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jackson.JsonLoader;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@Deprecated
public class ApiListGetService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ApiListGetService.class);
    @Autowired
    ApiMgmtStandardApiVersionDao standardApiVersionDao;
    @Autowired
    ApiMgmtTenantConfigDao tenantConfigDao;

    public ArrayList<Map<String, Object>> execute(String validatorResult) throws Exception {
        log.info("[Thread.id " + Thread.currentThread().getId() + "]\u63a5\u53e3\uff1a" + this.getClass() + "\uff0c\u539f\u59cb\u8a0a\u606f\uff1a" + validatorResult);
        String tLocale = ApiMgmtServiceContextHolder.getLocale();
        tLocale = tLocale == null ? LocaleEnum.EN_US.getType() : tLocale;
        String tTenantId = ApiMgmtServiceContextHolder.getTenantId();
        String teamType = ApiMgmtServiceContextHolder.getTeamType();
        ArrayList<Map<String, Object>> tResponse = new ArrayList<Map<String, Object>>();
        JsonNode tRequestJsonNode = JsonLoader.fromString((String)validatorResult);
        String tReqCategory = tRequestJsonNode.get("categoryId").asText();
        boolean tViewAllApi = this.tenantConfigDao.viewAllApiTenantExist(tTenantId);
        List<StandardApiVersion> tStandardApiVersionList = this.standardApiVersionDao.getByCategory(Long.valueOf(tReqCategory), tTenantId, teamType, tViewAllApi);
        HashMap tApiVersionMap = new HashMap();
        for (StandardApiVersion tStandardApiVersion : tStandardApiVersionList) {
            StandardApi api = tStandardApiVersion.getStandardApi();
            String tApiKey = api.getId() + "_" + api.getName();
            if (tApiVersionMap.get(tApiKey) == null) {
                ArrayList<StandardApiVersion> tStandardApiVersionFromApiName = new ArrayList<StandardApiVersion>();
                tStandardApiVersionFromApiName.add(tStandardApiVersion);
                tApiVersionMap.put(tApiKey, tStandardApiVersionFromApiName);
                continue;
            }
            ((List)tApiVersionMap.get(tApiKey)).add(tStandardApiVersion);
        }
        for (String tKey : tApiVersionMap.keySet()) {
            String tCategory;
            String tSyncType;
            String tRemark;
            String tDescription;
            String tApprovedStatus;
            List pStandardApiVersions = (List)tApiVersionMap.get(tKey);
            StandardApiVersion firstStandardApiVersion = ApiVersionServiceUtil.getFirstVersion(pStandardApiVersions);
            StandardApiVersion tStandardApiVersion = ApiVersionServiceUtil.getLatestVersion(pStandardApiVersions);
            StandardApi tStandardApi = tStandardApiVersion.getStandardApi();
            HashMap<String, Object> tApiMap = new HashMap<String, Object>();
            switch (tLocale) {
                case "zh_CN": {
                    tApprovedStatus = tStandardApiVersion.getApprovedStatus().getNameZhCn();
                    tDescription = tStandardApi.getDescriptionZhCn();
                    tRemark = tStandardApi.getRemarkZhCn();
                    tSyncType = tStandardApi.getStandardApiSyncType().getNameZhCn();
                    tCategory = tStandardApi.getStandardApiCategory().getNameZhCn();
                    break;
                }
                case "zh_TW": {
                    tApprovedStatus = tStandardApiVersion.getApprovedStatus().getNameZhTw();
                    tDescription = tStandardApi.getDescriptionZhTw();
                    tRemark = tStandardApi.getRemarkZhTw();
                    tSyncType = tStandardApi.getStandardApiSyncType().getNameZhTw();
                    tCategory = tStandardApi.getStandardApiCategory().getNameZhTw();
                    break;
                }
                default: {
                    tApprovedStatus = tStandardApiVersion.getApprovedStatus().getNameEnUs();
                    tDescription = tStandardApi.getDescriptionEnUs();
                    tRemark = tStandardApi.getRemarkEnUs();
                    tSyncType = tStandardApi.getStandardApiSyncType().getNameEnUs();
                    tCategory = tStandardApi.getStandardApiCategory().getNameEnUs();
                }
            }
            tApiMap.put("apiId", tStandardApi.getId());
            tApiMap.put("name", tStandardApi.getName());
            tApiMap.put("version", tStandardApiVersion.getVersion());
            tApiMap.put("approvedStatus", tApprovedStatus);
            tApiMap.put(ApiAttributeEnum.approvedTime.toString(), DateUtil.formatLocalDateTime((LocalDateTime)tStandardApiVersion.getApprovedTime()));
            tApiMap.put("description", tDescription);
            tApiMap.put("remark", tRemark);
            tApiMap.put("syncType", tSyncType);
            tApiMap.put("categoryId", tStandardApi.getStandardApiCategory().getId());
            tApiMap.put("categoryName", tCategory);
            tApiMap.put("msgFormat", tStandardApi.getMsgFormat());
            tApiMap.put("provider", tStandardApi.getProvider());
            tApiMap.put("tenantId", tStandardApi.getTenantId());
            String firstV = firstStandardApiVersion.getVersion();
            String lastV = tStandardApiVersion.getVersion();
            tApiMap.put("firstApplicant", firstStandardApiVersion.getApplicant());
            if (firstV.equals(lastV)) {
                tApiMap.put("lastApplicant", "");
            } else {
                tApiMap.put("lastApplicant", tStandardApiVersion.getApplicant());
            }
            tApiMap.put("designTenantId", tStandardApiVersion.getStandardApi().getDesignTenantId());
            tApiMap.put("teamId", tStandardApiVersion.getStandardApi().getTeamId());
            tResponse.add(tApiMap);
        }
        return tResponse;
    }
}

