package com.digiwin.athena.apimgmt.util;

import cn.afterturn.easypoi.excel.ExcelImportUtil;
import cn.afterturn.easypoi.excel.entity.ImportParams;
import cn.afterturn.easypoi.excel.entity.result.ExcelImportResult;
import com.digiwin.athena.apimgmt.common.model.dto.FileDto;
import jakarta.servlet.http.HttpServletResponse;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.NoSuchElementException;

/**
 * excel 工具类
 */
public class ExcelUtil {

    public static void setHeader(HttpServletResponse response, String exportFileName) {
        response.setHeader("content-type", "application/octet-stream");
        response.setContentType("application/octet-stream");
        response.setCharacterEncoding("utf-8");
        // 下载文件能正常显示中文
        try {
            response.setHeader("Content-Disposition", "attachment;filename=" + URLEncoder.encode(exportFileName, "UTF-8") + ".xlsx");
        } catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
    }

    /**
     * 导入Excel
     *
     * @param file         excel文件
     */
    public static <T> ExcelImportResult<T> importExcel(FileDto file, ImportParams params, Class<T> pojoClass) {
        if (file == null) {
            return null;
        }
        ExcelImportResult<T> result;
        try {
            result = ExcelImportUtil.importExcelMore(file.getInputStream(), pojoClass, params);
        } catch (NoSuchElementException e) {
            throw new RuntimeException("excel文件不能为空！");
        } catch (NumberFormatException e) {
            throw new RuntimeException("excel文件单元格，" + e.getMessage());
        } catch (IllegalArgumentException e) {
            e.printStackTrace();
            throw new RuntimeException("excel文件单元格" + e.getMessage().replace("Invalid CellReference: ", "") + "格式异常！");
        } catch (InvalidFormatException e) {
            throw new RuntimeException("请使用正确未加密模板导入！");
        } catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessage());
        }
        return result;
    }

}
