package com.digiwin.athena.apimgmt.dao;

import com.digiwin.athena.apimgmt.facade.dto.ApiMgmtApiInfoDTO;
import com.digiwin.athena.apimgmt.facade.dto.ApiMgmtApiKeyDTO;
import com.digiwin.athena.apimgmt.model.AdvanceSearchValue;
import com.digiwin.athena.apimgmt.model.StandardApi;
import com.digiwin.athena.apimgmt.model.StandardApiVersion;
import com.digiwin.athena.apimgmt.service.model.Page;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public interface ApiMgmtStandardApiDao extends GenericDao<StandardApi, Long> {

    /**
     * 查询API
     *
     * @param pConditionList 条件
     * @param teamType       teamType
     * @param searchType     searchType
     * @return list
     */
    List<StandardApi> advanceSearch(ArrayList<Map<String, String>> pConditionList, String teamType, boolean searchType, boolean tViewAllApi);

    List<StandardApi> getByNameAndTenantId(String pName, String pTenantId);

    List<StandardApi> getListByNameAndBranchAndTenantId(String pName, String branch, String pTenantId);

    StandardApi getByNameAndBranchAndTenantId(String pName, String branch, String pTenantId);

    /**
     * 设计api查询
     *
     * @param pList       pList
     * @param teamType    teamType
     * @param tenantId    tenantId
     * @param searchType  searchType
     * @param tViewAllApi tViewAllApi
     * @return Page<StandardApiVersion>
     */
    Page<StandardApiVersion> advanceApiSearch(List<List<AdvanceSearchValue>> pList, String teamType,
                                              String tenantId, boolean searchType, boolean tViewAllApi, Integer pageSize, Integer pageNum);

    Page<StandardApiVersion> advanceApiSearch(List<List<AdvanceSearchValue>> pList, String teamType,
                                              String tenantId, boolean searchType, boolean tViewAllApi,
                                              Integer pageNum, Integer pageSize, boolean queryDataName);

    /**
     * 标准api总数查询
     *
     * @param pList     pList
     * @param teamType  teamType
     * @param pTenantId pTenantId
     * @return list
     */
    List<Long> advanceStandardApiCountSearch(List<List<AdvanceSearchValue>> pList, String teamType, String pTenantId, boolean tViewAllApi);

    /**
     * 保存
     *
     * @param pStandardApi         api
     * @param cleanProjectRelation 保存前删除projectRelation
     * @return po
     */
    StandardApi save(StandardApi pStandardApi, boolean cleanProjectRelation);

    /**
     * 删除API
     * @param pId pId
     */
    void delete(Long pId);

    void fillApi(List<StandardApiVersion> versions);

    List<ApiMgmtApiInfoDTO> queryByKey(List<ApiMgmtApiKeyDTO> apiKeys);
}
