/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.apimgmt.apiservice;

import com.digiwin.athena.apimgmt.ApiMgmtApplicationParameter;
import com.digiwin.athena.apimgmt.apiservice.AbstractApiService;
import com.digiwin.athena.apimgmt.dao.ApiMgmtProjectVersionRelationDao;
import com.digiwin.athena.apimgmt.dao.ApiMgmtStandardApiVersionDao;
import com.digiwin.athena.apimgmt.enums.ApiAttributeEnum;
import com.digiwin.athena.apimgmt.enums.ValidateStateEnum;
import com.digiwin.athena.apimgmt.model.ProjectVersionRelation;
import com.digiwin.athena.apimgmt.model.StandardApiVersion;
import com.digiwin.athena.apimgmt.model.StateCode;
import com.digiwin.athena.apimgmt.service.util.DmcFileServiceUtil;
import com.digiwin.athena.apimgmt.service.util.StandardApiExportServiceUtil;
import com.digiwin.athena.apimgmt.validator.ValidatorResult;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ApiSpecFileGetService
extends AbstractApiService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ApiSpecFileGetService.class);
    @Autowired
    ApiMgmtStandardApiVersionDao standardApiVersionDao;
    @Autowired
    ApiMgmtProjectVersionRelationDao projectVersionRelationDao;

    public ApiSpecFileGetService() {
        this.jsonSchemaFileName = "api_spec_file_get_schema.json";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Map<String, Object> processData(ValidatorResult validatorResult) throws Exception {
        JsonNode tRequestJsonNode = validatorResult.getJsonContent();
        ObjectNode tResponseNode = this.mapper.createObjectNode();
        String tApiName = tRequestJsonNode.get(ApiAttributeEnum.apiName.toString()).asText();
        String tVersion = null;
        String tTenant = "";
        if (tRequestJsonNode.get(ApiAttributeEnum.apiVersion.toString()) != null) {
            tVersion = tRequestJsonNode.get(ApiAttributeEnum.apiVersion.toString()).asText();
        }
        if (tRequestJsonNode.get(ApiAttributeEnum.tenantId.toString()) != null) {
            tTenant = tRequestJsonNode.get(ApiAttributeEnum.tenantId.toString()).asText();
        }
        StateCode tStateCode = this.getStateCode(validatorResult.getState().getCode());
        String tDescription = tStateCode.getDescription();
        if (tApiName.equals(ApiAttributeEnum.template.toString())) {
            String tNewFilePath = StandardApiExportServiceUtil.getTemplate();
            DmcFileServiceUtil.uploadFileAndGenerateDownloadLink(tResponseNode, tNewFilePath, ApiMgmtApplicationParameter._TEMPLATE_FILE_NAME, false, 0);
        } else {
            HashMap<String, String> tConditions = new HashMap<String, String>();
            tConditions.put(ApiAttributeEnum.apiName.toString(), tApiName);
            tConditions.put(ApiAttributeEnum.version.toString(), tVersion);
            tConditions.put(ApiAttributeEnum.tenantId.toString(), tTenant);
            StandardApiVersion tStandardApiVersion = this.standardApiVersionDao.fetchApiVersion(tConditions);
            if (tStandardApiVersion != null) {
                if (tStandardApiVersion.getStandardApi() != null) {
                    List<ProjectVersionRelation> projectVersionRelationList = this.projectVersionRelationDao.getByApiId(tStandardApiVersion.getStandardApi().getId());
                    tStandardApiVersion.getStandardApi().setProjectVersionRelations(projectVersionRelationList);
                    String tNewFilePath = null;
                    try {
                        tNewFilePath = StandardApiExportServiceUtil.exportStandardApi(tStandardApiVersion);
                        String tNewFileName = StandardApiExportServiceUtil.getFileName(tNewFilePath);
                        DmcFileServiceUtil.uploadFileAndGenerateDownloadLink(tResponseNode, tNewFilePath, tNewFileName, false, 0);
                    }
                    catch (Exception e) {
                        log.error(e.getMessage(), (Throwable)e);
                    }
                    finally {
                        boolean b = StandardApiExportServiceUtil.removeFile(tNewFilePath);
                        log.info("\u5bfc\u51fa\u6587\u4ef6\u5220\u9664:{}" + b);
                    }
                }
            } else {
                tStateCode = this.getStateCode(ValidateStateEnum.API_NAME_VER_NOTFOUND.getCode());
                tDescription = tStateCode.getDescription();
            }
        }
        ObjectNode tResponseJsonNode = this.createResponseJsonNode(tStateCode.getCode(), tDescription, tResponseNode);
        return this.converJsonNodeToMap((JsonNode)tResponseJsonNode);
    }
}

