/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.apimgmt.apiservice;

import cn.hutool.core.date.DateUtil;
import com.digiwin.athena.apimgmt.dao.ApiMgmtStandardApiDao;
import com.digiwin.athena.apimgmt.dao.ApiMgmtStandardApiVersionDao;
import com.digiwin.athena.apimgmt.enums.ApiAttributeEnum;
import com.digiwin.athena.apimgmt.enums.LocaleEnum;
import com.digiwin.athena.apimgmt.infra.context.ApiMgmtServiceContextHolder;
import com.digiwin.athena.apimgmt.model.StandardApi;
import com.digiwin.athena.apimgmt.model.StandardApiVersion;
import com.digiwin.athena.apimgmt.util.StringUtil;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.github.fge.jackson.JsonLoader;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@Deprecated
public class ApiDesignAdvanceSearchListGetService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ApiDesignAdvanceSearchListGetService.class);
    @Autowired
    ApiMgmtStandardApiDao standardApiDao;
    @Autowired
    ApiMgmtStandardApiVersionDao standardApiVersionDao;

    public ArrayList<Map<String, Object>> execute(String validatorResult) throws Exception {
        List<StandardApi> tStandardApiList;
        log.info("[Thread.id " + Thread.currentThread().getId() + "]\u63a5\u53e3\uff1a" + this.getClass() + "\uff0c\u539f\u59cb\u8a0a\u606f\uff1a" + validatorResult);
        String tLocale = ApiMgmtServiceContextHolder.getLocale();
        tLocale = tLocale == null ? LocaleEnum.EN_US.getType() : tLocale;
        String teamType = ApiMgmtServiceContextHolder.getTeamType();
        String tTenant = ApiMgmtServiceContextHolder.getTenantId();
        String tUserId = ApiMgmtServiceContextHolder.getUserId();
        ArrayList<Map<String, Object>> tResponse = new ArrayList<Map<String, Object>>();
        JsonNode tRequestJsonNode = JsonLoader.fromString((String)validatorResult);
        ArrayNode tConditionArrayNode = (ArrayNode)tRequestJsonNode.get("conditionList");
        boolean tIsVerifyAcct = false;
        if (!StringUtil.isEmptyOrSpace((Object)tRequestJsonNode.get("verifyAcct").asText())) {
            tIsVerifyAcct = true;
        }
        ArrayList<Map<String, String>> tConditionList = new ArrayList<Map<String, String>>();
        String tProvider = null;
        String tStatus = null;
        HashMap<String, String> tTenantIdCondition = new HashMap<String, String>();
        tTenantIdCondition.put("tenant", tTenant);
        tConditionList.add(tTenantIdCondition);
        HashMap<String, String> tUserIdCondition = new HashMap<String, String>();
        if (tIsVerifyAcct) {
            tUserId = null;
        } else {
            tUserIdCondition.put("userId", tUserId);
            tConditionList.add(tUserIdCondition);
        }
        if (tConditionArrayNode.isArray()) {
            for (JsonNode tConditionNode : tConditionArrayNode) {
                String tCondition;
                HashMap<String, String> tConditionMap = new HashMap<String, String>();
                switch (tCondition = tConditionNode.get("condition").asText()) {
                    case "apiName": {
                        tConditionMap.put("apiName", tConditionNode.get("content").asText());
                        tConditionMap.put("apiName_eq", tConditionNode.get("equation").asText());
                        break;
                    }
                    case "apiTag": {
                        tConditionMap.put("apiTag", tConditionNode.get("content").asText());
                        tConditionMap.put("apiTag_eq", tConditionNode.get("equation").asText());
                        break;
                    }
                    case "apiDataName": {
                        tConditionMap.put("apiDataName", tConditionNode.get("content").asText());
                        tConditionMap.put("apiDataName_eq", tConditionNode.get("equation").asText());
                        break;
                    }
                    case "apiDescription": {
                        tConditionMap.put("apiDescription", tConditionNode.get("content").asText());
                        tConditionMap.put("apiDescription_eq", tConditionNode.get("equation").asText());
                        break;
                    }
                    case "apiRemark": {
                        tConditionMap.put("apiRemark", tConditionNode.get("content").asText());
                        tConditionMap.put("apiRemark_eq", tConditionNode.get("equation").asText());
                        break;
                    }
                    case "apiSyncType": {
                        tConditionMap.put("apiSyncType", tConditionNode.get("content").asText());
                        break;
                    }
                    case "apiCategory": {
                        tConditionMap.put("apiCategory", tConditionNode.get("content").asText());
                        break;
                    }
                    case "provider": {
                        tProvider = tConditionNode.get("content").asText();
                        tConditionMap.put("provider", tConditionNode.get("content").asText());
                        break;
                    }
                    case "apiStatus": {
                        tStatus = tConditionNode.get("content").asText();
                        tConditionMap.put("apiStatus", tConditionNode.get("content").asText());
                        break;
                    }
                    case "tenantId": {
                        tConditionMap.put("tenantId", tConditionNode.get("content").asText());
                        tConditionMap.put("tenantId_eq", tConditionNode.get("equation").asText());
                        break;
                    }
                    default: {
                        log.info("\u8f93\u5165\u6761\u4ef6\u4e0d\u6210\u7acb!");
                    }
                }
                tConditionList.add(tConditionMap);
            }
        }
        if ((tStandardApiList = this.standardApiDao.advanceSearch(tConditionList, teamType, true, false)) != null) {
            for (StandardApi tStandardApi : tStandardApiList) {
                boolean tProviderBoolean = false;
                if (tProvider != null) {
                    String[] tProviderArr;
                    String tProviders = tStandardApi.getProvider().trim();
                    for (String s : tProviderArr = tProviders.split(",")) {
                        if (!s.trim().equals(tProvider)) continue;
                        tProviderBoolean = true;
                        break;
                    }
                } else {
                    tProviderBoolean = true;
                }
                if (!tProviderBoolean) continue;
                List<StandardApiVersion> tStandardApiVersions = this.standardApiVersionDao.getVersionByApiId(tStandardApi.getId(), tUserId, tStatus);
                for (StandardApiVersion tStandardApiVersion : tStandardApiVersions) {
                    String tCategory;
                    String tSyncType;
                    String tRemark;
                    String tDescription;
                    long tApprovedStatusCode;
                    String tApprovedStatus;
                    HashMap<String, Object> tApiMap = new HashMap<String, Object>();
                    switch (tLocale) {
                        case "zh_CN": {
                            tApprovedStatus = tStandardApiVersion.getApprovedStatus().getNameZhCn();
                            tApprovedStatusCode = tStandardApiVersion.getApprovedStatus().getId();
                            tDescription = tStandardApi.getDescriptionZhCn();
                            tRemark = tStandardApi.getRemarkZhCn();
                            tSyncType = tStandardApi.getStandardApiSyncType().getNameZhCn();
                            tCategory = tStandardApi.getStandardApiCategory().getNameZhCn();
                            break;
                        }
                        case "zh_TW": {
                            tApprovedStatus = tStandardApiVersion.getApprovedStatus().getNameZhTw();
                            tApprovedStatusCode = tStandardApiVersion.getApprovedStatus().getId();
                            tDescription = tStandardApi.getDescriptionZhTw();
                            tRemark = tStandardApi.getRemarkZhTw();
                            tSyncType = tStandardApi.getStandardApiSyncType().getNameZhTw();
                            tCategory = tStandardApi.getStandardApiCategory().getNameZhTw();
                            break;
                        }
                        default: {
                            tApprovedStatus = tStandardApiVersion.getApprovedStatus().getNameEnUs();
                            tApprovedStatusCode = tStandardApiVersion.getApprovedStatus().getId();
                            tDescription = tStandardApi.getDescriptionEnUs();
                            tRemark = tStandardApi.getRemarkEnUs();
                            tSyncType = tStandardApi.getStandardApiSyncType().getNameEnUs();
                            tCategory = tStandardApi.getStandardApiCategory().getNameEnUs();
                        }
                    }
                    tApiMap.put("name", tStandardApi.getName());
                    tApiMap.put("version", tStandardApiVersion.getVersion());
                    tApiMap.put("approvedStatus", tApprovedStatus);
                    tApiMap.put("approvedStatusCode", tApprovedStatusCode);
                    tApiMap.put(ApiAttributeEnum.approvedTime.toString(), DateUtil.formatLocalDateTime((LocalDateTime)tStandardApiVersion.getApprovedTime()));
                    tApiMap.put("description", tDescription);
                    tApiMap.put("remark", tRemark);
                    tApiMap.put("syncType", tSyncType);
                    tApiMap.put("categoryId", tStandardApi.getStandardApiCategory().getId());
                    tApiMap.put("categoryName", tCategory);
                    tApiMap.put("msgFormat", tStandardApi.getMsgFormat());
                    tApiMap.put("provider", tStandardApi.getProvider());
                    tApiMap.put("tenantId", tStandardApi.getTenantId());
                    tApiMap.put("statusId", tStandardApiVersion.getApprovedStatus().getId());
                    tResponse.add(tApiMap);
                }
            }
        }
        return tResponse;
    }
}

