/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.apimgmt.apiservice;

import cn.hutool.core.collection.CollUtil;
import com.digiwin.athena.apimgmt.annotate.OperateAuthorityVerify;
import com.digiwin.athena.apimgmt.apiservice.AbstractApiService;
import com.digiwin.athena.apimgmt.dao.ApiMgmtStandardApiDao;
import com.digiwin.athena.apimgmt.exception.BaseException;
import com.digiwin.athena.apimgmt.model.StandardApi;
import com.digiwin.athena.apimgmt.validator.ValidatorResult;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@OperateAuthorityVerify
public class DeleteApiService
extends AbstractApiService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DeleteApiService.class);
    @Autowired
    ApiMgmtStandardApiDao standardApiDao;

    public DeleteApiService() {
        this.jsonSchemaFileName = "delete_api_schema.json";
    }

    @Override
    protected Map<String, Object> processData(ValidatorResult validatorResult) throws BaseException, Exception {
        JsonNode tRequestJsonNode = validatorResult.getJsonContent();
        ArrayNode tApiArrayNode = (ArrayNode)tRequestJsonNode.get("apiList");
        for (JsonNode tApiNode : tApiArrayNode) {
            String tApiName = tApiNode.asText();
            List<StandardApi> standardApiList = this.standardApiDao.getByNameAndTenantId(tApiName, null);
            if (!CollUtil.isNotEmpty(standardApiList)) continue;
            log.info(tApiName + ": \u67e5\u8be2\u6570\u636e\u7684\u6761\u6570: " + standardApiList.size());
            for (StandardApi standardApi : standardApiList) {
                this.standardApiDao.delete(standardApi.getId());
            }
        }
        HashMap<String, Object> tResponse = new HashMap<String, Object>();
        tResponse.put("code", "000");
        tResponse.put("result", "success");
        return tResponse;
    }
}

