/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.apimgmt.dto;

import cn.hutool.core.date.DateUtil;
import com.digiwin.athena.apimgmt.infra.context.ApiMgmtServiceContextHolder;
import com.digiwin.athena.apimgmt.model.ApprovedStatus;
import com.digiwin.athena.apimgmt.model.StandardApi;
import com.digiwin.athena.apimgmt.model.StandardApiCategory;
import com.digiwin.athena.apimgmt.model.StandardApiSyncType;
import com.digiwin.athena.apimgmt.model.StandardApiVersion;
import java.time.LocalDateTime;
import java.util.List;
import lombok.Generated;
import org.springframework.beans.BeanUtils;

public class ApiInfoResDto {
    private Long apiId;
    private String name;
    private String branch;
    private String version;
    private String approvedStatus;
    private String approvedTime;
    private Integer approvedStatusCode;
    private String description;
    private String remark;
    private String syncType;
    private Integer categoryId;
    private String categoryName;
    private String msgFormat;
    private String requester;
    private String provider;
    private String tenantId;
    private String apiBuildAcct;
    private String apiBuildTime;
    private String designTenantId;
    private String teamId;
    private Integer statusId;
    private String apiType;
    private String projectName;
    private Boolean hasVersions;
    private List<String> projectVersionNameList;
    private String projectVersionNameListStr;

    public static ApiInfoResDto create(StandardApiVersion standardApiVersion, StandardApi standardApi, ApprovedStatus approvedStatus, StandardApiCategory standardApiCategory, StandardApiSyncType standardApiSyncType) {
        String tLocale;
        ApiInfoResDto apiInfoResDto = new ApiInfoResDto();
        BeanUtils.copyProperties((Object)standardApiVersion, (Object)apiInfoResDto, (String[])new String[]{"approvedTime"});
        apiInfoResDto.name = standardApi.getName();
        apiInfoResDto.branch = standardApi.getBranch();
        apiInfoResDto.approvedTime = DateUtil.formatLocalDateTime((LocalDateTime)standardApiVersion.getApprovedTime());
        apiInfoResDto.categoryId = standardApi.getCategory().intValue();
        apiInfoResDto.setMsgFormat(standardApi.getMsgFormat());
        apiInfoResDto.requester = standardApi.getRequester();
        apiInfoResDto.provider = standardApi.getProvider();
        apiInfoResDto.tenantId = standardApi.getTenantId();
        apiInfoResDto.apiBuildAcct = standardApi.getBuildAcct();
        apiInfoResDto.apiBuildTime = DateUtil.formatLocalDateTime((LocalDateTime)standardApi.getBuildTime());
        apiInfoResDto.designTenantId = standardApi.getDesignTenantId();
        apiInfoResDto.teamId = standardApi.getTeamId();
        apiInfoResDto.statusId = approvedStatus.getId().intValue();
        apiInfoResDto.apiType = standardApi.getApiType();
        apiInfoResDto.projectName = standardApi.getProjectName();
        apiInfoResDto.hasVersions = standardApi.getHasVersions();
        if (standardApi.getProjectVersionNameList() != null) {
            apiInfoResDto.setProjectVersionNameList(standardApi.getProjectVersionNameList());
            apiInfoResDto.setProjectVersionNameListStr(String.join((CharSequence)",", standardApi.getProjectVersionNameList()));
        }
        switch (tLocale = ApiMgmtServiceContextHolder.getLocale()) {
            case "zh_CN": {
                apiInfoResDto.setApprovedStatus(approvedStatus.getNameZhCn());
                apiInfoResDto.setApprovedStatusCode(approvedStatus.getId().intValue());
                apiInfoResDto.setDescription(standardApi.getDescriptionZhCn());
                apiInfoResDto.setRemark(standardApi.getRemarkZhCn());
                apiInfoResDto.setSyncType(standardApiSyncType.getNameZhCn());
                apiInfoResDto.setCategoryName(standardApiCategory.getNameZhCn());
                break;
            }
            case "zh_TW": {
                apiInfoResDto.setApprovedStatus(approvedStatus.getNameZhTw());
                apiInfoResDto.setApprovedStatusCode(approvedStatus.getId().intValue());
                apiInfoResDto.setDescription(standardApi.getDescriptionZhTw());
                apiInfoResDto.setRemark(standardApi.getRemarkZhTw());
                apiInfoResDto.setSyncType(standardApiSyncType.getNameZhTw());
                apiInfoResDto.setCategoryName(standardApiCategory.getNameZhTw());
                break;
            }
            default: {
                apiInfoResDto.setApprovedStatus(approvedStatus.getNameEnUs());
                apiInfoResDto.setApprovedStatusCode(approvedStatus.getId().intValue());
                apiInfoResDto.setDescription(standardApi.getDescriptionEnUs());
                apiInfoResDto.setRemark(standardApi.getRemarkEnUs());
                apiInfoResDto.setSyncType(standardApiSyncType.getNameEnUs());
                apiInfoResDto.setCategoryName(standardApiCategory.getNameEnUs());
            }
        }
        return apiInfoResDto;
    }

    @Generated
    public ApiInfoResDto() {
    }

    @Generated
    public Long getApiId() {
        return this.apiId;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getBranch() {
        return this.branch;
    }

    @Generated
    public String getVersion() {
        return this.version;
    }

    @Generated
    public String getApprovedStatus() {
        return this.approvedStatus;
    }

    @Generated
    public String getApprovedTime() {
        return this.approvedTime;
    }

    @Generated
    public Integer getApprovedStatusCode() {
        return this.approvedStatusCode;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public String getRemark() {
        return this.remark;
    }

    @Generated
    public String getSyncType() {
        return this.syncType;
    }

    @Generated
    public Integer getCategoryId() {
        return this.categoryId;
    }

    @Generated
    public String getCategoryName() {
        return this.categoryName;
    }

    @Generated
    public String getMsgFormat() {
        return this.msgFormat;
    }

    @Generated
    public String getRequester() {
        return this.requester;
    }

    @Generated
    public String getProvider() {
        return this.provider;
    }

    @Generated
    public String getTenantId() {
        return this.tenantId;
    }

    @Generated
    public String getApiBuildAcct() {
        return this.apiBuildAcct;
    }

    @Generated
    public String getApiBuildTime() {
        return this.apiBuildTime;
    }

    @Generated
    public String getDesignTenantId() {
        return this.designTenantId;
    }

    @Generated
    public String getTeamId() {
        return this.teamId;
    }

    @Generated
    public Integer getStatusId() {
        return this.statusId;
    }

    @Generated
    public String getApiType() {
        return this.apiType;
    }

    @Generated
    public String getProjectName() {
        return this.projectName;
    }

    @Generated
    public Boolean getHasVersions() {
        return this.hasVersions;
    }

    @Generated
    public List<String> getProjectVersionNameList() {
        return this.projectVersionNameList;
    }

    @Generated
    public String getProjectVersionNameListStr() {
        return this.projectVersionNameListStr;
    }

    @Generated
    public void setApiId(Long apiId) {
        this.apiId = apiId;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setBranch(String branch) {
        this.branch = branch;
    }

    @Generated
    public void setVersion(String version) {
        this.version = version;
    }

    @Generated
    public void setApprovedStatus(String approvedStatus) {
        this.approvedStatus = approvedStatus;
    }

    @Generated
    public void setApprovedTime(String approvedTime) {
        this.approvedTime = approvedTime;
    }

    @Generated
    public void setApprovedStatusCode(Integer approvedStatusCode) {
        this.approvedStatusCode = approvedStatusCode;
    }

    @Generated
    public void setDescription(String description) {
        this.description = description;
    }

    @Generated
    public void setRemark(String remark) {
        this.remark = remark;
    }

    @Generated
    public void setSyncType(String syncType) {
        this.syncType = syncType;
    }

    @Generated
    public void setCategoryId(Integer categoryId) {
        this.categoryId = categoryId;
    }

    @Generated
    public void setCategoryName(String categoryName) {
        this.categoryName = categoryName;
    }

    @Generated
    public void setMsgFormat(String msgFormat) {
        this.msgFormat = msgFormat;
    }

    @Generated
    public void setRequester(String requester) {
        this.requester = requester;
    }

    @Generated
    public void setProvider(String provider) {
        this.provider = provider;
    }

    @Generated
    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    @Generated
    public void setApiBuildAcct(String apiBuildAcct) {
        this.apiBuildAcct = apiBuildAcct;
    }

    @Generated
    public void setApiBuildTime(String apiBuildTime) {
        this.apiBuildTime = apiBuildTime;
    }

    @Generated
    public void setDesignTenantId(String designTenantId) {
        this.designTenantId = designTenantId;
    }

    @Generated
    public void setTeamId(String teamId) {
        this.teamId = teamId;
    }

    @Generated
    public void setStatusId(Integer statusId) {
        this.statusId = statusId;
    }

    @Generated
    public void setApiType(String apiType) {
        this.apiType = apiType;
    }

    @Generated
    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    @Generated
    public void setHasVersions(Boolean hasVersions) {
        this.hasVersions = hasVersions;
    }

    @Generated
    public void setProjectVersionNameList(List<String> projectVersionNameList) {
        this.projectVersionNameList = projectVersionNameList;
    }

    @Generated
    public void setProjectVersionNameListStr(String projectVersionNameListStr) {
        this.projectVersionNameListStr = projectVersionNameListStr;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ApiInfoResDto)) {
            return false;
        }
        ApiInfoResDto other = (ApiInfoResDto)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$apiId = this.getApiId();
        Long other$apiId = other.getApiId();
        if (this$apiId == null ? other$apiId != null : !((Object)this$apiId).equals(other$apiId)) {
            return false;
        }
        Integer this$approvedStatusCode = this.getApprovedStatusCode();
        Integer other$approvedStatusCode = other.getApprovedStatusCode();
        if (this$approvedStatusCode == null ? other$approvedStatusCode != null : !((Object)this$approvedStatusCode).equals(other$approvedStatusCode)) {
            return false;
        }
        Integer this$categoryId = this.getCategoryId();
        Integer other$categoryId = other.getCategoryId();
        if (this$categoryId == null ? other$categoryId != null : !((Object)this$categoryId).equals(other$categoryId)) {
            return false;
        }
        Integer this$statusId = this.getStatusId();
        Integer other$statusId = other.getStatusId();
        if (this$statusId == null ? other$statusId != null : !((Object)this$statusId).equals(other$statusId)) {
            return false;
        }
        Boolean this$hasVersions = this.getHasVersions();
        Boolean other$hasVersions = other.getHasVersions();
        if (this$hasVersions == null ? other$hasVersions != null : !((Object)this$hasVersions).equals(other$hasVersions)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$branch = this.getBranch();
        String other$branch = other.getBranch();
        if (this$branch == null ? other$branch != null : !this$branch.equals(other$branch)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
            return false;
        }
        String this$approvedStatus = this.getApprovedStatus();
        String other$approvedStatus = other.getApprovedStatus();
        if (this$approvedStatus == null ? other$approvedStatus != null : !this$approvedStatus.equals(other$approvedStatus)) {
            return false;
        }
        String this$approvedTime = this.getApprovedTime();
        String other$approvedTime = other.getApprovedTime();
        if (this$approvedTime == null ? other$approvedTime != null : !this$approvedTime.equals(other$approvedTime)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$remark = this.getRemark();
        String other$remark = other.getRemark();
        if (this$remark == null ? other$remark != null : !this$remark.equals(other$remark)) {
            return false;
        }
        String this$syncType = this.getSyncType();
        String other$syncType = other.getSyncType();
        if (this$syncType == null ? other$syncType != null : !this$syncType.equals(other$syncType)) {
            return false;
        }
        String this$categoryName = this.getCategoryName();
        String other$categoryName = other.getCategoryName();
        if (this$categoryName == null ? other$categoryName != null : !this$categoryName.equals(other$categoryName)) {
            return false;
        }
        String this$msgFormat = this.getMsgFormat();
        String other$msgFormat = other.getMsgFormat();
        if (this$msgFormat == null ? other$msgFormat != null : !this$msgFormat.equals(other$msgFormat)) {
            return false;
        }
        String this$requester = this.getRequester();
        String other$requester = other.getRequester();
        if (this$requester == null ? other$requester != null : !this$requester.equals(other$requester)) {
            return false;
        }
        String this$provider = this.getProvider();
        String other$provider = other.getProvider();
        if (this$provider == null ? other$provider != null : !this$provider.equals(other$provider)) {
            return false;
        }
        String this$tenantId = this.getTenantId();
        String other$tenantId = other.getTenantId();
        if (this$tenantId == null ? other$tenantId != null : !this$tenantId.equals(other$tenantId)) {
            return false;
        }
        String this$apiBuildAcct = this.getApiBuildAcct();
        String other$apiBuildAcct = other.getApiBuildAcct();
        if (this$apiBuildAcct == null ? other$apiBuildAcct != null : !this$apiBuildAcct.equals(other$apiBuildAcct)) {
            return false;
        }
        String this$apiBuildTime = this.getApiBuildTime();
        String other$apiBuildTime = other.getApiBuildTime();
        if (this$apiBuildTime == null ? other$apiBuildTime != null : !this$apiBuildTime.equals(other$apiBuildTime)) {
            return false;
        }
        String this$designTenantId = this.getDesignTenantId();
        String other$designTenantId = other.getDesignTenantId();
        if (this$designTenantId == null ? other$designTenantId != null : !this$designTenantId.equals(other$designTenantId)) {
            return false;
        }
        String this$teamId = this.getTeamId();
        String other$teamId = other.getTeamId();
        if (this$teamId == null ? other$teamId != null : !this$teamId.equals(other$teamId)) {
            return false;
        }
        String this$apiType = this.getApiType();
        String other$apiType = other.getApiType();
        if (this$apiType == null ? other$apiType != null : !this$apiType.equals(other$apiType)) {
            return false;
        }
        String this$projectName = this.getProjectName();
        String other$projectName = other.getProjectName();
        if (this$projectName == null ? other$projectName != null : !this$projectName.equals(other$projectName)) {
            return false;
        }
        List<String> this$projectVersionNameList = this.getProjectVersionNameList();
        List<String> other$projectVersionNameList = other.getProjectVersionNameList();
        if (this$projectVersionNameList == null ? other$projectVersionNameList != null : !((Object)this$projectVersionNameList).equals(other$projectVersionNameList)) {
            return false;
        }
        String this$projectVersionNameListStr = this.getProjectVersionNameListStr();
        String other$projectVersionNameListStr = other.getProjectVersionNameListStr();
        return !(this$projectVersionNameListStr == null ? other$projectVersionNameListStr != null : !this$projectVersionNameListStr.equals(other$projectVersionNameListStr));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ApiInfoResDto;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $apiId = this.getApiId();
        result = result * 59 + ($apiId == null ? 43 : ((Object)$apiId).hashCode());
        Integer $approvedStatusCode = this.getApprovedStatusCode();
        result = result * 59 + ($approvedStatusCode == null ? 43 : ((Object)$approvedStatusCode).hashCode());
        Integer $categoryId = this.getCategoryId();
        result = result * 59 + ($categoryId == null ? 43 : ((Object)$categoryId).hashCode());
        Integer $statusId = this.getStatusId();
        result = result * 59 + ($statusId == null ? 43 : ((Object)$statusId).hashCode());
        Boolean $hasVersions = this.getHasVersions();
        result = result * 59 + ($hasVersions == null ? 43 : ((Object)$hasVersions).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $branch = this.getBranch();
        result = result * 59 + ($branch == null ? 43 : $branch.hashCode());
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        String $approvedStatus = this.getApprovedStatus();
        result = result * 59 + ($approvedStatus == null ? 43 : $approvedStatus.hashCode());
        String $approvedTime = this.getApprovedTime();
        result = result * 59 + ($approvedTime == null ? 43 : $approvedTime.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $remark = this.getRemark();
        result = result * 59 + ($remark == null ? 43 : $remark.hashCode());
        String $syncType = this.getSyncType();
        result = result * 59 + ($syncType == null ? 43 : $syncType.hashCode());
        String $categoryName = this.getCategoryName();
        result = result * 59 + ($categoryName == null ? 43 : $categoryName.hashCode());
        String $msgFormat = this.getMsgFormat();
        result = result * 59 + ($msgFormat == null ? 43 : $msgFormat.hashCode());
        String $requester = this.getRequester();
        result = result * 59 + ($requester == null ? 43 : $requester.hashCode());
        String $provider = this.getProvider();
        result = result * 59 + ($provider == null ? 43 : $provider.hashCode());
        String $tenantId = this.getTenantId();
        result = result * 59 + ($tenantId == null ? 43 : $tenantId.hashCode());
        String $apiBuildAcct = this.getApiBuildAcct();
        result = result * 59 + ($apiBuildAcct == null ? 43 : $apiBuildAcct.hashCode());
        String $apiBuildTime = this.getApiBuildTime();
        result = result * 59 + ($apiBuildTime == null ? 43 : $apiBuildTime.hashCode());
        String $designTenantId = this.getDesignTenantId();
        result = result * 59 + ($designTenantId == null ? 43 : $designTenantId.hashCode());
        String $teamId = this.getTeamId();
        result = result * 59 + ($teamId == null ? 43 : $teamId.hashCode());
        String $apiType = this.getApiType();
        result = result * 59 + ($apiType == null ? 43 : $apiType.hashCode());
        String $projectName = this.getProjectName();
        result = result * 59 + ($projectName == null ? 43 : $projectName.hashCode());
        List<String> $projectVersionNameList = this.getProjectVersionNameList();
        result = result * 59 + ($projectVersionNameList == null ? 43 : ((Object)$projectVersionNameList).hashCode());
        String $projectVersionNameListStr = this.getProjectVersionNameListStr();
        result = result * 59 + ($projectVersionNameListStr == null ? 43 : $projectVersionNameListStr.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ApiInfoResDto(apiId=" + this.getApiId() + ", name=" + this.getName() + ", branch=" + this.getBranch() + ", version=" + this.getVersion() + ", approvedStatus=" + this.getApprovedStatus() + ", approvedTime=" + this.getApprovedTime() + ", approvedStatusCode=" + this.getApprovedStatusCode() + ", description=" + this.getDescription() + ", remark=" + this.getRemark() + ", syncType=" + this.getSyncType() + ", categoryId=" + this.getCategoryId() + ", categoryName=" + this.getCategoryName() + ", msgFormat=" + this.getMsgFormat() + ", requester=" + this.getRequester() + ", provider=" + this.getProvider() + ", tenantId=" + this.getTenantId() + ", apiBuildAcct=" + this.getApiBuildAcct() + ", apiBuildTime=" + this.getApiBuildTime() + ", designTenantId=" + this.getDesignTenantId() + ", teamId=" + this.getTeamId() + ", statusId=" + this.getStatusId() + ", apiType=" + this.getApiType() + ", projectName=" + this.getProjectName() + ", hasVersions=" + this.getHasVersions() + ", projectVersionNameList=" + this.getProjectVersionNameList() + ", projectVersionNameListStr=" + this.getProjectVersionNameListStr() + ")";
    }
}

