package com.digiwin.athena.apimgmt.model;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.List;

/**
 * The persistent class for the product_version database table.
 * 
 */
@Data
@TableName(value = "product_version", resultMap = "BaseResultMap")
public class ProductVersion implements Serializable {
	private static final long serialVersionUID = 1L;

    @TableId(type = IdType.AUTO)
	private Long id;

    @TableField("build_acct")
	private String buildAcct;

    @TableField("build_time")
    private LocalDateTime buildTime;

	private boolean isvalid;

    @TableField("last_update_acct")
	private String lastUpdateAcct;

    @TableField("last_update_time")
    private LocalDateTime lastUpdateTime;

	private String version;

	//bi-directional many-to-one association to PrdApiVersionMapping
    @TableField(exist = false)
	private List<PrdApiVersionMapping> prdApiVersionMappings;

	//bi-directional many-to-one association to Product
    @TableField(exist = false)
	private Product product;


}