/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.apimgmt.apiservice;

import com.digiwin.athena.apimgmt.constants.ApimgmtConstant;
import com.digiwin.athena.apimgmt.dao.ApiMgmtProductCategoryDao;
import com.digiwin.athena.apimgmt.dao.ApiMgmtRequiredDataNameDao;
import com.digiwin.athena.apimgmt.dao.ApiMgmtStandardApiCategoryDao;
import com.digiwin.athena.apimgmt.dao.ApiMgmtStandardApiGroupDao;
import com.digiwin.athena.apimgmt.dao.ApiMgmtStandardApiPagingDao;
import com.digiwin.athena.apimgmt.dao.ApiMgmtStandardApiSyncTypeDao;
import com.digiwin.athena.apimgmt.enums.ApiAttributeEnum;
import com.digiwin.athena.apimgmt.enums.LocaleEnum;
import com.digiwin.athena.apimgmt.infra.context.ApiMgmtServiceContextHolder;
import com.digiwin.athena.apimgmt.model.ProductCategory;
import com.digiwin.athena.apimgmt.model.RequiredDataName;
import com.digiwin.athena.apimgmt.model.StandardApiCategory;
import com.digiwin.athena.apimgmt.model.StandardApiDataName;
import com.digiwin.athena.apimgmt.model.StandardApiGroup;
import com.digiwin.athena.apimgmt.model.StandardApiPaging;
import com.digiwin.athena.apimgmt.model.StandardApiSyncType;
import com.digiwin.athena.apimgmt.service.util.ApiDataNameServiceUtil;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ApiMgmtDropdownMenuGetService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ApiMgmtDropdownMenuGetService.class);
    ObjectMapper mapper = new ObjectMapper();
    @Autowired
    ApiMgmtStandardApiSyncTypeDao standardApiSyncTypeDao;
    @Autowired
    ApiMgmtStandardApiPagingDao standardApiPagingDao;
    @Autowired
    ApiMgmtProductCategoryDao productCategoryDao;
    @Autowired
    ApiMgmtStandardApiGroupDao standardApiGroupDao;
    @Autowired
    ApiMgmtStandardApiCategoryDao standardApiCategoryDao;
    @Autowired
    ApiMgmtRequiredDataNameDao requiredDataNameDao;

    public Map<String, Object> execute(String validatorResult) {
        log.info("[Thread.id " + Thread.currentThread().getId() + "]\u63a5\u53e3\uff1a" + this.getClass() + "\uff0c\u539f\u59cb\u8a0a\u606f\uff1a" + validatorResult);
        String tLocale = ApiMgmtServiceContextHolder.getLocale();
        tLocale = tLocale == null ? LocaleEnum.EN_US.getType() : tLocale;
        HashMap<String, Object> tResponse = new HashMap<String, Object>();
        HashMap<String, List<Object>> tDropdownMenuMap = new HashMap<String, List<Object>>();
        List tStandardApiSyncTypeList = this.standardApiSyncTypeDao.getAll();
        List tStandardApiPagingList = this.standardApiPagingDao.getAll();
        List tProductCategoryList = this.productCategoryDao.getAll();
        List tStandardApiGroupList = this.standardApiGroupDao.getAll();
        List tStandardApiCategoryList = this.standardApiCategoryDao.getAll();
        List<RequiredDataName> tRequiredDataNameList = this.requiredDataNameDao.getAll();
        List<StandardApiDataName> tStandardApiDataNameList = this.into(tRequiredDataNameList);
        ArrayList tApiSyncTypeArr = new ArrayList();
        for (Object tStandardApiSyncType : tStandardApiSyncTypeList) {
            String tSyncTypeName;
            HashMap<String, String> tMap = new HashMap<String, String>();
            switch (tLocale) {
                case "zh_CN": {
                    tSyncTypeName = ((StandardApiSyncType)tStandardApiSyncType).getNameZhCn();
                    break;
                }
                case "zh_TW": {
                    tSyncTypeName = ((StandardApiSyncType)tStandardApiSyncType).getNameZhTw();
                    break;
                }
                default: {
                    tSyncTypeName = ((StandardApiSyncType)tStandardApiSyncType).getNameEnUs();
                }
            }
            if (((StandardApiSyncType)tStandardApiSyncType).getId() == 1L) {
                tMap.put("id", "sync");
            } else if (((StandardApiSyncType)tStandardApiSyncType).getId() == 2L) {
                tMap.put("id", "fasync");
            }
            tMap.put("name", tSyncTypeName);
            tApiSyncTypeArr.add(tMap);
        }
        tDropdownMenuMap.put("apiSyncType", tApiSyncTypeArr);
        ArrayList tApiPagingArr = new ArrayList();
        for (Object tStandardApiPaging : tStandardApiPagingList) {
            String tPagingName;
            HashMap<String, Object> tMap = new HashMap<String, Object>();
            switch (tLocale) {
                case "zh_CN": {
                    tPagingName = ((StandardApiPaging)tStandardApiPaging).getNameZhCn();
                    break;
                }
                case "zh_TW": {
                    tPagingName = ((StandardApiPaging)tStandardApiPaging).getNameZhTw();
                    break;
                }
                default: {
                    tPagingName = ((StandardApiPaging)tStandardApiPaging).getNameEnUs();
                }
            }
            tMap.put("id", ((StandardApiPaging)tStandardApiPaging).getId());
            tMap.put("name", tPagingName);
            tApiPagingArr.add(tMap);
        }
        tDropdownMenuMap.put("apiPaging", tApiPagingArr);
        ArrayList<String> tProductArr = new ArrayList<String>();
        for (ProductCategory tProductCategory : tProductCategoryList) {
            Object tProductName;
            switch (tLocale) {
                case "zh_CN": {
                    tProductName = tProductCategory.getNameZhCn();
                    break;
                }
                case "zh_TW": {
                    tProductName = tProductCategory.getNameZhTw();
                    break;
                }
                default: {
                    tProductName = tProductCategory.getNameEnUs();
                }
            }
            tProductArr.add((String)tProductName);
        }
        tDropdownMenuMap.put("requester", tProductArr);
        tDropdownMenuMap.put("provider", tProductArr);
        ArrayList<String> tIsBatchArr = new ArrayList<String>();
        tIsBatchArr.add("Y");
        tIsBatchArr.add("N");
        tDropdownMenuMap.put("isBatch", tIsBatchArr);
        ArrayList tApiGroupArr = new ArrayList();
        for (StandardApiGroup tStandardApiGroup : tStandardApiGroupList) {
            HashMap<String, Object> tMap = new HashMap<String, Object>();
            tMap.put("id", tStandardApiGroup.getId());
            switch (tLocale) {
                case "zh_CN": {
                    tMap.put("name", tStandardApiGroup.getNameZhCn());
                    break;
                }
                case "zh_TW": {
                    tMap.put("name", tStandardApiGroup.getNameZhTw());
                    break;
                }
                default: {
                    tMap.put("name", tStandardApiGroup.getNameEnUs());
                }
            }
            tApiGroupArr.add(tMap);
        }
        tDropdownMenuMap.put("apiGroup", tApiGroupArr);
        ArrayList tApiCategoryArr = new ArrayList();
        for (StandardApiCategory tStandardApiCategory : tStandardApiCategoryList) {
            String tCategoryName;
            HashMap<String, Object> tMap = new HashMap<String, Object>();
            if (tLocale != null) {
                switch (tLocale) {
                    case "zh_CN": {
                        tCategoryName = tStandardApiCategory.getNameZhCn();
                        break;
                    }
                    case "zh_TW": {
                        tCategoryName = tStandardApiCategory.getNameZhTw();
                        break;
                    }
                    default: {
                        tCategoryName = tStandardApiCategory.getNameEnUs();
                        break;
                    }
                }
            } else {
                tCategoryName = tStandardApiCategory.getNameZhTw();
            }
            tMap.put("id", tStandardApiCategory.getId());
            tMap.put("name", tCategoryName);
            tApiCategoryArr.add(tMap);
        }
        tDropdownMenuMap.put("apiCategory", tApiCategoryArr);
        ArrayList<String> tMsgFormatArr = new ArrayList<String>();
        tMsgFormatArr.add("XML");
        tMsgFormatArr.add("JSON");
        tDropdownMenuMap.put("msgFormat", tMsgFormatArr);
        tDropdownMenuMap.put("columnType", Arrays.asList(ApimgmtConstant.COLUMN_TYPE_ARRAY));
        tDropdownMenuMap.put("dataType", Arrays.asList(ApimgmtConstant.DATE_TYPE_ARRAY));
        tResponse.put("dropdownMenu", tDropdownMenuMap);
        ObjectNode tResponseNode = this.mapper.createObjectNode();
        ApiDataNameServiceUtil.setReaponseMessageSpec(tResponseNode, tStandardApiDataNameList, ApiAttributeEnum.requestMessageSpec.toString(), 1, tLocale);
        ApiDataNameServiceUtil.setReaponseMessageSpec(tResponseNode, tStandardApiDataNameList, ApiAttributeEnum.responseMessageSuccessSpec.toString(), 2, tLocale);
        ApiDataNameServiceUtil.setReaponseMessageSpec(tResponseNode, tStandardApiDataNameList, ApiAttributeEnum.responseMessageFailedSpec.toString(), 3, tLocale);
        Map<String, Object> tMessageSpecMap = this.converJsonNodeToMap((JsonNode)tResponseNode);
        for (String tKey : tMessageSpecMap.keySet()) {
            tResponse.put(tKey, tMessageSpecMap.get(tKey));
        }
        return tResponse;
    }

    private List<StandardApiDataName> into(List<RequiredDataName> pRequiredDataNameList) {
        ArrayList<StandardApiDataName> tStandardApiDataNameList = new ArrayList<StandardApiDataName>();
        for (RequiredDataName tRequiredDataName : pRequiredDataNameList) {
            StandardApiDataName tStandardApiDataName = new StandardApiDataName();
            tStandardApiDataName.setId((long)tRequiredDataName.getId());
            tStandardApiDataName.setMsgType(tRequiredDataName.getMsgType());
            tStandardApiDataName.setColumnType(tRequiredDataName.getColumnType());
            tStandardApiDataName.setStandardDataName(tRequiredDataName.getDataName());
            tStandardApiDataName.setDescriptionZhTw(tRequiredDataName.getDescriptionZhTw());
            tStandardApiDataName.setDescriptionZhCn(tRequiredDataName.getDescriptionZhCn());
            tStandardApiDataName.setDescriptionEnUs(tRequiredDataName.getDescriptionEnUs());
            tStandardApiDataName.setDataType(tRequiredDataName.getDataType());
            tStandardApiDataName.setIsRequired(tRequiredDataName.getIsRequired());
            tStandardApiDataName.setValue(tRequiredDataName.getValue());
            tStandardApiDataName.setRemarkZhTw(tRequiredDataName.getRemarkZhTw());
            tStandardApiDataName.setRemarkZhCn(tRequiredDataName.getRemarkZhCn());
            tStandardApiDataName.setRemarkEnUs(tRequiredDataName.getRemarkEnUs());
            tStandardApiDataName.setIsDatakey(tRequiredDataName.getIsDatakey());
            tStandardApiDataName.setIsArray(tRequiredDataName.getIsArray());
            tStandardApiDataName.setCanSort(tRequiredDataName.getCanSort());
            tStandardApiDataName.setCanFilter(tRequiredDataName.getCanFilter());
            tStandardApiDataName.setIsBusinesskey(tRequiredDataName.getIsBusinesskey());
            tStandardApiDataName.setListEnumZhTw(tRequiredDataName.getListEnumZhTw());
            tStandardApiDataName.setListEnumZhCn(tRequiredDataName.getListEnumZhCn());
            tStandardApiDataName.setListEnumEn(tRequiredDataName.getListEnumEn());
            tStandardApiDataNameList.add(tStandardApiDataName);
        }
        return tStandardApiDataNameList;
    }

    private Map<String, Object> converJsonNodeToMap(JsonNode pJsonNode) {
        return (Map)this.mapper.convertValue((Object)pJsonNode, (TypeReference)new TypeReference<Map<String, Object>>(){});
    }
}

