package com.digiwin.athena.apimgmt.apiservice;

import com.digiwin.athena.apimgmt.constants.ApimgmtConstant;
import com.digiwin.athena.apimgmt.dao.impl.mybatis.mapper.ApiMgmtApprovedStatusMapper;
import com.digiwin.athena.apimgmt.dao.impl.mybatis.mapper.ApiMgmtStandardApiCategoryMapper;
import com.digiwin.athena.apimgmt.dao.impl.mybatis.mapper.ApiMgmtStandardApiMapper;
import com.digiwin.athena.apimgmt.dao.impl.mybatis.mapper.ApiMgmtStandardApiSyncTypeMapper;
import com.digiwin.athena.apimgmt.dao.impl.mybatis.mapper.ApiMgmtStandardApiVersionMapper;
import com.digiwin.athena.apimgmt.dto.ApiInfoResDto;
import com.digiwin.athena.apimgmt.dto.PageReqCondition;
import com.digiwin.athena.apimgmt.dto.PaginationResDto;
import com.digiwin.athena.apimgmt.infra.context.ApiMgmtServiceContextHolder;
import com.digiwin.athena.apimgmt.model.ApprovedStatus;
import com.digiwin.athena.apimgmt.model.StandardApi;
import com.digiwin.athena.apimgmt.model.StandardApiCategory;
import com.digiwin.athena.apimgmt.model.StandardApiSyncType;
import com.digiwin.athena.apimgmt.model.StandardApiVersion;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@Slf4j
@Service
public class ApiMgmtServiceV2 {
    @Autowired
    private ApiMgmtStandardApiVersionMapper apiMgmtStandardApiVersionMapper;
    @Autowired
    private ApiMgmtApprovedStatusMapper apiMgmtApprovedStatusMapper;
    @Autowired
    private ApiMgmtStandardApiCategoryMapper apiMgmtStandardApiCategoryMapper;
    @Autowired
    private ApiMgmtStandardApiMapper apiMgmtStandardApiMapper;
    @Autowired
    private ApiMgmtStandardApiSyncTypeMapper apiMgmtStandardApiSyncTypeMapper;

    @Autowired
    private AdvanceSearchApiListGetOtherService advanceSearchApiListGetOtherService;

    public PaginationResDto<List<ApiInfoResDto>> searchApi(PageReqCondition<String> pagination) {
        PageHelper.startPage(pagination.getPageNum(), pagination.getPageSize());
        List<StandardApiVersion> standardApiVersionList = apiMgmtStandardApiVersionMapper.searchApi(pagination.getCondition());

        PageInfo<StandardApiVersion> pageInfo = new PageInfo<>(standardApiVersionList);

        PaginationResDto paginationResDto = new PaginationResDto();
        paginationResDto.setPageTotal(Long.valueOf(pageInfo.getTotal()).intValue());
        paginationResDto.setPageSize(pageInfo.getPageSize());
        paginationResDto.setPageNum(pageInfo.getPageNum());

        List<ApiInfoResDto> res = new ArrayList<>();

        if (!standardApiVersionList.isEmpty()) {
            List<Long> apiIds = standardApiVersionList.stream().map(StandardApiVersion::getApiId).collect(Collectors.toList());
            List<ApprovedStatus> approvedStatuses = apiMgmtApprovedStatusMapper.selectList(null);
            List<StandardApiCategory> standardApiCategories = apiMgmtStandardApiCategoryMapper.selectList(null);
            List<StandardApiSyncType> standardApiSyncTypes = apiMgmtStandardApiSyncTypeMapper.selectList(null);
            List<StandardApi> standardApis = apiMgmtStandardApiMapper.selectBatchIds(apiIds);
            advanceSearchApiListGetOtherService.setProjectAndVersion(standardApis);

            Map<Long, ApprovedStatus> approvedStatuseMap = approvedStatuses.stream().collect(Collectors.toMap(ApprovedStatus::getId, s -> s));
            Map<Long, StandardApi> standardApiMap = standardApis.stream().collect(Collectors.toMap(StandardApi::getId, s -> s));
            Map<Long, StandardApiCategory> standardApiCategoriesMap = standardApiCategories.stream().collect(Collectors.toMap(StandardApiCategory::getId, s -> s));
            Map<Long, StandardApiSyncType> standardApiSyncTypeMap = standardApiSyncTypes.stream().collect(Collectors.toMap(StandardApiSyncType::getId, s -> s));
            res = standardApiVersionList.stream().map(s -> {
                ApprovedStatus approvedStatus = approvedStatuseMap.get(Long.valueOf(s.getApprovedStatusCode()));
                StandardApi standardApi = standardApiMap.get(Long.valueOf(s.getApiId()));
                StandardApiCategory standardApiCategory = standardApiCategoriesMap.get(Long.valueOf(standardApi.getCategory()));
                StandardApiSyncType standardApiSyncType = standardApiSyncTypeMap.get(Long.valueOf(standardApi.getSyncType()));

                ApiInfoResDto apiInfoResDto = ApiInfoResDto.create(s,standardApi,approvedStatus,standardApiCategory,standardApiSyncType);



                return apiInfoResDto;
            }).collect(Collectors.toList());
        }
        paginationResDto.setValue(res);

        return paginationResDto;
    }
}
