package com.digiwin.athena.apimgmt.model;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * The persistent class for the standard_api database table.
 * 
 */
@Data
@TableName(value = "verify_log", resultMap = "BaseResultMap")
public class VerifyLog implements Serializable {
	private static final long serialVersionUID = 1L;

    @TableId(type = IdType.AUTO)
	private Long id;

    @TableField("api_ver_id")
	private Long apiVerId;

    @TableField("verify_acct")
    private String verifyAcct;

    @TableField("verify_time")
    private LocalDateTime verifyTime;

    @TableField("verity_operate")
    private Long verityOperateId;

    @TableField(exist = false)
	private VerityOperate verityOperate;

    @TableField("reason")
	private String reason;


    public void setVerityOperate(VerityOperate verityOperate) {
		this.verityOperate = verityOperate;
		if (verityOperate != null) {
			this.verityOperateId = verityOperate.getId();
		}
	}

    public VerifyLog() {
	}

}