package com.digiwin.athena.apimgmt.service.util;

import com.digiwin.athena.apimgmt.model.StandardApi;
import com.digiwin.athena.apimgmt.model.StandardApiDataName;
import com.digiwin.athena.apimgmt.services.ApiMgmtStandardApiFileReadService;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.io.InputStream;
import java.util.List;
import java.util.Map;

/**
 * 文件读取处理类util
 */
@Service
public class StandardApiFileReadServiceUtil extends GenericServiceUtil<ApiMgmtStandardApiFileReadService> {

	private static ApiMgmtStandardApiFileReadService service;

	@Override
	@Autowired
	public void setService(ApiMgmtStandardApiFileReadService pService) {
		service = pService;
	}

	public static Workbook getWorkBook(String pFileType, InputStream pFileIn) throws Exception {
		return service.getWorkBook(pFileType, pFileIn);
	}

	public static List<Map<String, String>> setStandardApi(StandardApi pStandardApi, String pApplicant, Sheet pSheet, String pLocale) throws Exception {
		return service.setStandardApi(pStandardApi, pApplicant, pSheet, pLocale);
	}

	public static Map<String, String> setStandardApiBasicInfo(StandardApi pStandardApi, String pApplicant, Sheet pSheet) throws Exception {
		return service.setStandardApiBasicInfo(pStandardApi, pApplicant, pSheet);
	}

	public static List<Map<String, String>> setStandardApiDataName(StandardApi pStandardApi, Map<String, StandardApiDataName> pDataNameMap, Sheet pSheet, Boolean pCheckDataName, String pLocale, boolean pSkipReview, String pLoginAcct) throws Exception {
		return service.setStandardApiDataName(pStandardApi, pDataNameMap, pSheet, pCheckDataName, pLocale, pSkipReview, pLoginAcct);
	}

	public static void addDuplicateDescription(Workbook pWorkBook, Sheet pSheet, String pDuplicateType, String pOtherUser) {
		service.addDuplicateDescription(pWorkBook, pSheet, pDuplicateType, pOtherUser);
	}

	public static void uploadCheckResult(List<Map<String, String>> pResult, String pReason, Long pSolutionId, String pDataName, int pRowNumber, int pColumnNumber, String pLocale) {
		service.uploadCheckResult(pResult, pReason, pSolutionId, pDataName, pRowNumber, pColumnNumber, pLocale);
	}

	public static void writeImportErrorFile(Sheet pSheet, Map<String, List<Map<String, String>>> pTotalApiErrorMap) {
		service.writeImportErrorFile(pSheet, pTotalApiErrorMap);
	}

}
