/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.apimgmt.services;

import cn.hutool.core.collection.CollUtil;
import com.digiwin.athena.apimgmt.dao.ApiMgmtProjectVersionRelationDao;
import com.digiwin.athena.apimgmt.dao.ApiMgmtStandardApiDao;
import com.digiwin.athena.apimgmt.facade.dto.ApiMgmtApiInfoDTO;
import com.digiwin.athena.apimgmt.facade.dto.ApiMgmtApiKeyDTO;
import com.digiwin.athena.apimgmt.facade.dto.ApiMgmtApiProjectVerDTO;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ApiMgmtStandardApiService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ApiMgmtStandardApiService.class);
    private final ApiMgmtStandardApiDao standardApiDao;
    private final ApiMgmtProjectVersionRelationDao projectVersionRelationDao;

    public List<ApiMgmtApiInfoDTO> queryByKey(List<ApiMgmtApiKeyDTO> apiKeys) {
        List<ApiMgmtApiInfoDTO> result = this.standardApiDao.queryByKey(apiKeys);
        if (CollUtil.isEmpty(result)) {
            return result;
        }
        List<Long> apiIds = result.stream().map(ApiMgmtApiInfoDTO::getApiId).distinct().collect(Collectors.toList());
        Map<Long, List<ApiMgmtApiProjectVerDTO>> apiIdProjectVerMap = this.projectVersionRelationDao.selectProjectVerMapByApi(apiIds);
        result.forEach(dto -> {
            List versionNames = (List)apiIdProjectVerMap.get(dto.getApiId());
            if (CollUtil.isNotEmpty((Collection)versionNames)) {
                ApiMgmtApiProjectVerDTO first = (ApiMgmtApiProjectVerDTO)versionNames.get(0);
                dto.setProjectCode(first.getProjectName());
                dto.setProjectHasVersions(first.getProjectHasVersion());
                dto.setProjectVersionNameList(CollUtil.map((Iterable)versionNames, ApiMgmtApiProjectVerDTO::getProjectVerName, (boolean)true));
            }
        });
        return result;
    }

    @Generated
    public ApiMgmtStandardApiService(ApiMgmtStandardApiDao standardApiDao, ApiMgmtProjectVersionRelationDao projectVersionRelationDao) {
        this.standardApiDao = standardApiDao;
        this.projectVersionRelationDao = projectVersionRelationDao;
    }
}

