package com.digiwin.athena.apimgmt.dao.impl.mybatis;

import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.digiwin.athena.apimgmt.dao.ApiMgmtStandardDataNameDao;
import com.digiwin.athena.apimgmt.dao.impl.mybatis.mapper.ApiMgmtStandardDataNameMapper;
import com.digiwin.athena.apimgmt.enums.StandardApiSearchEnum;
import com.digiwin.athena.apimgmt.model.StandardDataName;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Repository;

import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Primary
@Repository
public class ApiMgmtStandardDataNameDaoMybatisImpl extends GenericDaoMybatisImpl<ApiMgmtStandardDataNameMapper, StandardDataName, String>
        implements ApiMgmtStandardDataNameDao {

    public ApiMgmtStandardDataNameDaoMybatisImpl() {
        super();
    }

    @Override
    public StandardDataName add(StandardDataName standardDataName) {
        standardDataName.setBuildTime(LocalDateTime.now());
        standardDataName.setLastUpdateTime(LocalDateTime.now());

        baseMapper.insert(standardDataName);
        return standardDataName;
    }

    @Override
    public StandardDataName update(StandardDataName standardDataName) {
        standardDataName.setLastUpdateTime(LocalDateTime.now());

        baseMapper.updateById(standardDataName);
        return standardDataName;
    }

    @Override
    public Integer getRecordSize(Map<String, String> pConditions) {
        Map<String, Object> param = new HashMap<>(pConditions);
        Converter.INSTANCE.splitVal(param, StandardApiSearchEnum.NAME);

        Converter.INSTANCE.splitVal(param, StandardApiSearchEnum.DESCRIPTION_ZH_TW);
        Converter.INSTANCE.splitVal(param, StandardApiSearchEnum.DESCRIPTION_ZH_CN);
        Converter.INSTANCE.splitVal(param, StandardApiSearchEnum.DESCRIPTION_EN_US);

        Converter.INSTANCE.splitVal(param, StandardApiSearchEnum.REMARK_ZH_TW);
        Converter.INSTANCE.splitVal(param, StandardApiSearchEnum.REMARK_ZH_CN);
        Converter.INSTANCE.splitVal(param, StandardApiSearchEnum.REMARK_EN_US);


        return baseMapper.getRecordSize(pConditions);
    }

    @Override
    public List<StandardDataName> fetch(Map<String, String> pConditions) {
        MpPage<StandardDataName> page = MpPage.from(pConditions);
        return baseMapper.fetch(pConditions, page);
    }

    @Override
    public Boolean getExist(String pName) {
        return baseMapper.selectCount(
                Wrappers.lambdaQuery(StandardDataName.class)
                        .eq(StandardDataName::getDataName, pName)
        ) > 0;
    }

    @Override
    public List<String> getAllDataName() {
        return baseMapper.getAllDataName();
    }

    @Override
    public List<String> getAllType(String pLang) {
        return baseMapper.getAllType(pLang);
    }

    @Override
    public List<StandardDataName> getDataNameOrderByTime() {
        return baseMapper.getDataNameOrderByTime();
    }

    @Override
    public Long getDataNameCount() {
        return baseMapper.getDataNameCount();
    }

    @Override
    public Boolean delete(String pDataName) {
        return baseMapper.deleteById(pDataName) > 0;
    }

    @Override
    public List<StandardDataName> getDataNameByApprovedStatus(long pApprovedStatus, boolean pOrderByBuildtime) {
        return baseMapper.getDataNameByApprovedStatus(pApprovedStatus, pOrderByBuildtime);
    }


    public static class Converter {
        public static final Converter INSTANCE = new Converter();
        public static final String separator = " ";

        public void splitVal(Map<String, Object> paramMap, StandardApiSearchEnum keyEnum) {
            String keyStr = keyEnum.toString();

            String str = MapUtil.getStr(paramMap, keyStr);
            paramMap.put(keyStr, split(str));
        }

        public List<String> split(String str) {
            return StrUtil.split(str, separator);
        }
    }
}
